/*
 * Decompiled with CFR 0.152.
 */
package test.org.apache.spark.sql.execution.sort;

import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.MemoryManager;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.memory.TestMemoryConsumer;
import org.apache.spark.memory.TestMemoryManager;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.RecordBinaryComparator;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.UnsafeAlignedOffset;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecordBinaryComparatorSuite {
    private final TaskMemoryManager memoryManager = new TaskMemoryManager((MemoryManager)new TestMemoryManager(new SparkConf().set(package$.MODULE$.MEMORY_OFFHEAP_ENABLED(), (Object)false)), 0L);
    private final TestMemoryConsumer consumer = new TestMemoryConsumer(this.memoryManager);
    private final int uaoSize = UnsafeAlignedOffset.getUaoSize();
    private MemoryBlock dataPage;
    private long pageCursor;
    private LongArray array;
    private int pos;
    private final RecordComparator binaryComparator = new RecordBinaryComparator();

    @Before
    public void beforeEach() {
        this.array = this.consumer.allocateArray(2L);
        this.pos = 0;
        this.dataPage = this.memoryManager.allocatePage(4096L, (MemoryConsumer)this.consumer);
        this.pageCursor = this.dataPage.getBaseOffset();
    }

    @After
    public void afterEach() {
        this.consumer.freePage(this.dataPage);
        this.dataPage = null;
        this.pageCursor = 0L;
        this.consumer.freeArray(this.array);
        this.array = null;
        this.pos = 0;
    }

    private void insertRow(UnsafeRow row) {
        Object recordBase = row.getBaseObject();
        long recordOffset = row.getBaseOffset();
        int recordLength = row.getSizeInBytes();
        Object baseObject = this.dataPage.getBaseObject();
        Assert.assertTrue((this.pageCursor + (long)recordLength <= this.dataPage.getBaseOffset() + this.dataPage.size() ? 1 : 0) != 0);
        long recordAddress = this.memoryManager.encodePageNumberAndOffset(this.dataPage, this.pageCursor);
        UnsafeAlignedOffset.putSize((Object)baseObject, (long)this.pageCursor, (int)recordLength);
        this.pageCursor += (long)this.uaoSize;
        Platform.copyMemory((Object)recordBase, (long)recordOffset, (Object)baseObject, (long)this.pageCursor, (long)recordLength);
        this.pageCursor += (long)recordLength;
        Assert.assertTrue((this.pos < 2 ? 1 : 0) != 0);
        this.array.set(this.pos, recordAddress);
        ++this.pos;
    }

    private int compare(int index1, int index2) {
        Object baseObject = this.dataPage.getBaseObject();
        long recordAddress1 = this.array.get(index1);
        long baseOffset1 = this.memoryManager.getOffsetInPage(recordAddress1) + (long)this.uaoSize;
        int recordLength1 = UnsafeAlignedOffset.getSize((Object)baseObject, (long)(baseOffset1 - (long)this.uaoSize));
        long recordAddress2 = this.array.get(index2);
        long baseOffset2 = this.memoryManager.getOffsetInPage(recordAddress2) + (long)this.uaoSize;
        int recordLength2 = UnsafeAlignedOffset.getSize((Object)baseObject, (long)(baseOffset2 - (long)this.uaoSize));
        return this.binaryComparator.compare(baseObject, baseOffset1, recordLength1, baseObject, baseOffset2, recordLength2);
    }

    private int computeSizeInBytes(int originalSize) {
        return 8 + (originalSize + 7) / 8 * 8;
    }

    private long relativeOffset(int numFields) {
        return 8L + (long)numFields * 8L;
    }

    @Test
    public void testBinaryComparatorForSingleColumnRow() throws Exception {
        int numFields = 1;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8));
        row1.setInt(0, 11);
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8));
        row2.setInt(0, 42);
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertEquals((long)0L, (long)this.compare(0, 0));
        Assert.assertTrue((this.compare(0, 1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryComparatorForMultipleColumnRow() throws Exception {
        int numFields = 5;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8));
        for (int i = 0; i < numFields; ++i) {
            row1.setDouble(i, (double)i * 3.14);
        }
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8));
        for (int i = 0; i < numFields; ++i) {
            row2.setDouble(i, 198.7 / (double)(i + 1));
        }
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertEquals((long)0L, (long)this.compare(0, 0));
        Assert.assertTrue((this.compare(0, 1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryComparatorForArrayColumn() throws Exception {
        int numFields = 1;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        UnsafeArrayData arrayData1 = UnsafeArrayData.fromPrimitiveArray((int[])new int[]{11, 42, -1});
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8 + arrayData1.getSizeInBytes()));
        row1.setLong(0, this.relativeOffset(numFields) << 32 | (long)arrayData1.getSizeInBytes());
        Platform.copyMemory((Object)arrayData1.getBaseObject(), (long)arrayData1.getBaseOffset(), (Object)data1, (long)(row1.getBaseOffset() + this.relativeOffset(numFields)), (long)arrayData1.getSizeInBytes());
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        UnsafeArrayData arrayData2 = UnsafeArrayData.fromPrimitiveArray((int[])new int[]{22});
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8 + arrayData2.getSizeInBytes()));
        row2.setLong(0, this.relativeOffset(numFields) << 32 | (long)arrayData2.getSizeInBytes());
        Platform.copyMemory((Object)arrayData2.getBaseObject(), (long)arrayData2.getBaseOffset(), (Object)data2, (long)(row2.getBaseOffset() + this.relativeOffset(numFields)), (long)arrayData2.getSizeInBytes());
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertEquals((long)0L, (long)this.compare(0, 0));
        Assert.assertTrue((this.compare(0, 1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryComparatorForMixedColumns() throws Exception {
        int numFields = 4;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        UTF8String str1 = UTF8String.fromString((String)"Milk tea");
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8 + str1.numBytes()));
        row1.setInt(0, 11);
        row1.setDouble(1, 3.14);
        row1.setInt(2, -1);
        row1.setLong(3, this.relativeOffset(numFields) << 32 | (long)str1.numBytes());
        Platform.copyMemory((Object)str1.getBaseObject(), (long)str1.getBaseOffset(), (Object)data1, (long)(row1.getBaseOffset() + this.relativeOffset(numFields)), (long)str1.numBytes());
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        UTF8String str2 = UTF8String.fromString((String)"Java");
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8 + str2.numBytes()));
        row2.setInt(0, 11);
        row2.setDouble(1, 3.14);
        row2.setInt(2, -1);
        row2.setLong(3, this.relativeOffset(numFields) << 32 | (long)str2.numBytes());
        Platform.copyMemory((Object)str2.getBaseObject(), (long)str2.getBaseOffset(), (Object)data2, (long)(row2.getBaseOffset() + this.relativeOffset(numFields)), (long)str2.numBytes());
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertEquals((long)0L, (long)this.compare(0, 0));
        Assert.assertTrue((this.compare(0, 1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryComparatorForNullColumns() throws Exception {
        int numFields = 3;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8));
        for (int i = 0; i < numFields; ++i) {
            row1.setNullAt(i);
        }
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8));
        for (int i = 0; i < numFields - 1; ++i) {
            row2.setNullAt(i);
        }
        row2.setDouble(numFields - 1, 3.14);
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertEquals((long)0L, (long)this.compare(0, 0));
        Assert.assertTrue((this.compare(0, 1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryComparatorWhenSubtractionIsDivisibleByMaxIntValue() throws Exception {
        int numFields = 1;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8));
        row1.setLong(0, 11L);
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8));
        row2.setLong(0, 0x8000000AL);
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertTrue((this.compare(0, 1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryComparatorWhenSubtractionCanOverflowLongValue() throws Exception {
        int numFields = 1;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8));
        row1.setLong(0, Long.MIN_VALUE);
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8));
        row2.setLong(0, 1L);
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertTrue((this.compare(0, 1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBinaryComparatorWhenOnlyTheLastColumnDiffers() throws Exception {
        int numFields = 4;
        UnsafeRow row1 = new UnsafeRow(numFields);
        byte[] data1 = new byte[100];
        row1.pointTo(data1, this.computeSizeInBytes(numFields * 8));
        row1.setInt(0, 11);
        row1.setDouble(1, 3.14);
        row1.setInt(2, -1);
        row1.setLong(3, 0L);
        UnsafeRow row2 = new UnsafeRow(numFields);
        byte[] data2 = new byte[100];
        row2.pointTo(data2, this.computeSizeInBytes(numFields * 8));
        row2.setInt(0, 11);
        row2.setDouble(1, 3.14);
        row2.setInt(2, -1);
        row2.setLong(3, 1L);
        this.insertRow(row1);
        this.insertRow(row2);
        Assert.assertTrue((this.compare(0, 1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCompareLongsAsLittleEndian() {
        long arrayOffset = Platform.LONG_ARRAY_OFFSET + 4;
        long[] arr1 = new long[2];
        Platform.putLong((Object)arr1, (long)arrayOffset, (long)0x100000000000000L);
        long[] arr2 = new long[2];
        Platform.putLong((Object)arr2, (long)(arrayOffset + 4L), (long)1L);
        int result1 = this.binaryComparator.compare((Object)arr1, arrayOffset, 8, (Object)arr2, arrayOffset + 4L, 8);
        long[] arr3 = new long[2];
        Platform.putLong((Object)arr3, (long)arrayOffset, (long)0x100000000000000L);
        long[] arr4 = new long[2];
        Platform.putLong((Object)arr4, (long)arrayOffset, (long)1L);
        int result2 = this.binaryComparator.compare((Object)arr3, arrayOffset, 8, (Object)arr4, arrayOffset, 8);
        Assert.assertEquals((long)result1, (long)result2);
    }

    @Test
    public void testCompareLongsAsUnsigned() {
        long arrayOffset = Platform.LONG_ARRAY_OFFSET + 4;
        long[] arr1 = new long[2];
        Platform.putLong((Object)arr1, (long)(arrayOffset + 4L), (long)-6917529027641081856L);
        long[] arr2 = new long[2];
        Platform.putLong((Object)arr2, (long)(arrayOffset + 4L), (long)0L);
        int result1 = this.binaryComparator.compare((Object)arr1, arrayOffset + 4L, 8, (Object)arr2, arrayOffset + 4L, 8);
        long[] arr3 = new long[2];
        Platform.putLong((Object)arr3, (long)arrayOffset, (long)-6917529027641081856L);
        long[] arr4 = new long[2];
        Platform.putLong((Object)arr4, (long)arrayOffset, (long)0L);
        int result2 = this.binaryComparator.compare((Object)arr3, arrayOffset, 8, (Object)arr4, arrayOffset, 8);
        Assert.assertEquals((long)result1, (long)result2);
    }
}

