/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.spark.benchmark.Benchmark;
import org.apache.spark.benchmark.Benchmark$;
import org.apache.spark.benchmark.BenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.util.DateTimeTestUtils$;
import org.apache.spark.sql.execution.benchmark.DateTime$;
import org.apache.spark.sql.execution.benchmark.SqlBasedBenchmark;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class DateTimeRebaseBenchmark$
extends BenchmarkBase
implements SqlBasedBenchmark {
    public static DateTimeRebaseBenchmark$ MODULE$;
    private final SparkSession spark;
    private String sparkHome;
    private volatile boolean bitmap$0;

    static {
        new DateTimeRebaseBenchmark$();
    }

    @Override
    public SparkSession getSparkSession() {
        return SqlBasedBenchmark.getSparkSession$(this);
    }

    @Override
    public final void codegenBenchmark(String name, long cardinality, Function0<BoxedUnit> f) {
        SqlBasedBenchmark.codegenBenchmark$(this, name, cardinality, f);
    }

    @Override
    public SqlBasedBenchmark.DatasetToBenchmark DatasetToBenchmark(Dataset<?> ds) {
        return SqlBasedBenchmark.DatasetToBenchmark$(this, ds);
    }

    @Override
    public void prepareDataInfo(Benchmark benchmark) {
        SqlBasedBenchmark.prepareDataInfo$(this, benchmark);
    }

    @Override
    public StructType writeWideRow(String path, int rowsNum, int numCols) {
        return SqlBasedBenchmark.writeWideRow$(this, path, rowsNum, numCols);
    }

    @Override
    public void afterAll() {
        SqlBasedBenchmark.afterAll$(this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLHelper.withSQLConf$((SQLHelper)this, pairs, f);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    @Override
    public SparkSession spark() {
        return this.spark;
    }

    @Override
    public void org$apache$spark$sql$execution$benchmark$SqlBasedBenchmark$_setter_$spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    private String sparkHome$lzycompute() {
        DateTimeRebaseBenchmark$ dateTimeRebaseBenchmark$ = this;
        synchronized (dateTimeRebaseBenchmark$) {
            if (!this.bitmap$0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if (!this.bitmap$0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    private Dataset<Row> genTs(int cardinality, LocalDateTime start, LocalDateTime end) {
        long startSec = start.toEpochSecond(ZoneOffset.UTC);
        long endSec = end.toEpochSecond(ZoneOffset.UTC);
        return this.spark().range(0L, (long)cardinality, 1L, 1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToLong((long)(endSec - startSec))).$plus((Object)BoxesRunTime.boxToLong((long)startSec)).as("seconds")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seconds"}))).$((Seq)Nil$.MODULE$).cast("timestamp").as("ts")}));
    }

    private Dataset<Row> genTsAfter1900(int cardinality) {
        LocalDateTime start = LocalDateTime.of(1900, 1, 31, 0, 0, 0);
        LocalDateTime end = LocalDateTime.of(3000, 1, 1, 0, 0, 0);
        return this.genTs(cardinality, start, end);
    }

    private Dataset<Row> genTsBefore1900(int cardinality) {
        LocalDateTime start = LocalDateTime.of(10, 1, 1, 0, 0, 0);
        LocalDateTime end = LocalDateTime.of(1900, 1, 1, 0, 0, 0);
        return this.genTs(cardinality, start, end);
    }

    private Dataset<Row> genDate(int cardinality, LocalDate start, LocalDate end) {
        long startSec = LocalDateTime.of(start, LocalTime.MIDNIGHT).toEpochSecond(ZoneOffset.UTC);
        long endSec = LocalDateTime.of(end, LocalTime.MIDNIGHT).toEpochSecond(ZoneOffset.UTC);
        return this.spark().range(0L, (long)cardinality * 86400L, 86400L, 1).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"}))).$((Seq)Nil$.MODULE$).$percent((Object)BoxesRunTime.boxToLong((long)(endSec - startSec))).$plus((Object)BoxesRunTime.boxToLong((long)startSec)).as("seconds")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"seconds"}))).$((Seq)Nil$.MODULE$).cast("timestamp").as("ts")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.spark().implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ts"}))).$((Seq)Nil$.MODULE$).cast("date").as("date")}));
    }

    private Dataset<Row> genDateAfter1582(int cardinality) {
        LocalDate start = LocalDate.of(1582, 10, 31);
        LocalDate end = LocalDate.of(3000, 1, 1);
        return this.genDate(cardinality, start, end);
    }

    private Dataset<Row> genDateBefore1582(int cardinality) {
        LocalDate start = LocalDate.of(10, 1, 1);
        LocalDate end = LocalDate.of(1580, 10, 1);
        return this.genDate(cardinality, start, end);
    }

    private Dataset<Row> genDF(int cardinality, Enumeration.Value dateTime, boolean modernDates) {
        boolean bl;
        Enumeration.Value value = dateTime;
        Enumeration.Value value2 = DateTime$.MODULE$.DATE();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            if (modernDates) {
                return this.genDateAfter1582(cardinality);
            }
            return this.genDateBefore1582(cardinality);
        }
        Enumeration.Value value4 = DateTime$.MODULE$.TIMESTAMP();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            bl = true;
        } else {
            Enumeration.Value value6 = DateTime$.MODULE$.TIMESTAMP_INT96();
            Enumeration.Value value7 = value;
            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                bl = true;
            } else {
                Enumeration.Value value8 = DateTime$.MODULE$.TIMESTAMP_MICROS();
                Enumeration.Value value9 = value;
                if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                    bl = true;
                } else {
                    Enumeration.Value value10 = DateTime$.MODULE$.TIMESTAMP_MILLIS();
                    Enumeration.Value value11 = value;
                    bl = !(value10 != null ? !value10.equals(value11) : value11 != null);
                }
            }
        }
        if (bl) {
            if (modernDates) {
                return this.genTsAfter1900(cardinality);
            }
            return this.genTsBefore1900(cardinality);
        }
        throw new IllegalArgumentException(new StringBuilder(41).append("cardinality = ").append(cardinality).append(" dateTime = ").append(dateTime).append(" modernDates = ").append(modernDates).toString());
    }

    private void benchmarkInputs(Benchmark benchmark, int rowsNum, Enumeration.Value dateTime) {
        Enumeration.Value value = dateTime;
        Enumeration.Value value2 = DateTime$.MODULE$.DATE();
        int year = !(value != null ? !value.equals(value2) : value2 != null) ? 1582 : 1900;
        benchmark.addCase(new StringBuilder(12).append("after ").append(year).append(", noop").toString(), 1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> MODULE$.DatasetToBenchmark(MODULE$.genDF(rowsNum, dateTime, true)).noop());
        benchmark.addCase(new StringBuilder(13).append("before ").append(year).append(", noop").toString(), 1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> MODULE$.DatasetToBenchmark(MODULE$.genDF(rowsNum, dateTime, false)).noop());
    }

    private String flagToStr(boolean flag) {
        if (flag) {
            return "on";
        }
        return "off";
    }

    private String caseName(boolean modernDates, Enumeration.Value dateTime, Option<Enumeration.Value> mode, Option<Object> vec) {
        String period = modernDates ? "after" : "before";
        Enumeration.Value value = dateTime;
        Enumeration.Value value2 = DateTime$.MODULE$.DATE();
        int year = !(value != null ? !value.equals(value2) : value2 != null) ? 1582 : 1900;
        String vecFlag = (String)vec.map((Function1 & Serializable & scala.Serializable)flag -> DateTimeRebaseBenchmark$.MODULE$.flagToStr(BoxesRunTime.unboxToBoolean((Object)flag))).map((Function1 & Serializable & scala.Serializable)flag -> new StringBuilder(6).append(", vec ").append((String)flag).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String rebaseFlag = (String)mode.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()).map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(9).append(", rebase ").append((String)m).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(1).append(period).append(" ").append(year).append(vecFlag).append(rebaseFlag).toString();
    }

    private Option<Enumeration.Value> caseName$default$3() {
        return None$.MODULE$;
    }

    private Option<Object> caseName$default$4() {
        return None$.MODULE$;
    }

    private String getPath(File basePath, Enumeration.Value dateTime, boolean modernDates, Option<Enumeration.Value> mode) {
        String period = modernDates ? "after" : "before";
        Enumeration.Value value = dateTime;
        Enumeration.Value value2 = DateTime$.MODULE$.DATE();
        int year = !(value != null ? !value.equals(value2) : value2 != null) ? 1582 : 1900;
        String rebaseFlag = (String)mode.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.toString()).map((Function1 & Serializable & scala.Serializable)m -> new StringBuilder(1).append("_").append((String)m).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        return new StringBuilder(3).append(basePath.getAbsolutePath()).append("/").append(dateTime).append("_").append(period).append("_").append(year).append(rebaseFlag).toString();
    }

    private Option<Enumeration.Value> getPath$default$4() {
        return None$.MODULE$;
    }

    private String getOutputType(Enumeration.Value dateTime) {
        Enumeration.Value value = dateTime;
        Enumeration.Value value2 = DateTime$.MODULE$.TIMESTAMP_INT96();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return SQLConf.ParquetOutputTimestampType$.MODULE$.INT96().toString();
        }
        Enumeration.Value value4 = DateTime$.MODULE$.TIMESTAMP_MILLIS();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            return SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS().toString();
        }
        return SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS().toString();
    }

    public void runBenchmarkSuite(String[] mainArgs) {
        int rowsNum = 100000000;
        DateTimeTestUtils$.MODULE$.withDefaultTimeZone(DateTimeTestUtils$.MODULE$.LA(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()), (Object)DateTimeTestUtils$.MODULE$.LA().getId())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                DateTimeRebaseBenchmark$.MODULE$.runBenchmark("Rebasing dates/timestamps in Parquet datasource", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)DateTime$.MODULE$.DATE(), (List)new .colon.colon((Object)DateTime$.MODULE$.TIMESTAMP_INT96(), (List)new .colon.colon((Object)DateTime$.MODULE$.TIMESTAMP_MICROS(), (List)new .colon.colon((Object)DateTime$.MODULE$.TIMESTAMP_MILLIS(), (List)Nil$.MODULE$))))).foreach((Function1 & Serializable & scala.Serializable)dateTime -> {
                    DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$5(rowsNum$2, path, dateTime);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
            MODULE$.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)path -> {
                DateTimeRebaseBenchmark$.MODULE$.runBenchmark("Rebasing dates/timestamps in ORC datasource", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)DateTime$.MODULE$.DATE(), (List)new .colon.colon((Object)DateTime$.MODULE$.TIMESTAMP(), (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)dateTime -> {
                    DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$19(rowsNum$2, path, dateTime);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$runBenchmarkSuite$7(boolean modernDates$1, Enumeration.Value v) {
        if (modernDates$1) return false;
        Enumeration.Value value = v;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        if (value != null) {
            if (!value.equals(value2)) return false;
            return true;
        }
        if (value2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$6(Benchmark benchmark$1, Enumeration.Value dateTime$2, int rowsNum$2, File path$1, boolean modernDates) {
        ((IterableLike)SQLConf.LegacyBehaviorPolicy$.MODULE$.values().filterNot((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$7(modernDates, v)))).foreach((Function1 & Serializable & scala.Serializable)mode -> {
            benchmark$1.addCase(DateTimeRebaseBenchmark$.MODULE$.caseName(modernDates, dateTime$2, (Option<Enumeration.Value>)new Some((Object)mode), DateTimeRebaseBenchmark$.MODULE$.caseName$default$4()), 1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$5 -> DateTimeRebaseBenchmark$.MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key()), (Object)DateTimeRebaseBenchmark$.MODULE$.getOutputType(dateTime$2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE().key()), (Object)mode.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE().key()), (Object)mode.toString())}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DateTimeRebaseBenchmark$.MODULE$.genDF(rowsNum$2, dateTime$2, modernDates).write().mode("overwrite").format("parquet").save(DateTimeRebaseBenchmark$.MODULE$.getPath(path$1, dateTime$2, modernDates, (Option<Enumeration.Value>)new Some((Object)mode)))));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$runBenchmarkSuite$13(boolean modernDates$2, Enumeration.Value v) {
        if (modernDates$2) return false;
        Enumeration.Value value = v;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        if (value != null) {
            if (!value.equals(value2)) return false;
            return true;
        }
        if (value2 == null) return true;
        return false;
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$14(boolean modernDates$2, Enumeration.Value dateTime$2, boolean vec$1, Benchmark benchmark2$1, File path$1, Enumeration.Value mode) {
        String name = MODULE$.caseName(modernDates$2, dateTime$2, (Option<Enumeration.Value>)new Some((Object)mode), (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)vec$1)));
        benchmark2$1.addCase(name, 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$6 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_VECTORIZED_READER_ENABLED().key()), (Object)Boolean.toString(vec$1))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().format("parquet").load(MODULE$.getPath(path$1, dateTime$2, modernDates$2, (Option<Enumeration.Value>)new Some((Object)mode)))).noop()));
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$12(boolean modernDates$2, Enumeration.Value dateTime$2, Benchmark benchmark2$1, File path$1, boolean vec) {
        ((IterableLike)SQLConf.LegacyBehaviorPolicy$.MODULE$.values().filterNot((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$13(modernDates$2, v)))).foreach((Function1 & Serializable & scala.Serializable)mode -> {
            DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$14(modernDates$2, dateTime$2, vec, benchmark2$1, path$1, mode);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$11(Enumeration.Value dateTime$2, Benchmark benchmark2$1, File path$1, boolean modernDates) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)vec -> {
            DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$12(modernDates, dateTime$2, benchmark2$1, path$1, BoxesRunTime.unboxToBoolean((Object)vec));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$5(int rowsNum$2, File path$1, Enumeration.Value dateTime) {
        String x$1 = new StringBuilder(16).append("Save ").append(dateTime).append(" to parquet").toString();
        long x$2 = rowsNum$2;
        Option x$3 = MODULE$.output();
        int x$4 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$5 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$6 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$1, x$2, x$4, x$5, x$6, x$7, x$3);
        MODULE$.benchmarkInputs(benchmark, rowsNum$2, dateTime);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)modernDates -> {
            DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$6(benchmark, dateTime, rowsNum$2, path$1, BoxesRunTime.unboxToBoolean((Object)modernDates));
            return BoxedUnit.UNIT;
        });
        benchmark.run();
        String x$8 = new StringBuilder(18).append("Load ").append(dateTime).append(" from parquet").toString();
        long x$9 = rowsNum$2;
        Option x$10 = MODULE$.output();
        int x$11 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$12 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$13 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$14 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark2 = new Benchmark(x$8, x$9, x$11, x$12, x$13, x$14, x$10);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)modernDates -> {
            DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$11(dateTime, benchmark2, path$1, BoxesRunTime.unboxToBoolean((Object)modernDates));
            return BoxedUnit.UNIT;
        });
        benchmark2.run();
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$23(Benchmark benchmark2$2, boolean modernDates$4, Enumeration.Value dateTime$3, File path$2, boolean vec) {
        boolean x$29 = modernDates$4;
        Enumeration.Value x$30 = dateTime$3;
        Some x$31 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)vec));
        Option<Enumeration.Value> x$32 = MODULE$.caseName$default$3();
        benchmark2$2.addCase(MODULE$.caseName(x$29, x$30, x$32, (Option<Object>)x$31), 3, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$8 -> MODULE$.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.ORC_VECTORIZED_READER_ENABLED().key()), (Object)Boolean.toString(vec))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.DatasetToBenchmark(MODULE$.spark().read().format("orc").load(MODULE$.getPath(path$2, dateTime$3, modernDates$4, MODULE$.getPath$default$4()))).noop()));
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$22(Benchmark benchmark2$2, Enumeration.Value dateTime$3, File path$2, boolean modernDates) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)vec -> {
            DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$23(benchmark2$2, modernDates, dateTime$3, path$2, BoxesRunTime.unboxToBoolean((Object)vec));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$runBenchmarkSuite$19(int rowsNum$2, File path$2, Enumeration.Value dateTime) {
        String x$15 = new StringBuilder(12).append("Save ").append(dateTime).append(" to ORC").toString();
        long x$16 = rowsNum$2;
        Option x$17 = MODULE$.output();
        int x$18 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$19 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$20 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$21 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark = new Benchmark(x$15, x$16, x$18, x$19, x$20, x$21, x$17);
        MODULE$.benchmarkInputs(benchmark, rowsNum$2, dateTime);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)modernDates -> {
            benchmark.addCase(DateTimeRebaseBenchmark$.MODULE$.caseName(BoxesRunTime.unboxToBoolean((Object)modernDates), dateTime, DateTimeRebaseBenchmark$.MODULE$.caseName$default$3(), DateTimeRebaseBenchmark$.MODULE$.caseName$default$4()), 1, (Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$7 -> DateTimeRebaseBenchmark$.MODULE$.genDF(rowsNum$2, dateTime, BoxesRunTime.unboxToBoolean((Object)modernDates)).write().mode("overwrite").format("orc").save(DateTimeRebaseBenchmark$.MODULE$.getPath(path$2, dateTime, BoxesRunTime.unboxToBoolean((Object)modernDates), DateTimeRebaseBenchmark$.MODULE$.getPath$default$4())));
            return BoxedUnit.UNIT;
        });
        benchmark.run();
        String x$22 = new StringBuilder(14).append("Load ").append(dateTime).append(" from ORC").toString();
        long x$23 = rowsNum$2;
        Option x$24 = MODULE$.output();
        int x$25 = Benchmark$.MODULE$.$lessinit$greater$default$3();
        FiniteDuration x$26 = Benchmark$.MODULE$.$lessinit$greater$default$4();
        FiniteDuration x$27 = Benchmark$.MODULE$.$lessinit$greater$default$5();
        boolean x$28 = Benchmark$.MODULE$.$lessinit$greater$default$6();
        Benchmark benchmark2 = new Benchmark(x$22, x$23, x$25, x$26, x$27, x$28, x$24);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)modernDates -> {
            DateTimeRebaseBenchmark$.$anonfun$runBenchmarkSuite$22(benchmark2, dateTime, path$2, BoxesRunTime.unboxToBoolean((Object)modernDates));
            return BoxedUnit.UNIT;
        });
        benchmark2.run();
    }

    private DateTimeRebaseBenchmark$() {
        MODULE$ = this;
        SQLHelper.$init$((SQLHelper)this);
        SqlBasedBenchmark.$init$(this);
    }
}

