/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar.compression;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.execution.columnar.BOOLEAN$;
import org.apache.spark.sql.execution.columnar.BYTE$;
import org.apache.spark.sql.execution.columnar.ByteColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnStats;
import org.apache.spark.sql.execution.columnar.ColumnarTestUtils$;
import org.apache.spark.sql.execution.columnar.INT$;
import org.apache.spark.sql.execution.columnar.IntColumnStats;
import org.apache.spark.sql.execution.columnar.LONG$;
import org.apache.spark.sql.execution.columnar.LongColumnStats;
import org.apache.spark.sql.execution.columnar.NativeColumnType;
import org.apache.spark.sql.execution.columnar.NoopColumnStats;
import org.apache.spark.sql.execution.columnar.SHORT$;
import org.apache.spark.sql.execution.columnar.STRING$;
import org.apache.spark.sql.execution.columnar.ShortColumnStats;
import org.apache.spark.sql.execution.columnar.StringColumnStats;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme;
import org.apache.spark.sql.execution.columnar.compression.CompressionScheme$;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding;
import org.apache.spark.sql.execution.columnar.compression.RunLengthEncoding$;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder;
import org.apache.spark.sql.execution.columnar.compression.TestCompressibleColumnBuilder$;
import org.apache.spark.sql.execution.vectorized.OnHeapColumnVector;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001i3AAB\u0004\u0001-!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0003\u0001\u0003BB\u0014\u0001A\u0003%\u0011\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0004M\u0001E\u0005I\u0011A'\u0003-I+h\u000eT3oORDWI\\2pI&twmU;ji\u0016T!\u0001C\u0005\u0002\u0017\r|W\u000e\u001d:fgNLwN\u001c\u0006\u0003\u0015-\t\u0001bY8mk6t\u0017M\u001d\u0006\u0003\u00195\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u0006gB\f'o\u001b\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001a\u001b\u0005y\u0011B\u0001\u000e\u0010\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aB\u0001\n]VdGNV1mk\u0016,\u0012!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0004\u0013:$\u0018A\u00038vY24\u0016\r\\;fA\u0005)B/Z:u%VtG*\u001a8hi\",enY8eS:<WC\u0001\u0016<)\u0011Yc\u0006N$\u0011\u0005\tb\u0013BA\u0017$\u0005\u0011)f.\u001b;\t\u000b=\"\u0001\u0019\u0001\u0019\u0002\u0017\r|G.^7o'R\fGo\u001d\t\u0003cIj\u0011!C\u0005\u0003g%\u00111bQ8mk6t7\u000b^1ug\")Q\u0007\u0002a\u0001m\u0005Q1m\u001c7v[:$\u0016\u0010]3\u0011\u0007E:\u0014(\u0003\u00029\u0013\t\u0001b*\u0019;jm\u0016\u001cu\u000e\\;n]RK\b/\u001a\t\u0003umb\u0001\u0001B\u0003=\t\t\u0007QHA\u0001U#\tq\u0014\t\u0005\u0002#\u007f%\u0011\u0001i\t\u0002\b\u001d>$\b.\u001b8h!\t\u0011U)D\u0001D\u0015\t!U\"A\u0003usB,7/\u0003\u0002G\u0007\nQ\u0011\t^8nS\u000e$\u0016\u0010]3\t\u000f!#\u0001\u0013!a\u0001\u0013\u0006qA/Z:u\t\u0016\u001cw.\u001c9sKN\u001c\bC\u0001\u0012K\u0013\tY5EA\u0004C_>dW-\u00198\u0002?Q,7\u000f\u001e*v]2+gn\u001a;i\u000b:\u001cw\u000eZ5oO\u0012\"WMZ1vYR$3'\u0006\u0002O3V\tqJ\u000b\u0002J!.\n\u0011\u000b\u0005\u0002S/6\t1K\u0003\u0002U+\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003-\u000e\n!\"\u00198o_R\fG/[8o\u0013\tA6KA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016$Q\u0001P\u0003C\u0002u\u0002")
public class RunLengthEncodingSuite
extends SparkFunSuite {
    private final int nullValue;

    public int nullValue() {
        return this.nullValue;
    }

    public <T extends AtomicType> void testRunLengthEncoding(ColumnStats columnStats, NativeColumnType<T> columnType, boolean testDecompress) {
        String typeName = new StringOps(Predef$.MODULE$.augmentString(columnType.getClass().getSimpleName())).stripSuffix("$");
        this.test(new StringBuilder(20).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": empty column").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(0, (Seq)Nil$.MODULE$, columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test(new StringBuilder(19).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": simple case").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(2, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        this.test(new StringBuilder(23).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": run length == 1").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(2, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)1)), (List)Nil$.MODULE$)), columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test(new StringBuilder(23).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": single long run").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeleton$1(1, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)Nil$.MODULE$), columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        this.test(new StringBuilder(37).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": empty column for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(0, (Seq)Nil$.MODULE$, testDecompress, columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        this.test(new StringBuilder(36).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": simple case for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(2, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), testDecompress, columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
        this.test(new StringBuilder(40).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": single long run for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(1, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)1000)), (List)Nil$.MODULE$), testDecompress, columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test(new StringBuilder(46).append(RunLengthEncoding$.MODULE$).append(" with ").append(typeName).append(": single case with null for decompress()").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.skeletonForDecompress$1(2, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)BoxesRunTime.boxToInteger((int)2)), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.nullValue())), (Object)BoxesRunTime.boxToInteger((int)2)), (List)Nil$.MODULE$)), testDecompress, columnStats, columnType), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    public <T extends AtomicType> boolean testRunLengthEncoding$default$3() {
        return true;
    }

    public static final /* synthetic */ int $anonfun$testRunLengthEncoding$4(NativeColumnType columnType$1, Seq rows$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int index = tuple2._1$mcI$sp();
            return columnType$1.actualSize((InternalRow)rows$1.apply(index), 0) + 4;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Assertion $anonfun$testRunLengthEncoding$6(RunLengthEncodingSuite $this, RunLengthEncoding.Decoder decoder$1, Seq values$1, GenericInternalRow mutableRow$1, NativeColumnType columnType$1, int i) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(decoder$1.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        Object object = values$1.apply(i);
        decoder$1.next((InternalRow)mutableRow$1, 0);
        return $this.assertResult(object, "Wrong decoded value", columnType$1.getField((InternalRow)mutableRow$1, 0), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }

    private final void skeleton$1(int uniqueValueCount, Seq inputRuns, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq values = (Seq)tuple2._1();
        Seq rows = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
        Seq values2 = (Seq)tuple22._1();
        Seq rows2 = (Seq)tuple22._2();
        Seq inputSeq = (Seq)inputRuns.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int index = tuple2._1$mcI$sp();
                int run = tuple2._2$mcI$sp();
                return (Seq)Seq$.MODULE$.fill(run, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> index);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> builder.appendFrom((InternalRow)rows2.apply(i), 0));
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        int compressedSize = 4 + BoxesRunTime.unboxToInt((Object)((TraversableOnce)inputRuns.map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)RunLengthEncodingSuite.$anonfun$testRunLengthEncoding$4(columnType$1, rows2, x0$2)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        this.assertResult(BoxesRunTime.boxToInteger((int)(headerSize + compressedSize)), "Wrong buffer capacity", BoxesRunTime.boxToInteger((int)buffer.capacity()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        inputRuns.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                int index = tuple2._1$mcI$sp();
                int run = tuple2._2$mcI$sp();
                this.assertResult(values2.apply(index), "Wrong column element value", columnType$1.extract(buffer), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                return this.assertResult(BoxesRunTime.boxToInteger((int)run), "Wrong run length", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            }
            throw new MatchError((Object)tuple2);
        });
        buffer.rewind().position(headerSize + 4);
        RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
        GenericInternalRow mutableRow = new GenericInternalRow(1);
        if (inputSeq.nonEmpty()) {
            inputSeq.foreach((Function1 & Serializable & scala.Serializable)i -> RunLengthEncodingSuite.$anonfun$testRunLengthEncoding$6(this, decoder, values2, mutableRow, columnType$1, BoxesRunTime.unboxToInt((Object)i)));
        }
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(decoder.hasNext(), "decoder.hasNext", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
    }

    private final void skeletonForDecompress$1(int uniqueValueCount, Seq inputRuns, boolean testDecompress$1, ColumnStats columnStats$1, NativeColumnType columnType$1) {
        if (!testDecompress$1) {
            return;
        }
        TestCompressibleColumnBuilder builder = TestCompressibleColumnBuilder$.MODULE$.apply(columnStats$1, columnType$1, (CompressionScheme)RunLengthEncoding$.MODULE$);
        Tuple2<Seq<Object>, Seq<GenericInternalRow>> tuple2 = ColumnarTestUtils$.MODULE$.makeUniqueValuesAndSingleValueRows(columnType$1, uniqueValueCount);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq values = (Seq)tuple2._1();
        Seq rows = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)values, (Object)rows);
        Seq values2 = (Seq)tuple22._1();
        Seq rows2 = (Seq)tuple22._2();
        Seq inputSeq = (Seq)inputRuns.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                int index = tuple2._1$mcI$sp();
                int run = tuple2._2$mcI$sp();
                return (Seq)Seq$.MODULE$.fill(run, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> index);
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom());
        GenericInternalRow nullRow = new GenericInternalRow(1);
        nullRow.setNullAt(0);
        inputSeq.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            if (i == this.nullValue()) {
                builder.appendFrom((InternalRow)nullRow, 0);
                return;
            }
            builder.appendFrom((InternalRow)rows2.apply(i), 0);
        });
        ByteBuffer buffer = builder.build();
        int headerSize = CompressionScheme$.MODULE$.columnHeaderSize(buffer);
        buffer.position(headerSize);
        this.assertResult(BoxesRunTime.boxToInteger((int)RunLengthEncoding$.MODULE$.typeId()), "Wrong compression scheme ID", BoxesRunTime.boxToInteger((int)buffer.getInt()), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        RunLengthEncoding.Decoder decoder = RunLengthEncoding$.MODULE$.decoder(buffer, columnType$1);
        OnHeapColumnVector columnVector = new OnHeapColumnVector(inputSeq.length(), (DataType)columnType$1.dataType());
        decoder.decompress((WritableColumnVector)columnVector, inputSeq.length());
        if (inputSeq.nonEmpty()) {
            ((IterableLike)inputSeq.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    int expected = tuple2._1$mcI$sp();
                    int index = tuple2._2$mcI$sp();
                    int n = expected;
                    int n2 = index;
                    if (n == this.nullValue()) {
                        return this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), new StringBuilder(22).append("Wrong null ").append(n2).append("th-position").toString(), BoxesRunTime.boxToBoolean((boolean)columnVector.isNullAt(n2)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
                    }
                }
                if (tuple2 != null) {
                    int i = tuple2._1$mcI$sp();
                    int index = tuple2._2$mcI$sp();
                    int n = i;
                    int n3 = index;
                    NativeColumnType nativeColumnType = columnType$1;
                    if (BOOLEAN$.MODULE$.equals(nativeColumnType)) {
                        return this.assertResult(values2.apply(n), new StringBuilder(31).append("Wrong ").append(n3).append("-th decoded boolean value").toString(), BoxesRunTime.boxToBoolean((boolean)columnVector.getBoolean(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                    }
                    if (BYTE$.MODULE$.equals(nativeColumnType)) {
                        return this.assertResult(values2.apply(n), new StringBuilder(28).append("Wrong ").append(n3).append("-th decoded byte value").toString(), BoxesRunTime.boxToByte((byte)columnVector.getByte(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                    }
                    if (SHORT$.MODULE$.equals(nativeColumnType)) {
                        return this.assertResult(values2.apply(n), new StringBuilder(29).append("Wrong ").append(n3).append("-th decoded short value").toString(), BoxesRunTime.boxToShort((short)columnVector.getShort(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
                    }
                    if (INT$.MODULE$.equals(nativeColumnType)) {
                        return this.assertResult(values2.apply(n), new StringBuilder(27).append("Wrong ").append(n3).append("-th decoded int value").toString(), BoxesRunTime.boxToInteger((int)columnVector.getInt(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
                    }
                    if (LONG$.MODULE$.equals(nativeColumnType)) {
                        return this.assertResult(values2.apply(n), new StringBuilder(28).append("Wrong ").append(n3).append("-th decoded long value").toString(), BoxesRunTime.boxToLong((long)columnVector.getLong(n3)), Prettifier$.MODULE$.default(), new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
                    }
                    throw this.fail("Unsupported type", new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
                }
                throw this.fail("Unsupported type", new Position("RunLengthEncodingSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            });
            return;
        }
    }

    public RunLengthEncodingSuite() {
        this.nullValue = -1;
        this.testRunLengthEncoding((ColumnStats)new NoopColumnStats(), (NativeColumnType)BOOLEAN$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new ByteColumnStats(), (NativeColumnType)BYTE$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new ShortColumnStats(), (NativeColumnType)SHORT$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new IntColumnStats(), (NativeColumnType)INT$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new LongColumnStats(), (NativeColumnType)LONG$.MODULE$, this.testRunLengthEncoding$default$3());
        this.testRunLengthEncoding((ColumnStats)new StringColumnStats(), (NativeColumnType)STRING$.MODULE$, false);
    }
}

