/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest;
import org.apache.spark.sql.execution.datasources.parquet.ParquetCompatibilityTest$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00012AAA\u0002\u0001%!)Q\u0004\u0001C\u0001=\ta\u0002+\u0019:rk\u0016$\u0018J\u001c;fe>\u0004XM]1cS2LG/_*vSR,'B\u0001\u0003\u0006\u0003\u001d\u0001\u0018M]9vKRT!AB\u0004\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003\u0011%\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005)Y\u0011aA:rY*\u0011A\"D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001d=\ta!\u00199bG\",'\"\u0001\t\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0019r\u0003\u0005\u0002\u0015+5\t1!\u0003\u0002\u0017\u0007\tA\u0002+\u0019:rk\u0016$8i\\7qCRL'-\u001b7jif$Vm\u001d;\u0011\u0005aYR\"A\r\u000b\u0005iI\u0011\u0001\u0002;fgRL!\u0001H\r\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0001\"\u0001\u0006\u0001")
public class ParquetInteroperabilitySuite
extends ParquetCompatibilityTest
implements SharedSparkSession {
    private final boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        SharedSparkSession.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        SharedSparkSession.afterAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$(this);
    }

    @Override
    public SparkSession spark() {
        return SharedSparkSessionBase.spark$(this);
    }

    @Override
    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$(this);
    }

    @Override
    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$(this);
    }

    @Override
    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$(this);
    }

    @Override
    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
    }

    @Override
    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    @Override
    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    @Override
    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public static final /* synthetic */ void $anonfun$new$3(RecordConsumer rc) {
        ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).message((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).field("f", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).group((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).field("array", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            rc.addInteger(0);
            rc.addInteger(1);
        }))));
    }

    public static final /* synthetic */ void $anonfun$new$8(RecordConsumer rc) {
        ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).message((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ParquetCompatibilityTest$.MODULE$.RecordConsumerDSL(rc).field("f", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            rc.addInteger(2);
            rc.addInteger(3);
        }));
    }

    public static final /* synthetic */ void $anonfun$new$2(ParquetInteroperabilitySuite $this, File dir) {
        String avroStylePath = new File(dir, "avro-style").getCanonicalPath();
        String protobufStylePath = new File(dir, "protobuf-style").getCanonicalPath();
        String avroStyleSchema = new StringOps(Predef$.MODULE$.augmentString("message avro_style {\n          |  required group f (LIST) {\n          |    repeated int32 array;\n          |  }\n          |}\n        ")).stripMargin();
        ParquetCompatibilityTest$.MODULE$.writeDirect(avroStylePath, avroStyleSchema, (Seq<Function1<RecordConsumer, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)rc -> {
            ParquetInteroperabilitySuite.$anonfun$new$3(rc);
            return BoxedUnit.UNIT;
        }}));
        $this.logParquetSchema(avroStylePath);
        String protobufStyleSchema = new StringOps(Predef$.MODULE$.augmentString("message protobuf_style {\n          |  repeated int32 f;\n          |}\n        ")).stripMargin();
        ParquetCompatibilityTest$.MODULE$.writeDirect(protobufStylePath, protobufStyleSchema, (Seq<Function1<RecordConsumer, BoxedUnit>>)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)rc -> {
            ParquetInteroperabilitySuite.$anonfun$new$8(rc);
            return BoxedUnit.UNIT;
        }}));
        $this.logParquetSchema(protobufStylePath);
        $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().parquet(dir.getCanonicalPath()), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))})), (List)Nil$.MODULE$))));
    }

    public static final /* synthetic */ void $anonfun$new$16(ParquetInteroperabilitySuite $this, File tableDir) {
        Row row2;
        Row row1;
        StructField structField = new StructField("col-0", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("col-0", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField)), false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema1 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2));
        Row row = row1 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1)})), (List)Nil$.MODULE$)}));
        Dataset df1 = $this.spark().createDataFrame($this.spark().sparkContext().parallelize((Seq)Nil$.MODULE$.$colon$colon((Object)row), 1, ClassTag$.MODULE$.apply(Row.class)), schema1);
        df1.write().parquet(tableDir.getAbsolutePath());
        StructField structField3 = new StructField("col-0", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField4 = new StructField("col-1", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
        StructField structField5 = new StructField("col-0", (DataType)new ArrayType((DataType)StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField4).$colon$colon((Object)structField3)), false), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        StructType schema2 = StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField5));
        Row row3 = row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)}));
        Dataset df2 = $this.spark().createDataFrame($this.spark().sparkContext().parallelize((Seq)Nil$.MODULE$.$colon$colon((Object)row3), 1, ClassTag$.MODULE$.apply(Row.class)), schema2);
        df2.write().mode("append").parquet(tableDir.getAbsolutePath());
        $this.withAllParquetReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.checkAnswer((Function0<Dataset<Row>>)(Function0 & Serializable & scala.Serializable)() -> $this.spark().read().schema(schema2).parquet(tableDir.getAbsolutePath()), (Seq<Row>)((Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), null})), (List)Nil$.MODULE$)})), (List)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2)})), (List)Nil$.MODULE$)})), (List)Nil$.MODULE$)))));
    }

    public static final /* synthetic */ void $anonfun$new$13(ParquetInteroperabilitySuite $this, boolean legacyMode) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)offheapEnabled -> {
            $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()), (Object)Boolean.toString(legacyMode)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SQLConf$.MODULE$.COLUMN_VECTOR_OFFHEAP_ENABLED().key()), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)offheapEnabled)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableDir -> {
                ParquetInteroperabilitySuite.$anonfun$new$16($this, tableDir);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$21(ParquetInteroperabilitySuite $this, String impalaPath$1, Seq impalaFileData$1, File tableDir) {
        Seq ts = (Seq)((TraversableLike)new .colon.colon((Object)"2004-04-04 04:04:04", (List)new .colon.colon((Object)"2005-05-05 05:05:05", (List)new .colon.colon((Object)"2006-06-06 06:06:06", (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)s -> Timestamp.valueOf(s), Seq$.MODULE$.canBuildFrom());
        Dataset df = $this.spark().createDataset(ts, $this.testImplicits().newTimeStampEncoder()).toDF().repartition(1).withColumnRenamed("value", "ts");
        df.write().parquet(tableDir.getAbsolutePath());
        FileUtils.copyFile((File)new File(impalaPath$1), (File)new File(tableDir, "part-00001.parq"));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)int96TimestampConversion -> {
            $this.withAllParquetReaders((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key(), (Object)SQLConf.ParquetOutputTimestampType$.MODULE$.INT96().toString()), new Tuple2((Object)SQLConf$.MODULE$.PARQUET_INT96_TIMESTAMP_CONVERSION().key(), (Object)Boolean.toString(BoxesRunTime.unboxToBoolean((Object)int96TimestampConversion)))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                Row[] readBack = (Row[])$this.spark().read().parquet(tableDir$2.getAbsolutePath()).collect();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readBack)).size()));
                int $org_scalatest_assert_macro_right = 6;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
                Seq impalaExpectations = int96TimestampConversion ? impalaFileData$1 : (Seq)impalaFileData$1.map((Function1 & Serializable & scala.Serializable)ts -> DateTimeUtils$.MODULE$.toJavaTimestamp(DateTimeUtils$.MODULE$.convertTz(DateTimeUtils$.MODULE$.fromJavaTimestamp(ts), (ZoneId)ZoneOffset.UTC, DateTimeUtils$.MODULE$.getZoneId($this.conf().sessionLocalTimeZone()))), Seq$.MODULE$.canBuildFrom());
                String[] fullExpectations = (String[])((TraversableOnce)((SeqLike)((TraversableLike)ts$1.$plus$plus((GenTraversableOnce)impalaExpectations, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.toString(), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class));
                String[] actual = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])readBack)).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getTimestamp(0).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).sorted((Ordering)Ordering.String$.MODULE$);
                $this.withClue(new StringBuilder(42).append("int96TimestampConversion = ").append(int96TimestampConversion).append("; ").append("vectorized = ").append(SQLConf$.MODULE$.get().parquetVectorizedReaderEnabled()).toString(), (Function0 & Serializable & scala.Serializable)() -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(fullExpectations);
                    String[] $org_scalatest_assert_macro_right = actual;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
                    Configuration hadoopConf = $this.spark().sessionState().newHadoopConf();
                    FileSystem fs = new Path(tableDir$2.getAbsolutePath()).getFileSystem(hadoopConf);
                    FileStatus[] parts = fs.listStatus(new Path(tableDir$2.getAbsolutePath()), new PathFilter(null){

                        public boolean accept(Path path) {
                            return !path.getName().startsWith("_");
                        }
                    });
                    Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])parts);
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "size", (Object)BoxesRunTime.boxToInteger((int)new ArrayOps.ofRef($org_scalatest_assert_macro_left2).size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])parts)).foreach((Function1 & Serializable & scala.Serializable)part -> {
                        ParquetMetadata oneFooter = ParquetFooterReader.readFooter((Configuration)hadoopConf, (Path)part.getPath(), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(BoxesRunTime.boxToInteger((int)oneFooter.getFileMetaData().getSchema().getColumns().size()));
                        int $org_scalatest_assert_macro_right = 1;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
                        PrimitiveType.PrimitiveTypeName typeName = ((ColumnDescriptor)oneFooter.getFileMetaData().getSchema().getColumns().get(0)).getPrimitiveType().getPrimitiveTypeName();
                        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(typeName);
                        PrimitiveType.PrimitiveTypeName $org_scalatest_assert_macro_right2 = PrimitiveType.PrimitiveTypeName.INT96;
                        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
                        BlockMetaData oneBlockMeta = (BlockMetaData)oneFooter.getBlocks().get(0);
                        ColumnChunkMetaData oneBlockColumnMeta = (ColumnChunkMetaData)oneBlockMeta.getColumns().get(0);
                        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(oneBlockColumnMeta.getStatistics().hasNonNullValue(), "oneBlockColumnMeta.getStatistics().hasNonNullValue()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
                    });
                    Dataset query = $this.spark().read().parquet(tableDir$2.getAbsolutePath()).where("ts > '2001-01-01 01:00:00'");
                    long countWithFilter = query.count();
                    int exp = int96TimestampConversion ? 6 : 5;
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(BoxesRunTime.boxToLong((long)countWithFilter));
                    int $org_scalatest_assert_macro_right3 = exp;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)query, Prettifier$.MODULE$.default(), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
                });
            }));
            return BoxedUnit.UNIT;
        });
    }

    public ParquetInteroperabilitySuite() {
        SharedSparkSessionBase.$init$(this);
        SharedSparkSession.$init$(this);
        this.test("parquet files with different physical schemas but share the same logical schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
            ParquetInteroperabilitySuite.$anonfun$new$2(this, dir);
            return BoxedUnit.UNIT;
        }), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 35));
        this.test("SPARK-36803: parquet files with legacy mode and schema evolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)legacyMode -> {
            ParquetInteroperabilitySuite.$anonfun$new$13(this, BoxesRunTime.unboxToBoolean((Object)legacyMode));
            return BoxedUnit.UNIT;
        }), new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
        this.test("parquet timestamp conversion", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String impalaFile = "test-data/impala_timestamp.parq";
            Seq impalaFileData = (Seq)((TraversableLike)new .colon.colon((Object)"2001-01-01 01:01:01", (List)new .colon.colon((Object)"2002-02-02 02:02:02", (List)new .colon.colon((Object)"2003-03-03 03:03:03", (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)x$1 -> Timestamp.valueOf(x$1), Seq$.MODULE$.canBuildFrom());
            String impalaPath = Thread.currentThread().getContextClassLoader().getResource(impalaFile).toURI().getPath();
            this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableDir -> {
                ParquetInteroperabilitySuite.$anonfun$new$21(this, impalaPath, impalaFileData, tableDir);
                return BoxedUnit.UNIT;
            });
        }, new Position("ParquetInteroperabilitySuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
    }
}

