/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming.ui;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.History;
import org.apache.spark.internal.config.History$;
import org.apache.spark.sql.streaming.ui.StreamingQueryStatusListenerSuite;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00113A\u0001C\u0005\u0001-!)1\u0004\u0001C\u00019!Ia\u0004\u0001a\u0001\u0002\u0004%Ia\b\u0005\nQ\u0001\u0001\r\u00111A\u0005\n%B\u0011B\r\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0011\t\u000bM\u0002A\u0011\t\u001b\t\u000bu\u0002A\u0011\t \t\u000b\t\u0003A\u0011I\"\u0003]M#(/Z1nS:<\u0017+^3ssN#\u0018\r^;t\u0019&\u001cH/\u001a8fe^KG\u000f\u001b#jg.\u001cFo\u001c:f'VLG/\u001a\u0006\u0003\u0015-\t!!^5\u000b\u00051i\u0011!C:ue\u0016\fW.\u001b8h\u0015\tqq\"A\u0002tc2T!\u0001E\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011\"\u0003\u0002\u001b\u0013\t\t3\u000b\u001e:fC6LgnZ)vKJL8\u000b^1ukNd\u0015n\u001d;f]\u0016\u00148+^5uK\u00061A(\u001b8jiz\"\u0012!\b\t\u00031\u0001\t\u0011b\u001d;pe\u0016\u0004\u0016\r\u001e5\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012AAR5mK\u0006i1\u000f^8sKB\u000bG\u000f[0%KF$\"A\u000b\u0019\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\tUs\u0017\u000e\u001e\u0005\bc\r\t\t\u00111\u0001!\u0003\rAH%M\u0001\u000bgR|'/\u001a)bi\"\u0004\u0013aC2sK\u0006$Xm\u0015;pe\u0016$\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\nqa\u001b<ti>\u0014XM\u0003\u0002;\u001f\u0005!Q\u000f^5m\u0013\tatGA\u0004L-N#xN]3\u0002!U\u001cX-\u00138NK6|'/_*u_J,W#A \u0011\u0005-\u0002\u0015BA!-\u0005\u001d\u0011un\u001c7fC:\f\u0011\"\u00194uKJ,\u0015m\u00195\u0015\u0003)\u0002")
public class StreamingQueryStatusListenerWithDiskStoreSuite
extends StreamingQueryStatusListenerSuite {
    private File storePath;

    private File storePath() {
        return this.storePath;
    }

    private void storePath_$eq(File x$1) {
        this.storePath = x$1;
    }

    @Override
    public KVStore createStore() {
        this.storePath_$eq(Utils$.MODULE$.createTempDir());
        return KVUtils$.MODULE$.createKVStore((Option)new Some((Object)this.storePath()), true, this.sparkConf());
    }

    @Override
    public boolean useInMemoryStore() {
        return false;
    }

    @Override
    public void afterEach() {
        SharedSparkSessionBase.afterEach$(this);
        if (this.storePath() != null && this.storePath().exists()) {
            Utils$.MODULE$.deleteRecursively(this.storePath());
            return;
        }
    }

    public StreamingQueryStatusListenerWithDiskStoreSuite() {
        this.test("SPARK-38056: test writing StreamingQueryData to a LevelDB store", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(Utils$.MODULE$.isMacOnAppleSilicon(), "org.apache.spark.util.Utils.isMacOnAppleSilicon", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("StreamingQueryStatusListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            SparkConf conf = new SparkConf().set(History$.MODULE$.HYBRID_STORE_DISK_BACKEND(), (Object)History.HybridStoreDiskBackend$.MODULE$.LEVELDB().toString());
            File testDir = Utils$.MODULE$.createTempDir();
            KVStore kvStore = KVUtils$.MODULE$.open(testDir, (Object)this.getClass().getName(), conf, false, ClassTag$.MODULE$.apply(String.class));
            try {
                this.testStreamingQueryData(kvStore);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                kvStore.close();
                Utils$.MODULE$.deleteRecursively(testDir);
            }
            return boxedUnit;
        }, new Position("StreamingQueryStatusListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("SPARK-38056: test writing StreamingQueryData to a RocksDB store", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            SparkConf conf = new SparkConf().set(History$.MODULE$.HYBRID_STORE_DISK_BACKEND(), (Object)History.HybridStoreDiskBackend$.MODULE$.ROCKSDB().toString());
            File testDir = Utils$.MODULE$.createTempDir();
            KVStore kvStore = KVUtils$.MODULE$.open(testDir, (Object)this.getClass().getName(), conf, false, ClassTag$.MODULE$.apply(String.class));
            try {
                this.testStreamingQueryData(kvStore);
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                kvStore.close();
                Utils$.MODULE$.deleteRecursively(testDir);
            }
            return boxedUnit;
        }, new Position("StreamingQueryStatusListenerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 303));
    }
}

