/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.internal.Logging;
import org.apache.spark.streaming.kafka010.InternalKafkaConsumer$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u0001\u0003\u0001\ta!!F%oi\u0016\u0014h.\u00197LC\u001a\\\u0017mQ8ogVlWM\u001d\u0006\u0003\u0007\u0011\t\u0001b[1gW\u0006\u0004\u0014\u0007\r\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e,2!D'X'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005UAR\"\u0001\f\u000b\u0005]1\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011)\u0019!C\u0001;\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t7\u0001A\u000b\u0002=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\u0007G>lWn\u001c8\u000b\u0005\rB\u0011!B6bM.\f\u0017BA\u0013!\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001b\n\u0001\u0003\u0002\u0003\u0006IAH\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA!A\u0011\u0006\u0001BC\u0002\u0013\u0005!&A\u0006lC\u001a\\\u0017\rU1sC6\u001cX#A\u0016\u0011\t1\n4GP\u0007\u0002[)\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005Ij#aA'baB\u0011Ag\u000f\b\u0003ke\u0002\"A\u000e\t\u000e\u0003]R!\u0001\u000f\u000f\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\u0011!\ty$)D\u0001A\u0015\t\tu&\u0001\u0003mC:<\u0017BA\"A\u0005\u0019y%M[3di\"AQ\t\u0001B\u0001B\u0003%1&\u0001\u0007lC\u001a\\\u0017\rU1sC6\u001c\b\u0005C\u0003H\u0001\u0011\u0005\u0001*\u0001\u0004=S:LGO\u0010\u000b\u0004\u0013fS\u0006\u0003\u0002&\u0001\u0017Zk\u0011A\u0001\t\u0003\u00196c\u0001\u0001B\u0003O\u0001\t\u0007qJA\u0001L#\t\u00016\u000b\u0005\u0002\u0010#&\u0011!\u000b\u0005\u0002\b\u001d>$\b.\u001b8h!\tyA+\u0003\u0002V!\t\u0019\u0011I\\=\u0011\u00051;F!\u0002-\u0001\u0005\u0004y%!\u0001,\t\u000bm1\u0005\u0019\u0001\u0010\t\u000b%2\u0005\u0019A\u0016\t\u0011q\u0003!\u0019!C\u0001\u0005u\u000bqa\u001a:pkBLE-F\u00014\u0011\u0019y\u0006\u0001)A\u0005g\u0005AqM]8va&#\u0007\u0005C\u0004b\u0001\t\u0007I\u0011\u00022\u0002\u0011\r|gn];nKJ,\u0012a\u0019\t\u0005I\"\\e+D\u0001f\u0015\t\tgM\u0003\u0002hE\u000591\r\\5f]R\u001c\u0018BA5f\u00055Y\u0015MZ6b\u0007>t7/^7fe\"11\u000e\u0001Q\u0001\n\r\f\u0011bY8ogVlWM\u001d\u0011\t\u000f5\u0004\u0001\u0019!C\u0001]\u0006)\u0011N\\+tKV\tq\u000e\u0005\u0002\u0010a&\u0011\u0011\u000f\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\u0019\b\u00011A\u0005\u0002Q\f\u0011\"\u001b8Vg\u0016|F%Z9\u0015\u0005UD\bCA\bw\u0013\t9\bC\u0001\u0003V]&$\bbB=s\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\n\u0004BB>\u0001A\u0003&q.\u0001\u0004j]V\u001bX\r\t\u0005\b{\u0002\u0001\r\u0011\"\u0001o\u00039i\u0017M]6fI\u001a{'o\u00117pg\u0016D\u0001b \u0001A\u0002\u0013\u0005\u0011\u0011A\u0001\u0013[\u0006\u00148.\u001a3G_J\u001cEn\\:f?\u0012*\u0017\u000fF\u0002v\u0003\u0007Aq!\u001f@\u0002\u0002\u0003\u0007q\u000eC\u0004\u0002\b\u0001\u0001\u000b\u0015B8\u0002\u001f5\f'o[3e\r>\u00148\t\\8tK\u0002B\u0011\"a\u0003\u0001\u0001\u0004%I!!\u0004\u0002\r\t,hMZ3s+\t\ty\u0001E\u0003-\u0003#\t)\"C\u0002\u0002\u00145\u0012A\u0002T5ti&#XM]1u_J\u0004R\u0001ZA\f\u0017ZK1!!\u0007f\u00059\u0019uN\\:v[\u0016\u0014(+Z2pe\u0012D\u0011\"!\b\u0001\u0001\u0004%I!a\b\u0002\u0015\t,hMZ3s?\u0012*\u0017\u000fF\u0002v\u0003CA\u0011\"_A\u000e\u0003\u0003\u0005\r!a\u0004\t\u0011\u0005\u0015\u0002\u0001)Q\u0005\u0003\u001f\tqAY;gM\u0016\u0014\b\u0005\u000b\u0003\u0002$\u0005%\u0002cA\b\u0002,%\u0019\u0011Q\u0006\t\u0003\u0011Y|G.\u0019;jY\u0016D\u0011\"!\r\u0001\u0001\u0004%I!a\r\u0002\u00159,\u0007\u0010^(gMN,G/\u0006\u0002\u00026A\u0019q\"a\u000e\n\u0007\u0005e\u0002C\u0001\u0003M_:<\u0007\"CA\u001f\u0001\u0001\u0007I\u0011BA \u00039qW\r\u001f;PM\u001a\u001cX\r^0%KF$2!^A!\u0011%I\u00181HA\u0001\u0002\u0004\t)\u0004\u0003\u0005\u0002F\u0001\u0001\u000b\u0015BA\u001b\u0003-qW\r\u001f;PM\u001a\u001cX\r\u001e\u0011)\t\u0005\r\u0013\u0011\u0006\u0005\b\u0003\u0017\u0002A\u0011IA'\u0003!!xn\u0015;sS:<G#A\u001a\t\r\u0005E\u0003\u0001\"\u0003c\u00039\u0019'/Z1uK\u000e{gn];nKJDq!!\u0016\u0001\t\u0003\t9&A\u0003dY>\u001cX\rF\u0001v\u0011\u001d\tY\u0006\u0001C\u0001\u0003;\n1aZ3u)\u0019\t)\"a\u0018\u0002d!A\u0011\u0011MA-\u0001\u0004\t)$\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\t\u0003K\nI\u00061\u0001\u00026\u00059A/[7f_V$\bbBA5\u0001\u0011\u0005\u00111N\u0001\u000fG>l\u0007/Y2uK\u0012\u001cF/\u0019:u)\u0015)\u0018QNA8\u0011!\t\t'a\u001aA\u0002\u0005U\u0002\u0002CA9\u0003O\u0002\r!!\u000e\u0002\u001bA|G\u000e\u001c+j[\u0016|W\u000f^'t\u0011\u001d\t)\b\u0001C\u0001\u0003o\nQbY8na\u0006\u001cG/\u001a3OKb$H\u0003BA\u000b\u0003sB\u0001\"!\u001d\u0002t\u0001\u0007\u0011Q\u0007\u0005\b\u0003{\u0002A\u0011AA@\u0003E\u0019w.\u001c9bGR,G\r\u0015:fm&|Wo\u001d\u000b\u0003\u0003+Aq!a!\u0001\t\u0013\t))\u0001\u0003tK\u0016\\GcA;\u0002\b\"A\u0011\u0011MAA\u0001\u0004\t)\u0004C\u0004\u0002\f\u0002!I!!$\u0002\tA|G\u000e\u001c\u000b\u0004k\u0006=\u0005\u0002CA3\u0003\u0013\u0003\r!!\u000e\b\u0011\u0005M%\u0001#\u0001\u0003\u0003+\u000bQ#\u00138uKJt\u0017\r\\&bM.\f7i\u001c8tk6,'\u000fE\u0002K\u0003/3q!\u0001\u0002\t\u0002\t\tIjE\u0002\u0002\u0018:AqaRAL\t\u0003\ti\n\u0006\u0002\u0002\u0016\"Q\u0011\u0011UAL\u0005\u0004%I!a\r\u0002\u001dUs5JT(X\u001d~{eIR*F)\"I\u0011QUALA\u0003%\u0011QG\u0001\u0010+:[ejT,O?>3eiU#UA\u0001")
public class InternalKafkaConsumer<K, V>
implements Logging {
    private final TopicPartition topicPartition;
    private final Map<String, Object> kafkaParams;
    private final String groupId;
    private final KafkaConsumer<K, V> consumer;
    private boolean inUse;
    private boolean markedForClose;
    private volatile ListIterator<ConsumerRecord<K, V>> buffer;
    private volatile long nextOffset;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Map<String, Object> kafkaParams() {
        return this.kafkaParams;
    }

    public String groupId() {
        return this.groupId;
    }

    private KafkaConsumer<K, V> consumer() {
        return this.consumer;
    }

    public boolean inUse() {
        return this.inUse;
    }

    public void inUse_$eq(boolean x$1) {
        this.inUse = x$1;
    }

    public boolean markedForClose() {
        return this.markedForClose;
    }

    public void markedForClose_$eq(boolean x$1) {
        this.markedForClose = x$1;
    }

    private ListIterator<ConsumerRecord<K, V>> buffer() {
        return this.buffer;
    }

    private void buffer_$eq(ListIterator<ConsumerRecord<K, V>> x$1) {
        this.buffer = x$1;
    }

    private long nextOffset() {
        return this.nextOffset;
    }

    private void nextOffset_$eq(long x$1) {
        this.nextOffset = x$1;
    }

    public String toString() {
        return new StringBuilder(22).append("InternalKafkaConsumer(").append(new StringBuilder(7).append("hash=").append(Integer.toHexString(this.hashCode())).append(", ").toString()).append(new StringBuilder(10).append("groupId=").append(this.groupId()).append(", ").toString()).append(new StringBuilder(16).append("topicPartition=").append(this.topicPartition()).append(")").toString()).toString();
    }

    /*
     * WARNING - void declaration
     */
    private KafkaConsumer<K, V> createConsumer() {
        void var1_1;
        KafkaConsumer c = new KafkaConsumer(this.kafkaParams());
        List<Object> topics = Arrays.asList((Object[])new TopicPartition[]{this.topicPartition()});
        c.assign(topics);
        return var1_1;
    }

    public void close() {
        this.consumer().close();
    }

    public ConsumerRecord<K, V> get(long offset, long timeout) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(28).append("Get ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" nextOffset ").append(this.nextOffset()).append(" requested ").append(offset).toString());
        if (offset != this.nextOffset()) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(20).append("Initial fetch for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(timeout);
        }
        if (!this.buffer().hasNext()) {
            this.poll(timeout);
        }
        Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("Failed to get records for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).append(" after polling for ").append(timeout).toString());
        ObjectRef record = ObjectRef.create(this.buffer().next());
        if (((ConsumerRecord)record.elem).offset() != offset) {
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(18).append("Buffer miss for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(timeout);
            Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(47).append("Failed to get records for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).append(" after polling for ").append(timeout).toString());
            record.elem = this.buffer().next();
            Predef$.MODULE$.require(((ConsumerRecord)record.elem).offset() == offset, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(101).append("Got wrong record for ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" even after seeking to offset ").append(offset).append(" ").append(new StringBuilder(69).append("got offset ").append(((ConsumerRecord)record$1.elem).offset()).append(" instead. If this is a compacted topic, consider enabling ").toString()).append("spark.streaming.kafka.allowNonConsecutiveOffsets").toString());
        }
        this.nextOffset_$eq(offset + 1L);
        return (ConsumerRecord)record.elem;
    }

    public void compactedStart(long offset, long pollTimeoutMs) {
        block0: {
            this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(27).append("compacted start ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" starting ").append(offset).toString());
            if (offset == this.nextOffset()) break block0;
            this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(30).append("Initial fetch for compacted ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(offset).toString());
            this.seek(offset);
            this.poll(pollTimeoutMs);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ConsumerRecord<K, V> compactedNext(long pollTimeoutMs) {
        void var3_2;
        if (!this.buffer().hasNext()) {
            this.poll(pollTimeoutMs);
        }
        Predef$.MODULE$.require(this.buffer().hasNext(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(38).append("Failed to get records for compacted ").append(this.groupId()).append(" ").append(this.topicPartition()).append(" ").append(new StringBuilder(18).append("after polling for ").append(pollTimeoutMs).toString()).toString());
        ConsumerRecord<K, V> record = this.buffer().next();
        this.nextOffset_$eq(record.offset() + 1L);
        return var3_2;
    }

    public ConsumerRecord<K, V> compactedPrevious() {
        return this.buffer().previous();
    }

    private void seek(long offset) {
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(12).append("Seeking to ").append(this.topicPartition()).append(" ").append(offset).toString());
        this.consumer().seek(this.topicPartition(), offset);
    }

    private void poll(long timeout) {
        ConsumerRecords p = this.consumer().poll(timeout);
        List r = p.records(this.topicPartition());
        this.logDebug((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(9).append("Polled ").append(p.partitions()).append("  ").append(r.size()).toString());
        this.buffer_$eq(r.listIterator());
    }

    public InternalKafkaConsumer(TopicPartition topicPartition, Map<String, Object> kafkaParams) {
        this.topicPartition = topicPartition;
        this.kafkaParams = kafkaParams;
        Logging.$init$((Logging)this);
        this.groupId = (String)kafkaParams.get("group.id");
        this.consumer = this.createConsumer();
        this.inUse = true;
        this.markedForClose = false;
        this.buffer = Collections.emptyListIterator();
        this.nextOffset = InternalKafkaConsumer$.MODULE$.org$apache$spark$streaming$kafka010$InternalKafkaConsumer$$UNKNOWN_OFFSET();
    }
}

