/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.PreferredReplicaLeaderElectionCommand;
import kafka.common.TopicAndPartition;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Json$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNodeExistsException;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class PreferredReplicaLeaderElectionCommand$
implements Logging {
    public static final PreferredReplicaLeaderElectionCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new PreferredReplicaLeaderElectionCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        PreferredReplicaLeaderElectionCommand$ preferredReplicaLeaderElectionCommand$ = this;
        synchronized (preferredReplicaLeaderElectionCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec jsonFileOpt = parser.accepts("path-to-json-file", "The JSON file with the list of partitions for which preferred replica leader election should be done, in the following format - \n{\"partitions\":\n\t[{\"topic\": \"foo\", \"partition\": 1},\n\t {\"topic\": \"foobar\", \"partition\": 2}]\n}\nDefaults to all existing partitions").withRequiredArg().describedAs("list of partitions for which preferred replica leader election needs to be triggered").ofType(String.class);
        ArgumentAcceptingOptionSpec zkConnectOpt = parser.accepts("zookeeper", "REQUIRED: The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over.").withRequiredArg().describedAs("urls").ofType(String.class);
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "This tool causes leadership for each partition to be transferred back to the 'preferred replica', it can be used to balance leadership among the servers.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{zkConnectOpt}));
        String zkConnect = (String)options.valueOf((OptionSpec)zkConnectOpt);
        ZkClient zkClient = null;
        try {
            zkClient = new ZkClient(zkConnect, 30000, 30000, ZKStringSerializer$.MODULE$);
            Set<TopicAndPartition> partitionsForPreferredReplicaElection = options.has((OptionSpec)jsonFileOpt) ? this.parsePreferredReplicaElectionData(Utils$.MODULE$.readFileAsString((String)options.valueOf((OptionSpec)jsonFileOpt), Utils$.MODULE$.readFileAsString$default$2())) : ZkUtils$.MODULE$.getAllPartitions(zkClient);
            PreferredReplicaLeaderElectionCommand preferredReplicaElectionCommand = new PreferredReplicaLeaderElectionCommand(zkClient, partitionsForPreferredReplicaElection);
            preferredReplicaElectionCommand.moveLeaderToPreferredReplica();
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Successfully started preferred replica election for partitions %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsForPreferredReplicaElection})));
            if (zkClient == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println((Object)"Failed to start preferred replica election");
                Predef$.MODULE$.println((Object)Utils$.MODULE$.stackTrace(throwable));
            }
            finally {
                if (zkClient == null) return;
                zkClient.close();
            }
        }
        zkClient.close();
    }

    public scala.collection.immutable.Set<TopicAndPartition> parsePreferredReplicaElectionData(String jsonString) {
        Option<Object> option = Json$.MODULE$.parseFull(jsonString);
        if (option instanceof Some) {
            Some some = (Some)option;
            Object m = some.x();
            Option option2 = ((Map)m).get((Object)"partitions");
            if (option2 instanceof Some) {
                scala.collection.immutable.Set set;
                Some some2 = (Some)option2;
                Object partitionsList = some2.x();
                List partitionsRaw = (List)partitionsList;
                List partitions = (List)partitionsRaw.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(Map<String, Object> p) {
                        String topic = (String)p.get((Object)"topic").get();
                        int partition = BoxesRunTime.unboxToInt((Object)p.get((Object)"partition").get());
                        return new TopicAndPartition(topic, partition);
                    }
                }, List$.MODULE$.canBuildFrom());
                Iterable duplicatePartitions = Utils$.MODULE$.duplicates(partitions);
                scala.collection.immutable.Set partitionsSet = partitions.toSet();
                if (duplicatePartitions.nonEmpty()) {
                    throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Preferred replica election data contains duplicate partitions: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicatePartitions.mkString(",")})));
                }
                scala.collection.immutable.Set set2 = set = partitionsSet;
                return set2;
            }
            None$ none$ = None$.MODULE$;
            Option option3 = option2;
            if (!(none$ != null ? !none$.equals(option3) : option3 != null)) {
                throw new AdminOperationException("Preferred replica election data is empty");
            }
            throw new MatchError((Object)option2);
        }
        None$ none$ = None$.MODULE$;
        Option<Object> option4 = option;
        if (!(none$ != null ? !none$.equals(option4) : option4 != null)) {
            throw new AdminOperationException("Preferred replica election data is empty");
        }
        throw new MatchError(option);
    }

    public void writePreferredReplicaElectionData(ZkClient zkClient, Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection) {
        String zkPath = ZkUtils$.MODULE$.PreferredReplicaLeaderElectionPath();
        Set partitionsList = (Set)partitionsUndergoingPreferredReplicaElection.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Map<String, Object> apply(TopicAndPartition e) {
                return (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"topic"), (Object)e.topic()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)e.partition()))}));
            }
        }, Set$.MODULE$.canBuildFrom());
        String jsonData = Json$.MODULE$.encode(Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"version"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partitions"), (Object)partitionsList)})));
        try {
            ZkUtils$.MODULE$.createPersistentPath(zkClient, zkPath, jsonData);
            this.info((Function0<String>)new Serializable(jsonData){
                public static final long serialVersionUID = 0L;
                private final String jsonData$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Created preferred replica election path with %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.jsonData$1}));
                }
                {
                    this.jsonData$1 = jsonData$1;
                }
            });
            return;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(throwable.toString());
        }
        catch (ZkNodeExistsException zkNodeExistsException) {
            scala.collection.immutable.Set<TopicAndPartition> partitionsUndergoingPreferredReplicaElection2 = this.parsePreferredReplicaElectionData((String)ZkUtils$.MODULE$.readData(zkClient, zkPath)._1());
            throw new AdminOperationException(new StringBuilder().append((Object)"Preferred replica leader election currently in progress for ").append((Object)new StringOps(Predef$.MODULE$.augmentString("%s. Aborting operation")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionsUndergoingPreferredReplicaElection2}))).toString());
        }
    }

    private PreferredReplicaLeaderElectionCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

