/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.mqtt;

import com.google.common.base.Charsets;
import java.io.File;
import java.net.ServerSocket;
import java.net.URI;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.commons.lang3.RandomUtils;
import org.apache.spark.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.util.Utils$;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001U4Q!\u0001\u0002\u0001\u00051\u0011Q\"T)U)R+7\u000f^+uS2\u001c(BA\u0002\u0005\u0003\u0011i\u0017\u000f\u001e;\u000b\u0005\u00151\u0011!C:ue\u0016\fW.\u001b8h\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000b\u000e\u0003\u0019I!A\u0006\u0004\u0003\u000f1{wmZ5oO\")\u0001\u0004\u0001C\u00015\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\n}\ta\u0002]3sg&\u001cH/\u001a8dK\u0012K'/F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0002j_*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u00111\u0015\u000e\\3\t\r%\u0002\u0001\u0015!\u0003!\u0003=\u0001XM]:jgR,gnY3ESJ\u0004\u0003bB\u0016\u0001\u0005\u0004%I\u0001L\u0001\u000bEJ|7.\u001a:I_N$X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0005A\"\u0013\u0001\u00027b]\u001eL!AM\u0018\u0003\rM#(/\u001b8h\u0011\u0019!\u0004\u0001)A\u0005[\u0005Y!M]8lKJDun\u001d;!\u0011\u001d1\u0004A1A\u0005\n]\n!B\u0019:pW\u0016\u0014\bk\u001c:u+\u0005A\u0004C\u0001\b:\u0013\tQtBA\u0002J]RDa\u0001\u0010\u0001!\u0002\u0013A\u0014a\u00032s_.,'\u000fU8si\u0002B\u0011B\u0010\u0001A\u0002\u0003\u0007I\u0011B \u0002\r\t\u0014xn[3s+\u0005\u0001\u0005CA!F\u001b\u0005\u0011%B\u0001 D\u0015\t!\u0005\"\u0001\u0005bGRLg/Z7r\u0013\t1%IA\u0007Ce>\\WM]*feZL7-\u001a\u0005\n\u0011\u0002\u0001\r\u00111A\u0005\n%\u000b!B\u0019:pW\u0016\u0014x\fJ3r)\tQU\n\u0005\u0002\u000f\u0017&\u0011Aj\u0004\u0002\u0005+:LG\u000fC\u0004O\u000f\u0006\u0005\t\u0019\u0001!\u0002\u0007a$\u0013\u0007\u0003\u0004Q\u0001\u0001\u0006K\u0001Q\u0001\bEJ|7.\u001a:!\u0011%\u0011\u0006\u00011AA\u0002\u0013%1+A\u0005d_:tWm\u0019;peV\tA\u000b\u0005\u0002B+&\u0011aK\u0011\u0002\u0013)J\fgn\u001d9peR\u001cuN\u001c8fGR|'\u000fC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\u0006i1m\u001c8oK\u000e$xN]0%KF$\"A\u0013.\t\u000f9;\u0016\u0011!a\u0001)\"1A\f\u0001Q!\nQ\u000b!bY8o]\u0016\u001cGo\u001c:!\u0011\u0015q\u0006\u0001\"\u0001`\u0003%\u0011'o\\6feV\u0013\u0018.F\u0001a!\t\tGM\u0004\u0002\u000fE&\u00111mD\u0001\u0007!J,G-\u001a4\n\u0005I*'BA2\u0010\u0011\u00159\u0007\u0001\"\u0001i\u0003\u0015\u0019X\r^;q)\u0005Q\u0005\"\u00026\u0001\t\u0003A\u0017\u0001\u0003;fCJ$wn\u001e8\t\u000b1\u0004A\u0011B7\u0002\u0019\u0019Lg\u000e\u001a$sK\u0016\u0004vN\u001d;\u0015\u0003aBQa\u001c\u0001\u0005\u0002A\f1\u0002];cY&\u001c\b\u000eR1uCR\u0019!*]:\t\u000bIt\u0007\u0019\u00011\u0002\u000bQ|\u0007/[2\t\u000bQt\u0007\u0019\u00011\u0002\t\u0011\fG/\u0019")
public class MQTTTestUtils
implements Logging {
    private final File persistenceDir;
    private final String brokerHost;
    private final int brokerPort;
    private BrokerService broker;
    private TransportConnector connector;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private File persistenceDir() {
        return this.persistenceDir;
    }

    private String brokerHost() {
        return this.brokerHost;
    }

    private int brokerPort() {
        return this.brokerPort;
    }

    private BrokerService broker() {
        return this.broker;
    }

    private void broker_$eq(BrokerService x$1) {
        this.broker = x$1;
    }

    private TransportConnector connector() {
        return this.connector;
    }

    private void connector_$eq(TransportConnector x$1) {
        this.connector = x$1;
    }

    public String brokerUri() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.brokerHost(), BoxesRunTime.boxToInteger((int)this.brokerPort())}));
    }

    public void setup() {
        this.broker_$eq(new BrokerService());
        this.broker().setDataDirectoryFile(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
        this.connector_$eq(new TransportConnector());
        this.connector().setName("mqtt");
        this.connector().setUri(new URI(new StringBuilder().append((Object)"mqtt://").append((Object)this.brokerUri()).toString()));
        this.broker().addConnector(this.connector());
        this.broker().start();
    }

    public void teardown() {
        if (this.broker() != null) {
            this.broker().stop();
            this.broker_$eq(null);
        }
        if (this.connector() != null) {
            this.connector().stop();
            this.connector_$eq(null);
        }
        Utils$.MODULE$.deleteRecursively(this.persistenceDir());
    }

    private int findFreePort() {
        int candidatePort = RandomUtils.nextInt((int)1024, (int)65536);
        return Utils$.MODULE$.startServiceOnPort(candidatePort, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Null$, Object> apply(int trialPort) {
                ServerSocket socket = new ServerSocket(trialPort);
                socket.close();
                return new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)trialPort));
            }
        }, new SparkConf(), Utils$.MODULE$.startServiceOnPort$default$4())._2$mcI$sp();
    }

    public void publishData(String topic, String data) {
        MqttClient client = null;
        try {
            MqttDefaultFilePersistence persistence = new MqttDefaultFilePersistence(this.persistenceDir().getAbsolutePath());
            client = new MqttClient(new StringBuilder().append((Object)"tcp://").append((Object)this.brokerUri()).toString(), MqttClient.generateClientId(), (MqttClientPersistence)persistence);
            client.connect();
            if (client.isConnected()) {
                MqttTopic msgTopic = client.getTopic(topic);
                MqttMessage message = new MqttMessage(data.getBytes(Charsets.UTF_8));
                message.setQos(1);
                message.setRetained(true);
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)new Serializable(this, msgTopic, message){
                    public static final long serialVersionUID = 0L;
                    private final MqttTopic msgTopic$1;
                    private final MqttMessage message$1;

                    public final Object apply(int i) {
                        Throwable throwable2;
                        block2: {
                            MqttDeliveryToken mqttDeliveryToken;
                            try {
                                mqttDeliveryToken = this.msgTopic$1.publish(this.message$1);
                            }
                            catch (Throwable throwable2) {
                                MqttException mqttException;
                                Throwable throwable3 = throwable2;
                                if (!(throwable3 instanceof MqttException) || (mqttException = (MqttException)throwable3).getReasonCode() != 32202) break block2;
                                Thread.sleep(50L);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                mqttDeliveryToken = boxedUnit;
                            }
                            return mqttDeliveryToken;
                        }
                        throw throwable2;
                    }
                    {
                        this.msgTopic$1 = msgTopic$1;
                        this.message$1 = message$1;
                    }
                });
            }
            return;
        }
        finally {
            if (client != null) {
                client.disconnect();
                client.close();
                client = null;
            }
        }
    }

    public MQTTTestUtils() {
        Logging.class.$init$((Logging)this);
        this.persistenceDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
        this.brokerHost = "localhost";
        this.brokerPort = this.findFreePort();
    }
}

