/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.BlockRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerMaster;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.streaming.BatchCounter;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StateObject;
import org.apache.spark.streaming.StateObject$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.TestInputStream;
import org.apache.spark.streaming.TestOutputStream;
import org.apache.spark.streaming.TestServer;
import org.apache.spark.streaming.TestServer$;
import org.apache.spark.streaming.TestSuiteBase;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.Time$;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.streaming.dstream.WindowedDStream;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.enablers.Retrying$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.concurrent.Map;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0005i4Aa\u0002\u0005\u0001#!)!\u0004\u0001C\u00017!9Q\u0004\u0001b\u0001\n\u0003q\u0002B\u0002\u0019\u0001A\u0003%q\u0004C\u00032\u0001\u0011\u0005!\u0007C\u0004h\u0001E\u0005I\u0011\u00015\t\u000fU\u0004\u0011\u0013!C\u0001m\n!\")Y:jG>\u0003XM]1uS>t7oU;ji\u0016T!!\u0003\u0006\u0002\u0013M$(/Z1nS:<'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0005\f\u0011\u0005M!R\"\u0001\u0006\n\u0005UQ!!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001815\t\u0001\"\u0003\u0002\u001a\u0011\tiA+Z:u'VLG/\u001a\"bg\u0016\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005]\u0001\u0011\u0001E2mK\u0006tW\u000f\u001d+fgRLe\u000e];u+\u0005y\u0002c\u0001\u0011(S5\t\u0011E\u0003\u0002#G\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003I\u0015\n!bY8mY\u0016\u001cG/[8o\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015\"\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0004A)b\u0013BA\u0016\"\u0005\r\u0019V-\u001d\t\u0003[9j\u0011!J\u0005\u0003_\u0015\u00121!\u00138u\u0003E\u0019G.Z1okB$Vm\u001d;J]B,H\u000fI\u0001\u000feVt7\t\\3b]V\u0004H+Z:u+\t\u0019d\bF\u00035/r\u0003'\r\u0006\u00026\u001fR\u0011ag\u0012\t\u0004oibT\"\u0001\u001d\u000b\u0005eB\u0011a\u00023tiJ,\u0017-\\\u0005\u0003wa\u0012q\u0001R*ue\u0016\fW\u000e\u0005\u0002>}1\u0001A!B \u0005\u0005\u0004\u0001%!\u0001+\u0012\u0005\u0005#\u0005CA\u0017C\u0013\t\u0019UEA\u0004O_RD\u0017N\\4\u0011\u00055*\u0015B\u0001$&\u0005\r\te.\u001f\u0005\b\u0011\u0012\t\t\u0011q\u0001J\u0003))g/\u001b3f]\u000e,G%\r\t\u0004\u00156cT\"A&\u000b\u00051+\u0013a\u0002:fM2,7\r^\u0005\u0003\u001d.\u0013\u0001b\u00117bgN$\u0016m\u001a\u0005\u0006!\u0012\u0001\r!U\u0001\u000eCN\u001cXM\u001d;DY\u0016\fg.\u001e9\u0011\t5\u0012f\u0007V\u0005\u0003'\u0016\u0012\u0011BR;oGRLwN\\\u0019\u0011\u00055*\u0016B\u0001,&\u0005\u0011)f.\u001b;\t\u000ba#\u0001\u0019A-\u0002\u000b\r|gN\u001a\u001a\u0011\u0005MQ\u0016BA.\u000b\u0005%\u0019\u0006/\u0019:l\u0007>tg\rC\u0003^\t\u0001\u0007a,A\u0005pa\u0016\u0014\u0018\r^5p]B!QFU07!\r9$\b\f\u0005\bC\u0012\u0001\n\u00111\u0001-\u0003EqW/\\#ya\u0016\u001cG/\u001a3PkR\u0004X\u000f\u001e\u0005\bG\u0012\u0001\n\u00111\u0001e\u0003A\u0011X-\\3nE\u0016\u0014H)\u001e:bi&|g\u000e\u0005\u0002\u0018K&\u0011a\r\u0003\u0002\t\tV\u0014\u0018\r^5p]\u0006A\"/\u001e8DY\u0016\fg.\u001e9UKN$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005%$X#\u00016+\u00051Z7&\u00017\u0011\u00055\u0014X\"\u00018\u000b\u0005=\u0004\u0018!C;oG\",7m[3e\u0015\t\tX%\u0001\u0006b]:|G/\u0019;j_:L!a\u001d8\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rB\u0003@\u000b\t\u0007\u0001)\u0001\rsk:\u001cE.Z1okB$Vm\u001d;%I\u00164\u0017-\u001e7uIQ*\"a^=\u0016\u0003aT#\u0001Z6\u0005\u000b}2!\u0019\u0001!")
public class BasicOperationsSuite
extends SparkFunSuite
implements TestSuiteBase {
    private final IndexedSeq<Seq<Object>> cleanupTestInput;
    private String checkpointDir;
    private SparkConf conf;
    private PatienceConfiguration.Timeout eventuallyTimeout;
    private volatile boolean bitmap$0;

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    @Override
    public /* synthetic */ void org$apache$spark$streaming$TestSuiteBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public String framework() {
        return TestSuiteBase.framework$(this);
    }

    @Override
    public String master() {
        return TestSuiteBase.master$(this);
    }

    @Override
    public Duration batchDuration() {
        return TestSuiteBase.batchDuration$(this);
    }

    @Override
    public int numInputPartitions() {
        return TestSuiteBase.numInputPartitions$(this);
    }

    @Override
    public int maxWaitTimeMillis() {
        return TestSuiteBase.maxWaitTimeMillis$(this);
    }

    @Override
    public boolean useManualClock() {
        return TestSuiteBase.useManualClock$(this);
    }

    @Override
    public boolean actuallyWait() {
        return TestSuiteBase.actuallyWait$(this);
    }

    @Override
    public void beforeFunction() {
        TestSuiteBase.beforeFunction$(this);
    }

    @Override
    public void afterFunction() {
        TestSuiteBase.afterFunction$(this);
    }

    @Override
    public void beforeEach() {
        TestSuiteBase.beforeEach$(this);
    }

    @Override
    public void afterEach() {
        TestSuiteBase.afterEach$(this);
    }

    @Override
    public <R> R withStreamingContext(StreamingContext ssc, Function1<StreamingContext, R> block) {
        return (R)TestSuiteBase.withStreamingContext$(this, ssc, block);
    }

    @Override
    public <R> R withTestServer(TestServer testServer, Function1<TestServer, R> block) {
        return (R)TestSuiteBase.withTestServer$(this, testServer, block);
    }

    @Override
    public <U, V> StreamingContext setupStreams(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, int numPartitions, ClassTag<U> evidence$4, ClassTag<V> evidence$5) {
        return TestSuiteBase.setupStreams$(this, input, operation, numPartitions, evidence$4, evidence$5);
    }

    @Override
    public <U, V> int setupStreams$default$3() {
        return TestSuiteBase.setupStreams$default$3$(this);
    }

    @Override
    public <U, V, W> StreamingContext setupStreams(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, ClassTag<U> evidence$6, ClassTag<V> evidence$7, ClassTag<W> evidence$8) {
        return TestSuiteBase.setupStreams$(this, input1, input2, operation, evidence$6, evidence$7, evidence$8);
    }

    @Override
    public <V> Seq<Seq<V>> runStreams(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$9) {
        return TestSuiteBase.runStreams$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$9);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreams$default$4() {
        return TestSuiteBase.runStreams$default$4$(this);
    }

    @Override
    public <V> Seq<Seq<Seq<V>>> runStreamsWithPartitions(StreamingContext ssc, int numBatches, int numExpectedOutput, Function0<BoxedUnit> preStop, ClassTag<V> evidence$10) {
        return TestSuiteBase.runStreamsWithPartitions$(this, ssc, numBatches, numExpectedOutput, preStop, evidence$10);
    }

    @Override
    public <V> Function0<BoxedUnit> runStreamsWithPartitions$default$4() {
        return TestSuiteBase.runStreamsWithPartitions$default$4$(this);
    }

    @Override
    public <V> void verifyOutput(Seq<Seq<V>> output, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<V> evidence$11) {
        TestSuiteBase.verifyOutput$(this, output, expectedOutput, useSet, evidence$11);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, boolean useSet, ClassTag<U> evidence$12, ClassTag<V> evidence$13) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, useSet, evidence$12, evidence$13);
    }

    @Override
    public <U, V> boolean testOperation$default$4() {
        return TestSuiteBase.testOperation$default$4$(this);
    }

    @Override
    public <U, V> void testOperation(Seq<Seq<U>> input, Function1<DStream<U>, DStream<V>> operation, Seq<Seq<V>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$14, ClassTag<V> evidence$15) {
        TestSuiteBase.testOperation$(this, input, operation, expectedOutput, numBatches, useSet, evidence$14, evidence$15);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, boolean useSet, ClassTag<U> evidence$16, ClassTag<V> evidence$17, ClassTag<W> evidence$18) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, useSet, evidence$16, evidence$17, evidence$18);
    }

    @Override
    public <U, V, W> void testOperation(Seq<Seq<U>> input1, Seq<Seq<V>> input2, Function2<DStream<U>, DStream<V>, DStream<W>> operation, Seq<Seq<W>> expectedOutput, int numBatches, boolean useSet, ClassTag<U> evidence$19, ClassTag<V> evidence$20, ClassTag<W> evidence$21) {
        TestSuiteBase.testOperation$(this, input1, input2, operation, expectedOutput, numBatches, useSet, evidence$19, evidence$20, evidence$21);
    }

    private String checkpointDir$lzycompute() {
        BasicOperationsSuite basicOperationsSuite = this;
        synchronized (basicOperationsSuite) {
            if (!this.bitmap$0) {
                this.checkpointDir = TestSuiteBase.checkpointDir$(this);
                this.bitmap$0 = true;
            }
        }
        return this.checkpointDir;
    }

    @Override
    public String checkpointDir() {
        return !this.bitmap$0 ? this.checkpointDir$lzycompute() : this.checkpointDir;
    }

    @Override
    public SparkConf conf() {
        return this.conf;
    }

    @Override
    public PatienceConfiguration.Timeout eventuallyTimeout() {
        return this.eventuallyTimeout;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$conf_$eq(SparkConf x$1) {
        this.conf = x$1;
    }

    @Override
    public void org$apache$spark$streaming$TestSuiteBase$_setter_$eventuallyTimeout_$eq(PatienceConfiguration.Timeout x$1) {
        this.eventuallyTimeout = x$1;
    }

    public IndexedSeq<Seq<Object>> cleanupTestInput() {
        return this.cleanupTestInput;
    }

    public <T> DStream<T> runCleanupTest(SparkConf conf2, Function1<DStream<Object>, DStream<T>> operation, int numExpectedOutput, Duration rememberDuration, Function1<DStream<T>, BoxedUnit> assertCleanup, ClassTag<T> evidence$1) {
        TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(this.batchDuration());
        Duration $org_scalatest_assert_macro_right = Seconds$.MODULE$.apply(1L);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Batch duration has changed from 1 second, check cleanup tests", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 799));
        return (DStream)this.withStreamingContext(this.setupStreams((Seq)this.cleanupTestInput(), (Function1)operation, this.setupStreams$default$3(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)evidence$1), (Function1 & Serializable)ssc -> {
            DStream operatedStream = (DStream)((DStream)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])ssc.graph().getOutputStreams()))).dependencies().head();
            if (rememberDuration != null) {
                ssc.remember(rememberDuration);
            }
            Seq output = this.runStreams((StreamingContext)ssc, this.cleanupTestInput().size(), numExpectedOutput, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> assertCleanup.apply((Object)operatedStream), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class));
            Clock clock = ssc.scheduler().clock();
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToLong((long)clock.getTimeMillis()));
            long $org_scalatest_assert_macro_right = Seconds$.MODULE$.apply(10L).milliseconds();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 811));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)output.size()));
            int $org_scalatest_assert_macro_right2 = numExpectedOutput;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
            return operatedStream;
        });
    }

    public <T> int runCleanupTest$default$3() {
        return this.cleanupTestInput().size();
    }

    public <T> Duration runCleanupTest$default$4() {
        return null;
    }

    public static final /* synthetic */ String $anonfun$new$3(int x$1) {
        return Integer.toString(x$1);
    }

    public static final /* synthetic */ String $anonfun$new$5(int x$3) {
        return Integer.toString(x$3);
    }

    public static final /* synthetic */ Seq $anonfun$new$8(int x) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{x, x * 2}));
    }

    public static final /* synthetic */ Seq $anonfun$new$52(int x) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{x, x + 10}));
    }

    public static final /* synthetic */ String $anonfun$new$67(int x$21) {
        return Integer.toString(x$21);
    }

    public static final /* synthetic */ String $anonfun$new$69(int x$23) {
        return Integer.toString(x$23);
    }

    public static final /* synthetic */ String $anonfun$new$78(int x$24) {
        return Integer.toString(x$24);
    }

    public static final /* synthetic */ boolean $anonfun$new$79(Range.Inclusive x$25) {
        return x$25 == null;
    }

    public static final /* synthetic */ String $anonfun$new$81(int x$27) {
        return Integer.toString(x$27);
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$147(Tuple3 t$1, int s) {
        return new Tuple2(t$1._1(), (Object)BoxesRunTime.boxToInteger((int)s));
    }

    public static final /* synthetic */ void $anonfun$new$157(RDD x$35) {
    }

    private static final Set getInputFromSlice$1(long fromMillis, long toMillis, TestInputStream stream$1) {
        return ((IterableOnceOps)stream$1.slice(new Time(fromMillis), new Time(toMillis)).flatMap((Function1 & Serializable)x$36 -> Predef$.MODULE$.wrapIntArray((int[])x$36.collect()))).toSet();
    }

    public static final /* synthetic */ Seq $anonfun$cleanupTestInput$1(int x) {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{x, x + 1}));
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$163(int x) {
        return new Tuple2.mcII.sp(x % 10, 1);
    }

    private static final DStream operation$3(DStream s) {
        return s.map((Function1 & Serializable)x -> BasicOperationsSuite.$anonfun$new$163(BoxesRunTime.unboxToInt((Object)x)), ClassTag$.MODULE$.apply(Tuple2.class)).window(Seconds$.MODULE$.apply(2L), Seconds$.MODULE$.apply(1L)).window(Seconds$.MODULE$.apply(4L), Seconds$.MODULE$.apply(2L));
    }

    public static final /* synthetic */ void $anonfun$new$178(HashMap blockRdds$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Time time = (Time)tuple2._1();
        RDD rdd = (RDD)tuple2._2();
        blockRdds$1.update((Object)time, (Object)((BlockRDD)rdd));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$new$179(HashMap persistentRddIds$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Time time = (Time)tuple2._1();
        RDD rdd = (RDD)tuple2._2();
        persistentRddIds$1.update((Object)time, (Object)BoxesRunTime.boxToInteger((int)rdd.id()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void collectRddInfo$1(ReceiverInputDStream networkStream$1, HashMap blockRdds$1, DStream mappedStream$1, HashMap persistentRddIds$1) {
        networkStream$1.generatedRDDs().foreach((Function1 & Serializable)x0$1 -> {
            BasicOperationsSuite.$anonfun$new$178(blockRdds$1, x0$1);
            return BoxedUnit.UNIT;
        });
        mappedStream$1.generatedRDDs().foreach((Function1 & Serializable)x0$2 -> {
            BasicOperationsSuite.$anonfun$new$179(persistentRddIds$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$176(BasicOperationsSuite $this, TestServer testServer$1, StreamingContext ssc) {
        testServer$1.start();
        BatchCounter batchCounter = new BatchCounter(ssc);
        ReceiverInputDStream networkStream = ssc.socketTextStream("localhost", testServer$1.port(), StorageLevel$.MODULE$.MEMORY_AND_DISK());
        DStream mappedStream = networkStream.map((Function1 & Serializable)x$39 -> new StringBuilder(1).append((String)x$39).append(".").toString(), ClassTag$.MODULE$.apply(String.class)).persist();
        ConcurrentLinkedQueue outputQueue = new ConcurrentLinkedQueue();
        TestOutputStream outputStream = new TestOutputStream(mappedStream, outputQueue, ClassTag$.MODULE$.apply(String.class));
        outputStream.register();
        ssc.start();
        ManualClock clock = (ManualClock)ssc.scheduler().clock();
        Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5, 6}));
        HashMap blockRdds = new HashMap();
        HashMap persistentRddIds = new HashMap();
        Thread.sleep(200L);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), input.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            testServer$1.send(new StringBuilder(1).append(input.apply(i).toString()).append("\n").toString());
            Thread.sleep(200L);
            int numCompletedBatches = batchCounter.getNumCompletedBatches();
            clock.advance($this.batchDuration().milliseconds());
            if (!batchCounter.waitUntilBatchesCompleted(numCompletedBatches + 1, 5000L)) {
                throw $this.fail("Batch took more than 5 seconds to complete", new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 751));
            }
            BasicOperationsSuite.collectRddInfo$1(networkStream, blockRdds, mappedStream, persistentRddIds);
        });
        Thread.sleep(200L);
        BasicOperationsSuite.collectRddInfo$1(networkStream, blockRdds, mappedStream, persistentRddIds);
        $this.logInfo((Function0 & Serializable)() -> "Stopping server");
        testServer$1.stop();
        ConcurrentLinkedQueue $org_scalatest_assert_macro_left = outputQueue;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.unaryMacroBool($org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
        int $org_scalatest_assert_macro_left2 = blockRdds.size();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 763));
        int $org_scalatest_assert_macro_left3 = persistentRddIds.size();
        int $org_scalatest_assert_macro_right2 = 0;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 764));
        int latestPersistedRddId = BoxesRunTime.unboxToInt((Object)persistentRddIds.apply(persistentRddIds.keySet().max(Time$.MODULE$.ordering())));
        int earliestPersistedRddId = BoxesRunTime.unboxToInt((Object)persistentRddIds.apply(persistentRddIds.keySet().min(Time$.MODULE$.ordering())));
        BlockRDD latestBlockRdd = (BlockRDD)blockRdds.apply(blockRdds.keySet().max(Time$.MODULE$.ordering()));
        BlockRDD earliestBlockRdd = (BlockRDD)blockRdds.apply(blockRdds.keySet().min(Time$.MODULE$.ordering()));
        Map $org_scalatest_assert_macro_left4 = ssc.sparkContext().persistentRdds();
        int $org_scalatest_assert_macro_right3 = latestPersistedRddId;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3)), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 773));
        Map $org_scalatest_assert_macro_left5 = ssc.sparkContext().persistentRdds();
        int $org_scalatest_assert_macro_right4 = earliestPersistedRddId;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5.contains((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4)), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 774));
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(latestBlockRdd.isValid(), "latestBlockRdd.isValid", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 777));
        Object $org_scalatest_assert_macro_left6 = latestBlockRdd.collect();
        Object $org_scalatest_assert_macro_right5 = null;
        Object object = $org_scalatest_assert_macro_left6;
        Object var34_33 = null;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left6, "!=", null, object == null ? var34_33 != null : !object.equals(var34_33), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 778));
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(earliestBlockRdd.isValid(), "earliestBlockRdd.isValid", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])earliestBlockRdd.blockIds()), (Function1 & Serializable)blockId -> {
            BlockManagerMaster $org_scalatest_assert_macro_left = ssc.sparkContext().env().blockManager().master();
            BlockId $org_scalatest_assert_macro_right = blockId;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
        });
    }

    public BasicOperationsSuite() {
        TestSuiteBase.$init$(this);
        this.test("map", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 12)}));
            this.testOperation((Seq)input, (Function1)(Function1 & Serializable)r -> r.map((Function1 & Serializable)x$1 -> BasicOperationsSuite.$anonfun$new$3(BoxesRunTime.unboxToInt((Object)x$1)), ClassTag$.MODULE$.apply(String.class)), (Seq)((Seq)input.map((Function1 & Serializable)x$2 -> x$2.map((Function1 & Serializable)x$3 -> BasicOperationsSuite.$anonfun$new$5(BoxesRunTime.unboxToInt((Object)x$3))))), this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(String.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 34));
        this.test("flatMap", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 12)}));
            this.testOperation((Seq)input, (Function1)(Function1 & Serializable)r -> r.flatMap((Function1 & Serializable)x -> BasicOperationsSuite.$anonfun$new$8(BoxesRunTime.unboxToInt((Object)x)), (ClassTag)ClassTag$.MODULE$.Int()), (Seq)((Seq)input.map((Function1 & Serializable)x$4 -> (IndexedSeq)x$4.flatMap((Function1 & Serializable)x -> Predef$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)x), BoxesRunTime.unboxToInt((Object)x) * 2})))), this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("filter", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 12)}));
            this.testOperation((Seq)input, (Function1)(Function1 & Serializable)r -> r.filter((Function1)(JFunction1.mcZI.sp & Serializable)x -> x % 2 == 0), (Seq)((Seq)input.map((Function1 & Serializable)x$5 -> (IndexedSeq)x$5.filter((Function1)(JFunction1.mcZI.sp & Serializable)x -> x % 2 == 0))), this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("glom", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.numInputPartitions()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Number of input partitions has been changed from 2", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 12)}));
            Seq output = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4}))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8}))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9, 10})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11, 12}))}))}));
            Function1 & Serializable operation = (Function1 & Serializable)r -> r.glom().map((Function1 & Serializable)x$6 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps(x$6)), ClassTag$.MODULE$.apply(Seq.class));
            this.testOperation((Seq)input, (Function1)operation, (Seq)output, this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(Seq.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("mapPartitions", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)this.numInputPartitions()));
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Number of input partitions has been changed from 2", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 12)}));
            Seq output = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 7})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11, 15})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{19, 23}))}));
            Function1 & Serializable operation = (Function1 & Serializable)r -> r.mapPartitions((Function1 & Serializable)x -> package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{BoxesRunTime.unboxToInt((Object)x.sum((Numeric)Numeric.IntIsIntegral$.MODULE$))})), r.mapPartitions$default$2(), (ClassTag)ClassTag$.MODULE$.Int());
            this.testOperation((Seq)input, (Function1)operation, (Seq)output, true, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("repartition (more partitions)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 200), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 300)}));
            Function1 & Serializable operation = (Function1 & Serializable)r -> r.repartition(5);
            return (Assertion)this.withStreamingContext(this.setupStreams((Seq)input, (Function1)operation, 2, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()), (Function1 & Serializable)ssc -> {
                Seq output = this.runStreamsWithPartitions((StreamingContext)ssc, 3, 3, this.runStreamsWithPartitions$default$4(), (ClassTag)ClassTag$.MODULE$.Nothing());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)output.size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                Seq[] outputArray = (Seq[])output.toArray(ClassTag$.MODULE$.apply(Seq.class));
                Seq first = outputArray[0];
                Seq second = outputArray[1];
                Seq third = outputArray[2];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)first.size()));
                int $org_scalatest_assert_macro_right2 = 5;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 92));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)second.size()));
                int $org_scalatest_assert_macro_right3 = 5;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)third.size()));
                int $org_scalatest_assert_macro_right4 = 5;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 94));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((IterableOnceOps)first.flatten(Predef$.MODULE$.$conforms())).toSet().equals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).toSet()), "first.flatten[Nothing](scala.Predef.$conforms[Seq[Nothing]]).toSet[Nothing].equals(scala.Predef.intWrapper(1).to(100).toSet[Int])", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((IterableOnceOps)second.flatten(Predef$.MODULE$.$conforms())).toSet().equals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 200).toSet()), "second.flatten[Nothing](scala.Predef.$conforms[Seq[Nothing]]).toSet[Nothing].equals(scala.Predef.intWrapper(101).to(200).toSet[Int])", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((IterableOnceOps)third.flatten(Predef$.MODULE$.$conforms())).toSet().equals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 300).toSet()), "third.flatten[Nothing](scala.Predef.$conforms[Seq[Nothing]]).toSet[Nothing].equals(scala.Predef.intWrapper(201).to(300).toSet[Int])", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            });
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        this.test("repartition (fewer partitions)", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 200), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 300)}));
            Function1 & Serializable operation = (Function1 & Serializable)r -> r.repartition(2);
            return (Assertion)this.withStreamingContext(this.setupStreams((Seq)input, (Function1)operation, 5, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()), (Function1 & Serializable)ssc -> {
                Seq output = this.runStreamsWithPartitions((StreamingContext)ssc, 3, 3, this.runStreamsWithPartitions$default$4(), (ClassTag)ClassTag$.MODULE$.Nothing());
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)output.size()));
                int $org_scalatest_assert_macro_right = 3;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                Seq[] outputArray = (Seq[])output.toArray(ClassTag$.MODULE$.apply(Seq.class));
                Seq first = outputArray[0];
                Seq second = outputArray[1];
                Seq third = outputArray[2];
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)first.size()));
                int $org_scalatest_assert_macro_right2 = 2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 113));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)second.size()));
                int $org_scalatest_assert_macro_right3 = 2;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)third.size()));
                int $org_scalatest_assert_macro_right4 = 2;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((IterableOnceOps)first.flatten(Predef$.MODULE$.$conforms())).toSet().equals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 100).toSet()), "first.flatten[Nothing](scala.Predef.$conforms[Seq[Nothing]]).toSet[Nothing].equals(scala.Predef.intWrapper(1).to(100).toSet[Int])", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((IterableOnceOps)second.flatten(Predef$.MODULE$.$conforms())).toSet().equals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 200).toSet()), "second.flatten[Nothing](scala.Predef.$conforms[Seq[Nothing]]).toSet[Nothing].equals(scala.Predef.intWrapper(101).to(200).toSet[Int])", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((IterableOnceOps)third.flatten(Predef$.MODULE$.$conforms())).toSet().equals((Object)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 300).toSet()), "third.flatten[Nothing](scala.Predef.$conforms[Seq[Nothing]]).toSet[Nothing].equals(scala.Predef.intWrapper(201).to(300).toSet[Int])", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            });
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("groupByKey", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable)s -> DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).groupByKey(), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1 & Serializable)x$7 -> x$7.toSeq(), ClassTag$.MODULE$.apply(Seq.class)), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1}))), new Tuple2((Object)"b", (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1})))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class)), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("reduceByKey", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable)s -> DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable)(x$8, x$9) -> x$8 + x$9), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class)), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        this.test("reduce", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 12)}))), (Function1)(Function1 & Serializable)s -> s.reduce((Function2)(JFunction2.mcIII.sp & Serializable)(x$10, x$11) -> x$10 + x$11), (Seq)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{10})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{26})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{42}))}))), this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        this.test("count", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4)}))), (Function1)(Function1 & Serializable)s -> s.count(), (Seq)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{2L})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{3L})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{4L}))}))), this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Long()), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("countByValue", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 1), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1, 1})), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 2), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1, 2, 2}))}))), (Function1)(Function1 & Serializable)s -> s.countByValue(s.countByValue$default$1(), (Ordering)Ordering.Int$.MODULE$), (Seq)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(1, 1L)})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(1, 3L)})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(1, 1L), new Tuple2.mcIJ.sp(2, 1L)})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcIJ.sp(2, 2L), new Tuple2.mcIJ.sp(1, 2L)}))}))), true, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(Tuple2.class)), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
        this.test("mapValues", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable)s -> DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable)(x$12, x$13) -> x$12 + x$13), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).mapValues((Function1)(JFunction1.mcII.sp & Serializable)x$14 -> x$14 + 10, (ClassTag)ClassTag$.MODULE$.Int()), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)12)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)11))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)12))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class)), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166));
        this.test("flatMapValues", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), (Function1 & Serializable)s -> DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable)(x$15, x$16) -> x$15 + x$16), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).flatMapValues((Function1 & Serializable)x -> BasicOperationsSuite.$anonfun$new$52(BoxesRunTime.unboxToInt((Object)x)), (ClassTag)ClassTag$.MODULE$.Int()), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)12)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)11))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"", (Object)BoxesRunTime.boxToInteger((int)12))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)})), true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class)), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        this.test("union", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 104), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 204)}));
            Seq output = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 108), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 208)}));
            this.testOperation((Seq)input, (Function1)(Function1 & Serializable)s -> s.union(s.map((Function1)(JFunction1.mcII.sp & Serializable)x$17 -> x$17 + 4, (ClassTag)ClassTag$.MODULE$.Int())), (Seq)output, this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
        this.test("union with input stream return None", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 104), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 204), null}));
            Seq output = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 108), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 208)}));
            return (SparkException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)input, (Function1)(Function1 & Serializable)s -> s.union(s.map((Function1)(JFunction1.mcII.sp & Serializable)x$18 -> x$18 + 4, (ClassTag)ClassTag$.MODULE$.Int())), (Seq)output, input.length(), false, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199))));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
        this.test("StreamingContext.union", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 104), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 204)}));
            Seq output = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 12), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 112), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 212)}));
            this.testOperation((Seq)input, (Function1)(Function1 & Serializable)s -> s.context().union((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DStream[]{s, s.map((Function1)(JFunction1.mcII.sp & Serializable)x$19 -> x$19 + 4, (ClassTag)ClassTag$.MODULE$.Int()), s.map((Function1)(JFunction1.mcII.sp & Serializable)x$20 -> x$20 + 8, (ClassTag)ClassTag$.MODULE$.Int())})), (ClassTag)ClassTag$.MODULE$.Int()), (Seq)output, this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
        this.test("transform", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(9), 12)}));
            this.testOperation((Seq)input, (Function1)(Function1 & Serializable)r -> r.transform((Function1 & Serializable)rdd -> rdd.map((Function1 & Serializable)x$21 -> BasicOperationsSuite.$anonfun$new$67(BoxesRunTime.unboxToInt((Object)x$21)), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class)), (Seq)((Seq)input.map((Function1 & Serializable)x$22 -> x$22.map((Function1 & Serializable)x$23 -> BasicOperationsSuite.$anonfun$new$69(BoxesRunTime.unboxToInt((Object)x$23))))), this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(String.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        this.test("transform with NULL", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4)}));
            return (SparkException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)input, (Function1)(Function1 & Serializable)r -> r.transform((Function1 & Serializable)rdd -> null, (ClassTag)ClassTag$.MODULE$.Int()), (Seq)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}))), 1, false, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232))));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        this.test("transform with input stream return None", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(5), 8), null}));
            return (SparkException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)input, (Function1)(Function1 & Serializable)r -> r.transform((Function1 & Serializable)rdd -> rdd.map((Function1 & Serializable)x$24 -> BasicOperationsSuite.$anonfun$new$78(BoxesRunTime.unboxToInt((Object)x$24)), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class)), (Seq)((Seq)((IterableOps)input.filterNot((Function1 & Serializable)x$25 -> BoxesRunTime.boxToBoolean((boolean)BasicOperationsSuite.$anonfun$new$79(x$25)))).map((Function1 & Serializable)x$26 -> x$26.map((Function1 & Serializable)x$27 -> BasicOperationsSuite.$anonfun$new$81(BoxesRunTime.unboxToInt((Object)x$27))))), input.length(), false, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245))));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
        this.test("transformWith", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq inputData2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"x")), new Tuple2((Object)"b", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"x"))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"x"))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Function2 & Serializable operation = (Function2 & Serializable)(s1, s2) -> {
                DStream t1 = s1.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class));
                DStream t2 = s2.map((Function1 & Serializable)x -> new Tuple2(x, (Object)"x"), ClassTag$.MODULE$.apply(Tuple2.class));
                return t1.transformWith(t2, (Function2 & Serializable)(rdd1, rdd2) -> RDD$.MODULE$.rddToPairRDDFunctions(rdd1, ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).join(rdd2), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class));
            };
            this.testOperation(inputData1, inputData2, operation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 256));
        this.test("transformWith with input stream return None", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq inputData1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})), null}));
            Seq inputData2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), null}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))}));
            Function2 & Serializable operation = (Function2 & Serializable)(s1, s2) -> s1.transformWith(s2, (Function2 & Serializable)(rdd1, rdd2) -> rdd1.union(rdd2), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class));
            return (SparkException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation(inputData1, inputData2, operation, outputData, inputData1.length(), true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292))));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("StreamingContext.transform", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 104), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 204)}));
            Seq output = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 12), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 112), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 212)}));
            Function1 & Serializable operation = (Function1 & Serializable)s -> s.context().transform((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DStream[]{s, s.map((Function1)(JFunction1.mcII.sp & Serializable)x$28 -> x$28 + 4, (ClassTag)ClassTag$.MODULE$.Int()), s.map((Function1)(JFunction1.mcII.sp & Serializable)x$29 -> x$29 + 8, (ClassTag)ClassTag$.MODULE$.Int())})), (Function2 & Serializable)(rdds, time) -> ((RDD)rdds.head()).context().union((Seq)rdds.map((Function1 & Serializable)x$30 -> x$30), (ClassTag)ClassTag$.MODULE$.Int()), (ClassTag)ClassTag$.MODULE$.Int());
            this.testOperation((Seq)input, (Function1)operation, (Seq)output, this.testOperation$default$4(), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int());
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 297));
        this.test("StreamingContext.transform with input stream return None", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 4), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 104), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 204), null}));
            Seq output = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Range.Inclusive[]{RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 12), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(101), 112), RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(201), 212)}));
            Function1 & Serializable operation = (Function1 & Serializable)s -> s.context().transform((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DStream[]{s, s.map((Function1)(JFunction1.mcII.sp & Serializable)x$31 -> x$31 + 4, (ClassTag)ClassTag$.MODULE$.Int()), s.map((Function1)(JFunction1.mcII.sp & Serializable)x$32 -> x$32 + 8, (ClassTag)ClassTag$.MODULE$.Int())})), (Function2 & Serializable)(rdds, time) -> ((RDD)rdds.head()).context().union((Seq)rdds.map((Function1 & Serializable)x$33 -> x$33), (ClassTag)ClassTag$.MODULE$.Int()), (ClassTag)ClassTag$.MODULE$.Int());
            return (SparkException)((Object)((Object)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.testOperation((Seq)input, (Function1)operation, (Seq)output, input.length(), false, (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int()), ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326))));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        this.test("cogroup", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq inputData2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 1})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x", "x"})))), new Tuple2((Object)"b", (Object)new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$))), new Tuple2((Object)"b", (Object)new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"})))), new Tuple2((Object)"", (Object)new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"x"}))))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Object)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Function2 & Serializable operation = (Function2 & Serializable)(s1, s2) -> DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(s1.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).cogroup(s2.map((Function1 & Serializable)x -> new Tuple2(x, (Object)"x"), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1 & Serializable)x -> new Tuple2((Object)((IterableOnceOps)x._1()).toSeq(), (Object)((IterableOnceOps)x._2()).toSeq()), ClassTag$.MODULE$.apply(Tuple2.class));
            this.testOperation(inputData1, inputData2, operation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        this.test("join", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq inputData2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"x")), new Tuple2((Object)"b", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"x"))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"x"))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Function2 & Serializable operation = (Function2 & Serializable)(s1, s2) -> DStream$.MODULE$.toPairDStreamFunctions(s1.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).join(s2.map((Function1 & Serializable)x -> new Tuple2(x, (Object)"x"), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class));
            this.testOperation(inputData1, inputData2, operation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
        this.test("leftOuterJoin", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq inputData2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)"x"))), new Tuple2((Object)"b", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)"x")))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Some((Object)"x"))), new Tuple2((Object)"a", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)None$.MODULE$))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)None$.MODULE$))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Function2 & Serializable operation = (Function2 & Serializable)(s1, s2) -> DStream$.MODULE$.toPairDStreamFunctions(s1.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).leftOuterJoin(s2.map((Function1 & Serializable)x -> new Tuple2(x, (Object)"x"), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class));
            this.testOperation(inputData1, inputData2, operation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
        this.test("rightOuterJoin", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq inputData2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"x")), new Tuple2((Object)"b", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"x"))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"x")), new Tuple2((Object)"b", (Object)new Tuple2((Object)None$.MODULE$, (Object)"x"))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)None$.MODULE$, (Object)"x"))}))}));
            Function2 & Serializable operation = (Function2 & Serializable)(s1, s2) -> DStream$.MODULE$.toPairDStreamFunctions(s1.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).rightOuterJoin(s2.map((Function1 & Serializable)x -> new Tuple2(x, (Object)"x"), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class));
            this.testOperation(inputData1, inputData2, operation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("fullOuterJoin", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData1 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq inputData2 = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"b", ""})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"x"))), new Tuple2((Object)"b", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"x")))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Some((Object)"x"))), new Tuple2((Object)"a", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)None$.MODULE$)), new Tuple2((Object)"b", (Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"x")))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)None$.MODULE$))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"", (Object)new Tuple2((Object)None$.MODULE$, (Object)new Some((Object)"x")))}))}));
            Function2 & Serializable operation = (Function2 & Serializable)(s1, s2) -> DStream$.MODULE$.toPairDStreamFunctions(s1.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).fullOuterJoin(s2.map((Function1 & Serializable)x -> new Tuple2(x, (Object)"x"), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class));
            this.testOperation(inputData1, inputData2, operation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        this.test("updateStateByKey", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))}))}));
            Function1 & Serializable updateStateOperation = (Function1 & Serializable)s -> {
                Function2 & Serializable updateFunc = (Function2 & Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)))));
                return DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, (ClassTag)ClassTag$.MODULE$.Int());
            };
            this.testOperation(inputData, updateStateOperation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 406));
        this.test("updateStateByKey - simple with initial value RDD", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq initial = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))}));
            Seq inputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))}))}));
            Function1 & Serializable updateStateOperation = (Function1 & Serializable)s -> {
                SparkContext qual$1 = s.context().sparkContext();
                Seq x$1 = initial;
                int x$2 = qual$1.makeRDD$default$2();
                RDD initialRDD = qual$1.makeRDD(x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
                Function2 & Serializable updateFunc = (Function2 & Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)))));
                return DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, (Partitioner)new HashPartitioner(this.numInputPartitions()), initialRDD, (ClassTag)ClassTag$.MODULE$.Int());
            };
            this.testOperation(inputData, updateStateOperation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
        this.test("updateStateByKey - testing time stamps as input", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq initial = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)0L)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToLong((long)0L))}));
            Seq inputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)1000L)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToLong((long)0L))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)3000L)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToLong((long)2000L)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToLong((long)0L))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)6000L)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToLong((long)5000L)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToLong((long)3000L))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)10000L)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToLong((long)9000L)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToLong((long)3000L))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)15000L)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToLong((long)9000L)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToLong((long)3000L))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToLong((long)15000L)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToLong((long)9000L)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToLong((long)3000L))}))}));
            Function1 & Serializable updateStateOperation = (Function1 & Serializable)s -> {
                SparkContext qual$2 = s.context().sparkContext();
                Seq x$3 = initial;
                int x$4 = qual$2.makeRDD$default$2();
                RDD initialRDD = qual$2.makeRDD(x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class));
                Function4 & Serializable updateFunc = (Function4 & Serializable)(time, key, values, state) -> values.nonEmpty() ? Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(time.milliseconds() + BoxesRunTime.unboxToLong((Object)state.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))) : Option$.MODULE$.apply(state.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                return DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function4)updateFunc, (Partitioner)new HashPartitioner(this.numInputPartitions()), false, Option$.MODULE$.apply((Object)initialRDD), ClassTag$.MODULE$.apply(Long.TYPE));
            };
            this.testOperation(inputData, updateStateOperation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        this.test("updateStateByKey - with initial value RDD", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq initial = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))}));
            Seq inputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b", "c"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)3))}))}));
            Function1 & Serializable updateStateOperation = (Function1 & Serializable)s -> {
                SparkContext qual$3 = s.context().sparkContext();
                Seq x$5 = initial;
                int x$6 = qual$3.makeRDD$default$2();
                RDD initialRDD = qual$3.makeRDD(x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class));
                Function2 & Serializable updateFunc = (Function2 & Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)))));
                Function1 & Serializable newUpdateFunc = (Function1 & Serializable)iterator -> iterator.flatMap((Function1 & Serializable)t -> ((Option)updateFunc.apply(t._2(), t._3())).map((Function1 & Serializable)s -> BasicOperationsSuite.$anonfun$new$147(t, BoxesRunTime.unboxToInt((Object)s))));
                return DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function1)newUpdateFunc, (Partitioner)new HashPartitioner(this.numInputPartitions()), true, initialRDD, (ClassTag)ClassTag$.MODULE$.Int());
            };
            this.testOperation(inputData, updateStateOperation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 538));
        this.test("updateStateByKey - object lifecycle", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Seq inputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "b"})), null, (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a", "c", "a"})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"c"})), null, null}));
            Seq outputData = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"b", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)1))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"a", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"c", (Object)BoxesRunTime.boxToInteger((int)2))})), (Seq)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$)}));
            Function1 & Serializable updateStateOperation = (Function1 & Serializable)s -> {
                Function2 & Serializable updateFunc = (Function2 & Serializable)(values, state) -> {
                    None$ none$;
                    StateObject stateObj = (StateObject)state.getOrElse((Function0 & Serializable)() -> new StateObject(StateObject$.MODULE$.$lessinit$greater$default$1(), StateObject$.MODULE$.$lessinit$greater$default$2()));
                    int n = BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
                    switch (n) {
                        case 0: {
                            stateObj.expireCounter_$eq(stateObj.expireCounter() + 1);
                            break;
                        }
                        default: {
                            stateObj.counter_$eq(stateObj.counter() + n);
                            stateObj.expireCounter_$eq(0);
                            break;
                        }
                    }
                    int n2 = stateObj.expireCounter();
                    switch (n2) {
                        case 2: {
                            none$ = None$.MODULE$;
                            break;
                        }
                        default: {
                            none$ = Option$.MODULE$.apply((Object)stateObj);
                            break;
                        }
                    }
                    return none$;
                };
                return DStream$.MODULE$.toPairDStreamFunctions(DStream$.MODULE$.toPairDStreamFunctions(s.map((Function1 & Serializable)x -> new Tuple2(x, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).updateStateByKey((Function2)updateFunc, ClassTag$.MODULE$.apply(StateObject.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(StateObject.class), (Ordering)Ordering.String$.MODULE$).mapValues((Function1 & Serializable)x$34 -> BoxesRunTime.boxToInteger((int)x$34.counter()), (ClassTag)ClassTag$.MODULE$.Int());
            };
            this.testOperation(inputData, updateStateOperation, outputData, true, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 576));
        this.test("slice", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withStreamingContext(new StreamingContext(this.conf(), Seconds$.MODULE$.apply(1L)), (Function1 & Serializable)ssc -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}))}));
            TestInputStream stream = new TestInputStream((StreamingContext)ssc, input, 2, ClassTag$.MODULE$.Int());
            stream.foreachRDD((Function1 & Serializable)x$35 -> {
                BasicOperationsSuite.$anonfun$new$157(x$35);
                return BoxedUnit.UNIT;
            });
            ssc.start();
            Thread.sleep(2000L);
            Set $org_scalatest_assert_macro_left = BasicOperationsSuite.getInputFromSlice$1(0L, 1000L, stream);
            Set $org_scalatest_assert_macro_right = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1}));
            Set set = $org_scalatest_assert_macro_left;
            Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 629));
            Set $org_scalatest_assert_macro_left2 = BasicOperationsSuite.getInputFromSlice$1(0L, 2000L, stream);
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Set set3 = $org_scalatest_assert_macro_left2;
            Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 630));
            Set $org_scalatest_assert_macro_left3 = BasicOperationsSuite.getInputFromSlice$1(1000L, 2000L, stream);
            Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Set set5 = $org_scalatest_assert_macro_left3;
            Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 631));
            Set $org_scalatest_assert_macro_left4 = BasicOperationsSuite.getInputFromSlice$1(2000L, 4000L, stream);
            Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4}));
            Set set7 = $org_scalatest_assert_macro_left4;
            Set set8 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set7 != null ? !set7.equals(set8) : set8 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 632));
        }), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 618));
        this.test("slice - has not been initialized", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> (Assertion)this.withStreamingContext(new StreamingContext(this.conf(), Seconds$.MODULE$.apply(1L)), (Function1 & Serializable)ssc -> {
            Seq input = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4}))}));
            TestInputStream stream = new TestInputStream((StreamingContext)ssc, input, 2, ClassTag$.MODULE$.Int());
            SparkException thrown = (SparkException)((Object)((Object)((Object)this.intercept((Function0 & Serializable)() -> stream.slice(new Time(0L), new Time(1000L)), ClassTag$.MODULE$.apply(SparkException.class), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 639)))));
            String $org_scalatest_assert_macro_left = thrown.getMessage();
            String $org_scalatest_assert_macro_right = "has not been initialized";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        }), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 635));
        this.cleanupTestInput = (IndexedSeq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable)x -> BasicOperationsSuite.$anonfun$cleanupTestInput$1(BoxesRunTime.unboxToInt((Object)x))).toSeq();
        this.test("rdd cleanup - map and window", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Duration rememberDuration = Seconds$.MODULE$.apply(3L);
            return this.runCleanupTest(this.conf(), (Function1 & Serializable)s -> BasicOperationsSuite.operation$3(s), this.cleanupTestInput().size() / 2, Seconds$.MODULE$.apply(3L), (Function1 & Serializable)operatedStream -> {
                Eventually$.MODULE$.eventually(this.eventuallyTimeout(), (Function0 & Serializable)() -> {
                    WindowedDStream windowedStream2 = (WindowedDStream)operatedStream;
                    WindowedDStream windowedStream1 = (WindowedDStream)windowedStream2.dependencies().head();
                    DStream mappedStream = (DStream)windowedStream1.dependencies().head();
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(windowedStream2.rememberDuration());
                    Duration $org_scalatest_assert_macro_right = rememberDuration$1;
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = $this.convertToEqualizer(windowedStream1.rememberDuration());
                    Duration $org_scalatest_assert_macro_right2 = rememberDuration$1.$plus(windowedStream2.windowDuration());
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = $this.convertToEqualizer(mappedStream.rememberDuration());
                    Duration $org_scalatest_assert_macro_right3 = rememberDuration$1.$plus(windowedStream2.windowDuration()).$plus(windowedStream1.windowDuration());
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 670));
                    HashMap $org_scalatest_assert_macro_left4 = windowedStream2.generatedRDDs();
                    Time $org_scalatest_assert_macro_right4 = new Time(10000L);
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
                    HashMap $org_scalatest_assert_macro_left5 = windowedStream2.generatedRDDs();
                    Time $org_scalatest_assert_macro_right5 = new Time(8000L);
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
                    HashMap $org_scalatest_assert_macro_left6 = windowedStream2.generatedRDDs();
                    Time $org_scalatest_assert_macro_right6 = new Time(6000L);
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left6.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 680));
                    HashMap $org_scalatest_assert_macro_left7 = windowedStream1.generatedRDDs();
                    Time $org_scalatest_assert_macro_right7 = new Time(10000L);
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right7, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right7), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 683));
                    HashMap $org_scalatest_assert_macro_left8 = windowedStream1.generatedRDDs();
                    Time $org_scalatest_assert_macro_right8 = new Time(4000L);
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right8, $org_scalatest_assert_macro_left8.contains((Object)$org_scalatest_assert_macro_right8), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 684));
                    HashMap $org_scalatest_assert_macro_left9 = windowedStream1.generatedRDDs();
                    Time $org_scalatest_assert_macro_right9 = new Time(3000L);
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "contains", (Object)$org_scalatest_assert_macro_right9, $org_scalatest_assert_macro_left9.contains((Object)$org_scalatest_assert_macro_right9), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 685));
                    HashMap $org_scalatest_assert_macro_left10 = mappedStream.generatedRDDs();
                    Time $org_scalatest_assert_macro_right10 = new Time(10000L);
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left10, "contains", (Object)$org_scalatest_assert_macro_right10, $org_scalatest_assert_macro_left10.contains((Object)$org_scalatest_assert_macro_right10), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 688));
                    HashMap $org_scalatest_assert_macro_left11 = mappedStream.generatedRDDs();
                    Time $org_scalatest_assert_macro_right11 = new Time(2000L);
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "contains", (Object)$org_scalatest_assert_macro_right11, $org_scalatest_assert_macro_left11.contains((Object)$org_scalatest_assert_macro_right11), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 689));
                    HashMap $org_scalatest_assert_macro_left12 = mappedStream.generatedRDDs();
                    Time $org_scalatest_assert_macro_right12 = new Time(1000L);
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "contains", (Object)$org_scalatest_assert_macro_right12, $org_scalatest_assert_macro_left12.contains((Object)$org_scalatest_assert_macro_right12), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 661));
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        this.test("rdd cleanup - updateStateByKey", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Function2 & Serializable updateFunc = (Function2 & Serializable)(values, state) -> new Some((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)values.sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + BoxesRunTime.unboxToInt((Object)state.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)))));
            return this.runCleanupTest(this.conf(), (Function1 & Serializable)x$37 -> DStream$.MODULE$.toPairDStreamFunctions(x$37.map((Function1 & Serializable)x$38 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)x$38))), (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Int(), (ClassTag)ClassTag$.MODULE$.Int(), (Ordering)Ordering.Int$.MODULE$).updateStateByKey(updateFunc, (ClassTag)ClassTag$.MODULE$.Int()).checkpoint(Seconds$.MODULE$.apply(3L)), this.runCleanupTest$default$3(), this.runCleanupTest$default$4(), (Function1 & Serializable)stateStream -> {
                Eventually$.MODULE$.eventually(this.eventuallyTimeout(), (Function0 & Serializable)() -> {
                    TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(stateStream.rememberDuration());
                    Duration $org_scalatest_assert_macro_right = stateStream.checkpointDuration().$times(2);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 702));
                    HashMap $org_scalatest_assert_macro_left2 = stateStream.generatedRDDs();
                    Time $org_scalatest_assert_macro_right2 = new Time(10000L);
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 703));
                    HashMap $org_scalatest_assert_macro_left3 = stateStream.generatedRDDs();
                    Time $org_scalatest_assert_macro_right3 = new Time(4000L);
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
                }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 701));
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
        }, new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 695));
        this.test("rdd cleanup - input blocks and persisted RDDs", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.withTestServer(new TestServer(TestServer$.MODULE$.$lessinit$greater$default$1()), (Function1 & Serializable)testServer -> {
            this.withStreamingContext(new StreamingContext(this.conf(), this.batchDuration()), (Function1 & Serializable)ssc -> {
                BasicOperationsSuite.$anonfun$new$176($this, testServer, ssc);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("BasicOperationsSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 709));
        Statics.releaseFence();
    }
}

