/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.rdd;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD;
import org.apache.spark.streaming.rdd.WriteAheadLogBackedBlockRDD$;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogSegment;
import org.apache.spark.streaming.util.FileBasedWriteAheadLogWriter;
import org.apache.spark.streaming.util.WriteAheadLogRecordHandle;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\u0010 \u0001)BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013\u0005Q\b\u0003\u0004B\u0001\u0001\u0006IA\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019Y\u0005\u0001)A\u0005\t\"9A\n\u0001a\u0001\n\u0003i\u0005bB)\u0001\u0001\u0004%\tA\u0015\u0005\u00077\u0002\u0001\u000b\u0015\u0002(\t\u000fq\u0003\u0001\u0019!C\u0001;\"9A\r\u0001a\u0001\n\u0003)\u0007BB4\u0001A\u0003&a\fC\u0004i\u0001\u0001\u0007I\u0011A5\t\u000fA\u0004\u0001\u0019!C\u0001c\"11\u000f\u0001Q!\n)Dq\u0001\u001e\u0001A\u0002\u0013\u0005Q\u000fC\u0004\u007f\u0001\u0001\u0007I\u0011A@\t\u000f\u0005\r\u0001\u0001)Q\u0005m\"9\u0011Q\u0001\u0001\u0005B\u0005\u001d\u0001bBA\u0005\u0001\u0011\u0005\u0013q\u0001\u0005\b\u0003\u0017\u0001A\u0011IA\u0004\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001fA\u0011\"a\u0007\u0001#\u0003%I!!\b\t\u000f\u0005M\u0002\u0001\"\u0003\u0002\b!9\u0011Q\u0007\u0001\u0005\n\u0005]\u0002\"CA/\u0001E\u0005I\u0011BA0\u0011%\t\u0019\u0007AI\u0001\n\u0013\ty\u0006C\u0005\u0002f\u0001\t\n\u0011\"\u0003\u0002`!9\u0011q\r\u0001\u0005\n\u0005%\u0004bBAZ\u0001\u0011%\u0011Q\u0017\u0002!/JLG/Z!iK\u0006$Gj\\4CC\u000e\\W\r\u001a\"m_\u000e\\'\u000b\u0012#Tk&$XM\u0003\u0002!C\u0005\u0019!\u000f\u001a3\u000b\u0005\t\u001a\u0013!C:ue\u0016\fW.\u001b8h\u0015\t!S%A\u0003ta\u0006\u00148N\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7\u0001A\n\u0005\u0001-zS\u0007\u0005\u0002-[5\t1%\u0003\u0002/G\ti1\u000b]1sW\u001a+hnU;ji\u0016\u0004\"\u0001M\u001a\u000e\u0003ER!AM\u0014\u0002\u0013M\u001c\u0017\r\\1uKN$\u0018B\u0001\u001b2\u0005E\u0011UMZ8sK\u0006sG-\u00114uKJ\fE\u000e\u001c\t\u0003aYJ!aN\u0019\u0003%\t+gm\u001c:f\u0003:$\u0017I\u001a;fe\u0016\u000b7\r[\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0002\"a\u000f\u0001\u000e\u0003}\tAaY8oMV\ta\b\u0005\u0002-\u007f%\u0011\u0001i\t\u0002\n'B\f'o[\"p]\u001a\fQaY8oM\u0002\n!\u0002[1e_>\u00048i\u001c8g+\u0005!\u0005CA#J\u001b\u00051%B\u0001\u001fH\u0015\tAU%\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0015\u001a\u0013QbQ8oM&<WO]1uS>t\u0017a\u00035bI>|\u0007oQ8oM\u0002\nAb\u001d9be.\u001cuN\u001c;fqR,\u0012A\u0014\t\u0003Y=K!\u0001U\u0012\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\u0002!M\u0004\u0018M]6D_:$X\r\u001f;`I\u0015\fHCA*Z!\t!v+D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005\u0011)f.\u001b;\t\u000fi;\u0011\u0011!a\u0001\u001d\u0006\u0019\u0001\u0010J\u0019\u0002\u001bM\u0004\u0018M]6D_:$X\r\u001f;!\u00031\u0011Gn\\2l\u001b\u0006t\u0017mZ3s+\u0005q\u0006CA0c\u001b\u0005\u0001'BA1$\u0003\u001d\u0019Ho\u001c:bO\u0016L!a\u00191\u0003\u0019\tcwnY6NC:\fw-\u001a:\u0002!\tdwnY6NC:\fw-\u001a:`I\u0015\fHCA*g\u0011\u001dQ&\"!AA\u0002y\u000bQB\u00197pG.l\u0015M\\1hKJ\u0004\u0013!E:fe&\fG.\u001b>fe6\u000bg.Y4feV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002nG\u0005Q1/\u001a:jC2L'0\u001a:\n\u0005=d'!E*fe&\fG.\u001b>fe6\u000bg.Y4fe\u0006)2/\u001a:jC2L'0\u001a:NC:\fw-\u001a:`I\u0015\fHCA*s\u0011\u001dQV\"!AA\u0002)\f!c]3sS\u0006d\u0017N_3s\u001b\u0006t\u0017mZ3sA\u0005\u0019A-\u001b:\u0016\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0005%|'\"A>\u0002\t)\fg/Y\u0005\u0003{b\u0014AAR5mK\u00069A-\u001b:`I\u0015\fHcA*\u0002\u0002!9!\fEA\u0001\u0002\u00041\u0018\u0001\u00023je\u0002\n!BY3g_J,W)Y2i)\u0005\u0019\u0016!C1gi\u0016\u0014X)Y2i\u0003!\tg\r^3s\u00032d\u0017\u0001E5oSR\u001c\u0006/\u0019:l\u0007>tG/\u001a=u)\r\u0019\u0016\u0011\u0003\u0005\n\u0003')\u0002\u0013!a\u0001\u0003+\tQaX2p]\u001a\u0004B\u0001VA\f}%\u0019\u0011\u0011D+\u0003\r=\u0003H/[8o\u0003iIg.\u001b;Ta\u0006\u00148nQ8oi\u0016DH\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tyB\u000b\u0003\u0002\u0016\u0005\u00052FAA\u0012!\u0011\t)#a\f\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055R+\u0001\u0006b]:|G/\u0019;j_:LA!!\r\u0002(\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!M$x\u000e]*qCJ\\7i\u001c8uKb$\u0018a\u0002;fgR\u0014F\t\u0012\u000b\u000e'\u0006e\u00121IA$\u0003\u0017\n)&!\u0017\t\u000f\u0005m\u0002\u00041\u0001\u0002>\u0005ia.^7QCJ$\u0018\u000e^5p]N\u00042\u0001VA \u0013\r\t\t%\u0016\u0002\u0004\u0013:$\bbBA#1\u0001\u0007\u0011QH\u0001\u0012]Vl\u0007+\u0019:uSRLwN\\:J]\nk\u0005bBA%1\u0001\u0007\u0011QH\u0001\u0013]Vl\u0007+\u0019:uSRLwN\\:J]^\u000bE\nC\u0005\u0002Na\u0001\n\u00111\u0001\u0002P\u0005\u0001B/Z:u\u0013N\u0014En\\2l-\u0006d\u0017\u000e\u001a\t\u0004)\u0006E\u0013bAA*+\n9!i\\8mK\u0006t\u0007\"CA,1A\u0005\t\u0019AA(\u0003=!Xm\u001d;CY>\u001c7NU3n_Z,\u0007\"CA.1A\u0005\t\u0019AA(\u00035!Xm\u001d;Ti>\u0014X-\u00138C\u001b\u0006\tB/Z:u%\u0012#E\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0005$\u0006BA(\u0003C\t\u0011\u0003^3tiJ#E\t\n3fM\u0006,H\u000e\u001e\u00136\u0003E!Xm\u001d;S\t\u0012#C-\u001a4bk2$HEN\u0001\u0019O\u0016tWM]1uK^\u000bEJU3d_J$\u0007*\u00198eY\u0016\u001cHCBA6\u0003\u001f\u000b9\u000b\u0005\u0004\u0002n\u0005u\u00141\u0011\b\u0005\u0003_\nIH\u0004\u0003\u0002r\u0005]TBAA:\u0015\r\t)(K\u0001\u0007yI|w\u000e\u001e \n\u0003YK1!a\u001fV\u0003\u001d\u0001\u0018mY6bO\u0016LA!a \u0002\u0002\n\u00191+Z9\u000b\u0007\u0005mT\u000b\u0005\u0003\u0002\u0006\u0006-UBAAD\u0015\r\tI)I\u0001\u0005kRLG.\u0003\u0003\u0002\u000e\u0006\u001d%!\b$jY\u0016\u0014\u0015m]3e/JLG/Z!iK\u0006$Gj\\4TK\u001elWM\u001c;\t\u000f\u0005EE\u00041\u0001\u0002\u0014\u0006I!\r\\8dW\u0012\u000bG/\u0019\t\u0007\u0003[\ni(!&\u0011\r\u00055\u0014QPAL!\u0011\tI*!)\u000f\t\u0005m\u0015Q\u0014\t\u0004\u0003c*\u0016bAAP+\u00061\u0001K]3eK\u001aLA!a)\u0002&\n11\u000b\u001e:j]\u001eT1!a(V\u0011\u001d\tI\u000b\ba\u0001\u0003W\u000b\u0001B\u00197pG.LEm\u001d\t\u0007\u0003[\ni(!,\u0011\u0007}\u000by+C\u0002\u00022\u0002\u0014qA\u00117pG.LE-A\rhK:,'/\u0019;f\r\u0006\\WMU3d_J$\u0007*\u00198eY\u0016\u001cH\u0003BA6\u0003oCq!!/\u001e\u0001\u0004\ti$A\u0003d_VtG\u000f")
public class WriteAheadLogBackedBlockRDDSuite
extends SparkFunSuite {
    private final SparkConf conf = new SparkConf().setMaster("local[2]").setAppName(this.getClass().getSimpleName());
    private final Configuration hadoopConf = new Configuration();
    private SparkContext sparkContext = null;
    private BlockManager blockManager = null;
    private SerializerManager serializerManager = null;
    private File dir = null;

    public SparkConf conf() {
        return this.conf;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public SparkContext sparkContext() {
        return this.sparkContext;
    }

    public void sparkContext_$eq(SparkContext x$1) {
        this.sparkContext = x$1;
    }

    public BlockManager blockManager() {
        return this.blockManager;
    }

    public void blockManager_$eq(BlockManager x$1) {
        this.blockManager = x$1;
    }

    public SerializerManager serializerManager() {
        return this.serializerManager;
    }

    public void serializerManager_$eq(SerializerManager x$1) {
        this.serializerManager = x$1;
    }

    public File dir() {
        return this.dir;
    }

    public void dir_$eq(File x$1) {
        this.dir = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        this.initSparkContext(this.initSparkContext$default$1());
        this.dir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()));
    }

    public void afterEach() {
        try {
            Utils$.MODULE$.deleteRecursively(this.dir());
        }
        finally {
            BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
        }
    }

    public void afterAll() {
        try {
            this.stopSparkContext();
        }
        finally {
            super.afterAll();
        }
    }

    private void initSparkContext(Option<SparkConf> _conf) {
        block0: {
            if (this.sparkContext() != null) break block0;
            this.sparkContext_$eq(new SparkContext((SparkConf)_conf.getOrElse((Function0 & Serializable)() -> this.conf())));
            this.blockManager_$eq(this.sparkContext().env().blockManager());
            this.serializerManager_$eq(this.sparkContext().env().serializerManager());
        }
    }

    private Option<SparkConf> initSparkContext$default$1() {
        return None$.MODULE$;
    }

    private void stopSparkContext() {
        try {
            if (this.sparkContext() != null) {
                this.sparkContext().stop();
            }
            System.clearProperty("spark.driver.port");
            this.blockManager_$eq(null);
            this.serializerManager_$eq(null);
        }
        finally {
            this.sparkContext_$eq(null);
        }
    }

    private void testRDD(int numPartitions, int numPartitionsInBM, int numPartitionsInWAL, boolean testIsBlockValid, boolean testBlockRemove, boolean testStoreInBM) {
        block4: {
            BoxedUnit boxedUnit;
            Object object;
            Predef$.MODULE$.require(numPartitionsInBM <= numPartitions, (Function0 & Serializable)() -> "Can't put more partitions in BlockManager than that in RDD");
            Predef$.MODULE$.require(numPartitionsInWAL <= numPartitions, (Function0 & Serializable)() -> "Can't put more partitions in write ahead log than that in RDD");
            Seq data = (Seq)package$.MODULE$.Seq().fill(numPartitions, 10, (Function0 & Serializable)() -> Random$.MODULE$.nextString(50));
            StreamBlockId[] blockIds = (StreamBlockId[])Array$.MODULE$.fill(numPartitions, (Function0 & Serializable)() -> new StreamBlockId(Random$.MODULE$.nextInt(), (long)Random$.MODULE$.nextInt()), ClassTag$.MODULE$.apply(StreamBlockId.class));
            ((IterableOnceOps)((IterableOps)data.zip((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])blockIds))).take(numPartitionsInBM)).foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$5(this, x0$1)));
            Seq recordHandles = (Seq)this.generateFakeRecordHandles(numPartitions - numPartitionsInWAL).$plus$plus(this.generateWALRecordHandles((Seq<Seq<String>>)((Seq)data.takeRight(numPartitionsInWAL)), (Seq<BlockId>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), numPartitionsInWAL))));
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), numPartitionsInBM)), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$6(this, x$1))), (Function0 & Serializable)() -> "Expected blocks not in BlockManager");
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.takeRight$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), numPartitions - numPartitionsInBM)), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$8(this, x$2))), (Function0 & Serializable)() -> "Unexpected blocks in BlockManager");
            Predef$.MODULE$.require(((IterableOnceOps)recordHandles.takeRight(numPartitionsInWAL)).forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$10(s))), (Function0 & Serializable)() -> "Expected blocks not in write ahead log");
            Predef$.MODULE$.require(((IterableOnceOps)recordHandles.take(numPartitions - numPartitionsInWAL)).forall((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$12(s))), (Function0 & Serializable)() -> "Unexpected blocks in write ahead log");
            SparkContext x$5 = this.sparkContext();
            BlockId[] x$6 = (BlockId[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), ClassTag$.MODULE$.apply(BlockId.class));
            WriteAheadLogRecordHandle[] x$7 = (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
            boolean x$8 = false;
            boolean[] x$9 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$4();
            StorageLevel x$10 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6();
            WriteAheadLogBackedBlockRDD rdd = new WriteAheadLogBackedBlockRDD(x$5, x$6, x$7, x$9, false, x$10, ClassTag$.MODULE$.apply(String.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(rdd.collect());
            Seq $org_scalatest_assert_macro_right = (Seq)data.flatten(Predef$.MODULE$.$conforms());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            if (testIsBlockValid) {
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInBM)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitions), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "All partitions must be in BlockManager");
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitionsInWAL)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)0), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "No partitions must be in WAL");
                WriteAheadLogBackedBlockRDD rdd2 = new WriteAheadLogBackedBlockRDD(this.sparkContext(), (BlockId[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), ClassTag$.MODULE$.apply(BlockId.class)), (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class)), (boolean[])Array$.MODULE$.fill(blockIds.length, (Function0)(JFunction0.mcZ.sp & Serializable)() -> false, (ClassTag)ClassTag$.MODULE$.Boolean()), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$5(), WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$6(), ClassTag$.MODULE$.apply(String.class));
                object = this.intercept((Function0 & Serializable)() -> (String[])rdd2.collect(), ClassTag$.MODULE$.apply(SparkException.class), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
            } else {
                object = BoxedUnit.UNIT;
            }
            if (testBlockRemove) {
                Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)numPartitions)).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)numPartitionsInWAL), Equality$.MODULE$.default()), (Function0 & Serializable)() -> "All partitions must be in WAL for this test");
                Predef$.MODULE$.require(numPartitionsInBM > 0, (Function0 & Serializable)() -> "Some partitions must be in BlockManager for this test");
                rdd.removeBlocks();
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(rdd.collect());
                Seq $org_scalatest_assert_macro_right2 = (Seq)data.flatten(Predef$.MODULE$.$conforms());
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!testStoreInBM) break block4;
            SparkContext x$11 = this.sparkContext();
            BlockId[] x$12 = (BlockId[])ArrayOps$.MODULE$.toArray$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), ClassTag$.MODULE$.apply(BlockId.class));
            WriteAheadLogRecordHandle[] x$13 = (WriteAheadLogRecordHandle[])recordHandles.toArray(ClassTag$.MODULE$.apply(WriteAheadLogRecordHandle.class));
            boolean x$14 = true;
            StorageLevel x$15 = StorageLevel$.MODULE$.MEMORY_ONLY();
            boolean[] x$16 = WriteAheadLogBackedBlockRDD$.MODULE$.$lessinit$greater$default$4();
            WriteAheadLogBackedBlockRDD rdd2 = new WriteAheadLogBackedBlockRDD(x$11, x$12, x$13, x$16, true, x$15, ClassTag$.MODULE$.apply(String.class));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(rdd2.collect());
            Seq $org_scalatest_assert_macro_right3 = (Seq)data.flatten(Predef$.MODULE$.$conforms());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])blockIds), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)WriteAheadLogBackedBlockRDDSuite.$anonfun$testRDD$20(this, x$3))), "scala.Predef.refArrayOps[org.apache.spark.storage.StreamBlockId](blockIds).forall(((x$3: org.apache.spark.storage.StreamBlockId) => WriteAheadLogBackedBlockRDDSuite.this.blockManager.get[Nothing](x$3)((ClassTag.Nothing: scala.reflect.ClassTag[Nothing])).nonEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"All blocks not found in block manager", Prettifier$.MODULE$.default(), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 239));
        }
    }

    private boolean testRDD$default$4() {
        return false;
    }

    private boolean testRDD$default$5() {
        return false;
    }

    private boolean testRDD$default$6() {
        return false;
    }

    private Seq<FileBasedWriteAheadLogSegment> generateWALRecordHandles(Seq<Seq<String>> blockData, Seq<BlockId> blockIds) {
        Predef$.MODULE$.require(this.convertToEqualizer(BoxesRunTime.boxToInteger((int)blockData.size())).$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)blockIds.size()), Equality$.MODULE$.default()));
        FileBasedWriteAheadLogWriter writer = new FileBasedWriteAheadLogWriter(new File(this.dir(), "logFile").toString(), this.hadoopConf());
        Seq segments = (Seq)((IterableOps)blockData.zip(blockIds)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq data = (Seq)tuple2._1();
            BlockId id = (BlockId)tuple2._2();
            FileBasedWriteAheadLogSegment fileBasedWriteAheadLogSegment = writer.write(this.serializerManager().dataSerialize(id, data.iterator(), ClassTag$.MODULE$.apply(String.class)).toByteBuffer());
            return fileBasedWriteAheadLogSegment;
        });
        writer.close();
        return segments;
    }

    private Seq<FileBasedWriteAheadLogSegment> generateFakeRecordHandles(int count) {
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(Array$.MODULE$.fill(count, (Function0 & Serializable)() -> new FileBasedWriteAheadLogSegment("random", 0L, 0), ClassTag$.MODULE$.apply(FileBasedWriteAheadLogSegment.class)));
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$5(WriteAheadLogBackedBlockRDDSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq block = (Seq)tuple2._1();
        StreamBlockId blockId = (StreamBlockId)tuple2._2();
        BlockManager qual$1 = $this.blockManager();
        StreamBlockId x$1 = blockId;
        Iterator x$2 = block.iterator();
        StorageLevel x$3 = StorageLevel$.MODULE$.MEMORY_ONLY_SER();
        boolean x$4 = qual$1.putIterator$default$4();
        boolean bl = qual$1.putIterator((BlockId)x$1, x$2, x$3, x$4, ClassTag$.MODULE$.apply(String.class));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$6(WriteAheadLogBackedBlockRDDSuite $this, StreamBlockId x$1) {
        return $this.blockManager().get((BlockId)x$1, ClassTag$.MODULE$.Nothing()).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$8(WriteAheadLogBackedBlockRDDSuite $this, StreamBlockId x$2) {
        return $this.blockManager().get((BlockId)x$2, ClassTag$.MODULE$.Nothing()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$10(FileBasedWriteAheadLogSegment s) {
        return new File(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s.path()), "file://")).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$12(FileBasedWriteAheadLogSegment s) {
        return !new File(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s.path()), "file://")).exists();
    }

    public static final /* synthetic */ boolean $anonfun$testRDD$20(WriteAheadLogBackedBlockRDDSuite $this, StreamBlockId x$3) {
        return $this.blockManager().get((BlockId)x$3, ClassTag$.MODULE$.Nothing()).nonEmpty();
    }

    public WriteAheadLogBackedBlockRDDSuite() {
        this.test("Read data available in both block manager and write ahead log", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 5, 5, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        this.test("Read data available only in block manager, not in write ahead log", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 5, 0, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("Read data available only in write ahead log, not in block manager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 0, 5, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("Read data with partially available in block manager, and rest in write ahead log", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 3, 2, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103));
        this.test("Test isBlockValid skips block fetching from BlockManager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> this.testRDD(5, 5, 0, true, this.testRDD$default$5(), this.testRDD$default$6()), new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("Test whether RDD is valid after removing blocks from block manager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$1 = 5;
            int x$2 = 5;
            int x$3 = 5;
            boolean x$4 = true;
            boolean x$5 = this.testRDD$default$4();
            boolean x$6 = this.testRDD$default$6();
            this.testRDD(5, 5, 5, x$5, true, x$6);
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("Test storing of blocks recovered from write ahead log back into block manager", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$7 = 5;
            boolean x$8 = false;
            int x$9 = 5;
            boolean x$10 = true;
            boolean x$11 = this.testRDD$default$4();
            boolean x$12 = this.testRDD$default$5();
            this.testRDD(5, 0, 5, x$11, x$12, true);
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
        this.test("read data in block manager and WAL with encryption on", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            this.stopSparkContext();
            try {
                SparkConf testConf = this.conf().clone().set(org.apache.spark.internal.config.package$.MODULE$.IO_ENCRYPTION_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                this.initSparkContext((Option<SparkConf>)new Some((Object)testConf));
                this.testRDD(5, 3, 2, this.testRDD$default$4(), this.testRDD$default$5(), this.testRDD$default$6());
                boxedUnit = BoxedUnit.UNIT;
            }
            finally {
                this.stopSparkContext();
            }
            return boxedUnit;
        }, new Position("WriteAheadLogBackedBlockRDDSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
    }
}

