/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.LocalStreamingContext;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.scheduler.InputInfoTracker;
import org.apache.spark.streaming.scheduler.StreamInputInfo;
import org.apache.spark.streaming.scheduler.StreamInputInfo$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import scala.Function0;
import scala.None$;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u00112Aa\u0001\u0003\u0001\u001f!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C!;\t)\u0012J\u001c9vi&sgm\u001c+sC\u000e\\WM]*vSR,'BA\u0003\u0007\u0003%\u00198\r[3ek2,'O\u0003\u0002\b\u0011\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011c\u0001\u0001\u0011)A\u0011\u0011CE\u0007\u0002\u0011%\u00111\u0003\u0003\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005U1R\"\u0001\u0004\n\u0005]1!!\u0006'pG\u0006d7\u000b\u001e:fC6LgnZ\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"a\u0007\u0001\u000e\u0003\u0011\t!BY3g_J,W)Y2i)\u0005q\u0002CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#\u0001B+oSR\u0004")
public class InputInfoTrackerSuite
extends SparkFunSuite
implements LocalStreamingContext {
    private transient StreamingContext ssc;
    private transient boolean stopSparkContext;

    @Override
    public /* synthetic */ void org$apache$spark$streaming$LocalStreamingContext$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    @Override
    public void afterEach() {
        LocalStreamingContext.afterEach$(this);
    }

    @Override
    public void resetStreamingContext() {
        LocalStreamingContext.resetStreamingContext$(this);
    }

    @Override
    public StreamingContext ssc() {
        return this.ssc;
    }

    @Override
    public void ssc_$eq(StreamingContext x$1) {
        this.ssc = x$1;
    }

    @Override
    public boolean stopSparkContext() {
        return this.stopSparkContext;
    }

    @Override
    public void org$apache$spark$streaming$LocalStreamingContext$_setter_$stopSparkContext_$eq(boolean x$1) {
        this.stopSparkContext = x$1;
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
        SparkConf conf = new SparkConf().setMaster("local[2]").setAppName("DirectStreamTacker");
        this.ssc_$eq(new StreamingContext(conf, new Duration(1000L)));
    }

    public InputInfoTrackerSuite() {
        LocalStreamingContext.$init$(this);
        this.test("test report and get InputInfo from InputInfoTracker", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Map batchTimeToInputInfos;
            InputInfoTracker inputInfoTracker = new InputInfoTracker(this.ssc());
            int streamId1 = 0;
            int streamId2 = 1;
            Time time = new Time(0L);
            StreamInputInfo inputInfo1 = new StreamInputInfo(streamId1, 100L, StreamInputInfo$.MODULE$.apply$default$3());
            StreamInputInfo inputInfo2 = new StreamInputInfo(streamId2, 300L, StreamInputInfo$.MODULE$.apply$default$3());
            inputInfoTracker.reportInfo(time, inputInfo1);
            inputInfoTracker.reportInfo(time, inputInfo2);
            Map $org_scalatest_assert_macro_left = batchTimeToInputInfos = inputInfoTracker.getInfo(time);
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(batchTimeToInputInfos.keys());
            Set $org_scalatest_assert_macro_right2 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{streamId1, streamId2}));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(batchTimeToInputInfos.apply((Object)BoxesRunTime.boxToInteger((int)streamId1)));
            StreamInputInfo $org_scalatest_assert_macro_right3 = inputInfo1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(batchTimeToInputInfos.apply((Object)BoxesRunTime.boxToInteger((int)streamId2)));
            StreamInputInfo $org_scalatest_assert_macro_right4 = inputInfo2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(inputInfoTracker.getInfo(time).apply((Object)BoxesRunTime.boxToInteger((int)streamId1)));
            StreamInputInfo $org_scalatest_assert_macro_right5 = inputInfo1;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
        }, new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("test cleanup InputInfo from InputInfoTracker", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            InputInfoTracker inputInfoTracker = new InputInfoTracker(this.ssc());
            int streamId1 = 0;
            StreamInputInfo inputInfo1 = new StreamInputInfo(streamId1, 100L, StreamInputInfo$.MODULE$.apply$default$3());
            StreamInputInfo inputInfo2 = new StreamInputInfo(streamId1, 300L, StreamInputInfo$.MODULE$.apply$default$3());
            inputInfoTracker.reportInfo(new Time(0L), inputInfo1);
            inputInfoTracker.reportInfo(new Time(1L), inputInfo2);
            inputInfoTracker.cleanup(new Time(0L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(inputInfoTracker.getInfo(new Time(0L)).apply((Object)BoxesRunTime.boxToInteger((int)streamId1)));
            StreamInputInfo $org_scalatest_assert_macro_right = inputInfo1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(inputInfoTracker.getInfo(new Time(1L)).apply((Object)BoxesRunTime.boxToInteger((int)streamId1)));
            StreamInputInfo $org_scalatest_assert_macro_right2 = inputInfo2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
            inputInfoTracker.cleanup(new Time(1L));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(inputInfoTracker.getInfo(new Time(0L)).get((Object)BoxesRunTime.boxToInteger((int)streamId1)));
            None$ $org_scalatest_assert_macro_right3 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(inputInfoTracker.getInfo(new Time(1L)).apply((Object)BoxesRunTime.boxToInteger((int)streamId1)));
            StreamInputInfo $org_scalatest_assert_macro_right4 = inputInfo2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        }, new Position("InputInfoTrackerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 50));
        Statics.releaseFence();
    }
}

