/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.bitset;

import junit.framework.Assert;
import org.apache.spark.unsafe.bitset.BitSet;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.junit.Test;

public class BitSetSuite {
    private static BitSet createBitSet(int capacity) {
        assert (capacity % 64 == 0);
        return new BitSet(MemoryBlock.fromLongArray((long[])new long[capacity / 64]));
    }

    @Test
    public void basicOps() {
        BitSet bs = BitSetSuite.createBitSet(64);
        Assert.assertEquals((long)64L, (long)bs.capacity());
        int i = 0;
        while ((long)i < bs.capacity()) {
            Assert.assertFalse((boolean)bs.isSet(i));
            ++i;
        }
        Assert.assertFalse((boolean)bs.anySet());
        i = 0;
        while ((long)i < bs.capacity()) {
            bs.set(i);
            Assert.assertTrue((boolean)bs.isSet(i));
            ++i;
        }
        i = 0;
        while ((long)i < bs.capacity()) {
            Assert.assertTrue((boolean)bs.isSet(i));
            bs.unset(i);
            Assert.assertFalse((boolean)bs.isSet(i));
            ++i;
        }
        bs = BitSetSuite.createBitSet(256);
        bs.set(64);
        Assert.assertTrue((boolean)bs.anySet());
    }

    @Test
    public void traversal() {
        BitSet bs = BitSetSuite.createBitSet(256);
        Assert.assertEquals((int)-1, (int)bs.nextSetBit(0));
        Assert.assertEquals((int)-1, (int)bs.nextSetBit(10));
        Assert.assertEquals((int)-1, (int)bs.nextSetBit(64));
        bs.set(10);
        Assert.assertEquals((int)10, (int)bs.nextSetBit(0));
        Assert.assertEquals((int)10, (int)bs.nextSetBit(1));
        Assert.assertEquals((int)10, (int)bs.nextSetBit(10));
        Assert.assertEquals((int)-1, (int)bs.nextSetBit(11));
        bs.set(11);
        Assert.assertEquals((int)10, (int)bs.nextSetBit(10));
        Assert.assertEquals((int)11, (int)bs.nextSetBit(11));
        bs.set(190);
        Assert.assertEquals((int)190, (int)bs.nextSetBit(12));
        Assert.assertEquals((int)-1, (int)bs.nextSetBit(191));
        Assert.assertEquals((int)-1, (int)bs.nextSetBit(256));
    }
}

