/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.hash;

import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Random;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.junit.Assert;
import org.junit.Test;

public class Murmur3_x86_32Suite {
    private static final Murmur3_x86_32 hasher = new Murmur3_x86_32(0);

    @Test
    public void testKnownIntegerInputs() {
        Assert.assertEquals((long)593689054L, (long)hasher.hashInt(0));
        Assert.assertEquals((long)-189366624L, (long)hasher.hashInt(-42));
        Assert.assertEquals((long)-1134849565L, (long)hasher.hashInt(42));
        Assert.assertEquals((long)-1718298732L, (long)hasher.hashInt(Integer.MIN_VALUE));
        Assert.assertEquals((long)-1653689534L, (long)hasher.hashInt(Integer.MAX_VALUE));
    }

    @Test
    public void testKnownLongInputs() {
        Assert.assertEquals((long)1669671676L, (long)hasher.hashLong(0L));
        Assert.assertEquals((long)-846261623L, (long)hasher.hashLong(-42L));
        Assert.assertEquals((long)1871679806L, (long)hasher.hashLong(42L));
        Assert.assertEquals((long)1366273829L, (long)hasher.hashLong(Long.MIN_VALUE));
        Assert.assertEquals((long)-2106506049L, (long)hasher.hashLong(Long.MAX_VALUE));
    }

    @Test
    public void randomizedStressTest() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int vint = rand.nextInt();
            long lint = rand.nextLong();
            Assert.assertEquals((long)hasher.hashInt(vint), (long)hasher.hashInt(vint));
            Assert.assertEquals((long)hasher.hashLong(lint), (long)hasher.hashLong(lint));
            hashcodes.add(hasher.hashLong(lint));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestBytes() {
        int size = 65536;
        Random rand = new Random();
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = rand.nextInt(100) * 8;
            byte[] bytes = new byte[byteArrSize];
            rand.nextBytes(bytes);
            Assert.assertEquals((long)hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize), (long)hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
            hashcodes.add(hasher.hashUnsafeWords((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }

    @Test
    public void randomizedStressTestPaddedStrings() {
        int size = 64000;
        HashSet<Integer> hashcodes = new HashSet<Integer>();
        for (int i = 0; i < size; ++i) {
            int byteArrSize = 8;
            byte[] strBytes = String.valueOf(i).getBytes(StandardCharsets.UTF_8);
            byte[] paddedBytes = new byte[byteArrSize];
            System.arraycopy(strBytes, 0, paddedBytes, 0, strBytes.length);
            Assert.assertEquals((long)hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize), (long)hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
            hashcodes.add(hasher.hashUnsafeWords((Object)paddedBytes, (long)Platform.BYTE_ARRAY_OFFSET, byteArrSize));
        }
        Assert.assertTrue(((double)hashcodes.size() > (double)size * 0.95 ? 1 : 0) != 0);
    }
}

