/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.array;

import org.apache.spark.unsafe.Platform;

public class ByteArrayMethods {
    public static int MAX_ROUNDED_ARRAY_LENGTH = 0x7FFFFFF0;
    private static final boolean unaligned = Platform.unaligned();

    private ByteArrayMethods() {
    }

    public static long nextPowerOf2(long num) {
        long highBit = Long.highestOneBit(num);
        return highBit == num ? num : highBit << 1;
    }

    public static int roundNumberOfBytesToNearestWord(int numBytes) {
        int remainder = numBytes & 7;
        if (remainder == 0) {
            return numBytes;
        }
        return numBytes + (8 - remainder);
    }

    public static boolean arrayEquals(Object leftBase, long leftOffset, Object rightBase, long rightOffset, long length) {
        int i = 0;
        if (leftOffset % 8L == rightOffset % 8L) {
            while ((leftOffset + (long)i) % 8L != 0L && (long)i < length) {
                if (Platform.getByte(leftBase, leftOffset + (long)i) != Platform.getByte(rightBase, rightOffset + (long)i)) {
                    return false;
                }
                ++i;
            }
        }
        if (unaligned || (leftOffset + (long)i) % 8L == 0L && (rightOffset + (long)i) % 8L == 0L) {
            while ((long)i <= length - 8L) {
                if (Platform.getLong(leftBase, leftOffset + (long)i) != Platform.getLong(rightBase, rightOffset + (long)i)) {
                    return false;
                }
                i += 8;
            }
        }
        while ((long)i < length) {
            if (Platform.getByte(leftBase, leftOffset + (long)i) != Platform.getByte(rightBase, rightOffset + (long)i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

