/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import java.time.Duration;
import java.time.Period;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.junit.Assert;
import org.junit.Test;

public class CalendarIntervalSuite {
    @Test
    public void equalsTest() {
        CalendarInterval i1 = new CalendarInterval(3, 2, 123L);
        CalendarInterval i2 = new CalendarInterval(3, 2, 321L);
        CalendarInterval i3 = new CalendarInterval(3, 4, 123L);
        CalendarInterval i4 = new CalendarInterval(1, 2, 123L);
        CalendarInterval i5 = new CalendarInterval(1, 4, 321L);
        CalendarInterval i6 = new CalendarInterval(3, 2, 123L);
        Assert.assertNotSame((Object)i1, (Object)i2);
        Assert.assertNotSame((Object)i1, (Object)i3);
        Assert.assertNotSame((Object)i1, (Object)i4);
        Assert.assertNotSame((Object)i2, (Object)i3);
        Assert.assertNotSame((Object)i2, (Object)i4);
        Assert.assertNotSame((Object)i3, (Object)i4);
        Assert.assertNotSame((Object)i1, (Object)i5);
        Assert.assertEquals((Object)i1, (Object)i6);
    }

    @Test
    public void toStringTest() {
        CalendarInterval i = new CalendarInterval(0, 0, 0L);
        Assert.assertEquals((Object)"0 seconds", (Object)i.toString());
        i = new CalendarInterval(34, 0, 0L);
        Assert.assertEquals((Object)"2 years 10 months", (Object)i.toString());
        i = new CalendarInterval(-34, 0, 0L);
        Assert.assertEquals((Object)"-2 years -10 months", (Object)i.toString());
        i = new CalendarInterval(0, 31, 0L);
        Assert.assertEquals((Object)"31 days", (Object)i.toString());
        i = new CalendarInterval(0, -31, 0L);
        Assert.assertEquals((Object)"-31 days", (Object)i.toString());
        i = new CalendarInterval(0, 0, 11580000123L);
        Assert.assertEquals((Object)"3 hours 13 minutes 0.000123 seconds", (Object)i.toString());
        i = new CalendarInterval(0, 0, -11580000123L);
        Assert.assertEquals((Object)"-3 hours -13 minutes -0.000123 seconds", (Object)i.toString());
        i = new CalendarInterval(34, 31, 11580000123L);
        Assert.assertEquals((Object)"2 years 10 months 31 days 3 hours 13 minutes 0.000123 seconds", (Object)i.toString());
    }

    @Test
    public void periodAndDurationTest() {
        CalendarInterval interval = new CalendarInterval(120, -40, 123456L);
        Assert.assertEquals((Object)Period.of(0, 120, -40), (Object)interval.extractAsPeriod());
        Assert.assertEquals((Object)Duration.ofNanos(123456000L), (Object)interval.extractAsDuration());
    }
}

