/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.unsafe.types;

import com.google.common.collect.ImmutableMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.Assert;
import org.junit.Test;

public class UTF8StringSuite {
    private static void checkBasic(String str, int len) {
        UTF8String s1 = UTF8String.fromString((String)str);
        UTF8String s2 = UTF8String.fromBytes((byte[])str.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((long)len, (long)s1.numChars());
        Assert.assertEquals((long)len, (long)s2.numChars());
        Assert.assertEquals((Object)str, (Object)s1.toString());
        Assert.assertEquals((Object)str, (Object)s2.toString());
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertEquals((long)0L, (long)s1.compareTo(s2));
        Assert.assertTrue((boolean)s1.contains(s2));
        Assert.assertTrue((boolean)s2.contains(s1));
        Assert.assertTrue((boolean)s1.startsWith(s2));
        Assert.assertTrue((boolean)s1.endsWith(s2));
    }

    @Test
    public void basicTest() {
        UTF8StringSuite.checkBasic("", 0);
        UTF8StringSuite.checkBasic("\u00a1", 1);
        UTF8StringSuite.checkBasic("\u043a\u0443", 2);
        UTF8StringSuite.checkBasic("hello", 5);
        UTF8StringSuite.checkBasic("\u5927 \u5343 \u4e16 \u754c", 7);
        UTF8StringSuite.checkBasic("\ufe3d\ufe4b\uff05", 3);
        UTF8StringSuite.checkBasic("\ud83e\udd19", 1);
    }

    @Test
    public void emptyStringTest() {
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)""));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromBytes((byte[])new byte[0]));
        Assert.assertEquals((long)0L, (long)UTF8String.EMPTY_UTF8.numChars());
        Assert.assertEquals((long)0L, (long)UTF8String.EMPTY_UTF8.numBytes());
    }

    @Test
    public void prefix() {
        Assert.assertTrue((UTF8String.fromString((String)"a").getPrefix() - UTF8String.fromString((String)"b").getPrefix() < 0L ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"ab").getPrefix() - UTF8String.fromString((String)"b").getPrefix() < 0L ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"abbbbbbbbbbbasdf").getPrefix() - UTF8String.fromString((String)"bbbbbbbbbbbbasdf").getPrefix() < 0L ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"").getPrefix() - UTF8String.fromString((String)"a").getPrefix() < 0L ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"\u4f60\u597d").getPrefix() - UTF8String.fromString((String)"\u4e16\u754c").getPrefix() > 0L ? 1 : 0) != 0);
        byte[] buf1 = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        byte[] buf2 = new byte[]{1, 2, 3};
        UTF8String str1 = UTF8String.fromBytes((byte[])buf1, (int)0, (int)3);
        UTF8String str2 = UTF8String.fromBytes((byte[])buf1, (int)0, (int)8);
        UTF8String str3 = UTF8String.fromBytes((byte[])buf2);
        Assert.assertTrue((str1.getPrefix() - str2.getPrefix() < 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)str1.getPrefix(), (long)str3.getPrefix());
    }

    @Test
    public void compareTo() {
        Assert.assertTrue((UTF8String.fromString((String)"").compareTo(UTF8String.fromString((String)"a")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"abc").compareTo(UTF8String.fromString((String)"ABC")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"abc0").compareTo(UTF8String.fromString((String)"abc")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"abcabcabc").compareTo(UTF8String.fromString((String)"abcabcabc")) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"aBcabcabc").compareTo(UTF8String.fromString((String)"Abcabcabc")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"Abcabcabc").compareTo(UTF8String.fromString((String)"abcabcabC")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"abcabcabc").compareTo(UTF8String.fromString((String)"abcabcabC")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"abc").compareTo(UTF8String.fromString((String)"\u4e16\u754c")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"\u4f60\u597d").compareTo(UTF8String.fromString((String)"\u4e16\u754c")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((UTF8String.fromString((String)"\u4f60\u597d123").compareTo(UTF8String.fromString((String)"\u4f60\u597d122")) > 0 ? 1 : 0) != 0);
    }

    protected static void testUpperandLower(String upper, String lower) {
        UTF8String us = UTF8String.fromString((String)upper);
        UTF8String ls = UTF8String.fromString((String)lower);
        Assert.assertEquals((Object)ls, (Object)us.toLowerCase());
        Assert.assertEquals((Object)us, (Object)ls.toUpperCase());
        Assert.assertEquals((Object)us, (Object)us.toUpperCase());
        Assert.assertEquals((Object)ls, (Object)ls.toLowerCase());
    }

    @Test
    public void upperAndLower() {
        UTF8StringSuite.testUpperandLower("", "");
        UTF8StringSuite.testUpperandLower("0123456", "0123456");
        UTF8StringSuite.testUpperandLower("ABCXYZ", "abcxyz");
        UTF8StringSuite.testUpperandLower("\u0400\u0401\u0402\u047a\u038f\u1ec0", "\u0450\u0451\u0452\u047b\u03ce\u1ec1");
        UTF8StringSuite.testUpperandLower("\u5927\u5343\u4e16\u754c \u6570\u636e\u7816\u5934", "\u5927\u5343\u4e16\u754c \u6570\u636e\u7816\u5934");
    }

    @Test
    public void titleCase() {
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"").toTitleCase());
        Assert.assertEquals((Object)UTF8String.fromString((String)"Ab Bc Cd"), (Object)UTF8String.fromString((String)"ab bc cd").toTitleCase());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u0400 \u0401 \u0402 \u047a \u038f \u1ec0"), (Object)UTF8String.fromString((String)"\u0450 \u0451 \u0452 \u047b \u03ce \u1ec1").toTitleCase());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c \u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c \u6570\u636e\u7816\u5934").toTitleCase());
    }

    @Test
    public void concatTest() {
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.concat((UTF8String[])new UTF8String[0]));
        Assert.assertNull((Object)UTF8String.concat((UTF8String[])new UTF8String[]{null}));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.concat((UTF8String[])new UTF8String[]{UTF8String.EMPTY_UTF8}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"ab"), (Object)UTF8String.concat((UTF8String[])new UTF8String[]{UTF8String.fromString((String)"ab")}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"ab"), (Object)UTF8String.concat((UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), UTF8String.fromString((String)"b")}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"abc"), (Object)UTF8String.concat((UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), UTF8String.fromString((String)"b"), UTF8String.fromString((String)"c")}));
        Assert.assertNull((Object)UTF8String.concat((UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), null, UTF8String.fromString((String)"c")}));
        Assert.assertNull((Object)UTF8String.concat((UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), null, null}));
        Assert.assertNull((Object)UTF8String.concat((UTF8String[])new UTF8String[]{null, null, null}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.concat((UTF8String[])new UTF8String[]{UTF8String.fromString((String)"\u6570\u636e"), UTF8String.fromString((String)"\u7816\u5934")}));
    }

    @Test
    public void concatWsTest() {
        Assert.assertNull((Object)UTF8String.concatWs(null, (UTF8String[])new UTF8String[]{null}));
        Assert.assertNull((Object)UTF8String.concatWs(null, (UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a")}));
        UTF8String sep = UTF8String.fromString((String)"\u54c8\u54c8");
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{UTF8String.EMPTY_UTF8}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"ab"), (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{UTF8String.fromString((String)"ab")}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"a\u54c8\u54c8b"), (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), UTF8String.fromString((String)"b")}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"a\u54c8\u54c8b\u54c8\u54c8c"), (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), UTF8String.fromString((String)"b"), UTF8String.fromString((String)"c")}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"a\u54c8\u54c8c"), (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), null, UTF8String.fromString((String)"c")}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"a"), (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{UTF8String.fromString((String)"a"), null, null}));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{null, null, null}));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u54c8\u54c8\u7816\u5934"), (Object)UTF8String.concatWs((UTF8String)sep, (UTF8String[])new UTF8String[]{UTF8String.fromString((String)"\u6570\u636e"), UTF8String.fromString((String)"\u7816\u5934")}));
    }

    @Test
    public void contains() {
        Assert.assertTrue((boolean)UTF8String.EMPTY_UTF8.contains(UTF8String.EMPTY_UTF8));
        Assert.assertTrue((boolean)UTF8String.fromString((String)"hello").contains(UTF8String.fromString((String)"ello")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"hello").contains(UTF8String.fromString((String)"vello")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"hello").contains(UTF8String.fromString((String)"hellooo")));
        Assert.assertTrue((boolean)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c").contains(UTF8String.fromString((String)"\u5343\u4e16\u754c")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c").contains(UTF8String.fromString((String)"\u4e16\u5343")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c").contains(UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c\u597d")));
    }

    @Test
    public void startsWith() {
        Assert.assertTrue((boolean)UTF8String.EMPTY_UTF8.startsWith(UTF8String.EMPTY_UTF8));
        Assert.assertTrue((boolean)UTF8String.fromString((String)"hello").startsWith(UTF8String.fromString((String)"hell")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"hello").startsWith(UTF8String.fromString((String)"ell")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"hello").startsWith(UTF8String.fromString((String)"hellooo")));
        Assert.assertTrue((boolean)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").startsWith(UTF8String.fromString((String)"\u6570\u636e")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c").startsWith(UTF8String.fromString((String)"\u5343")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c").startsWith(UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c\u597d")));
    }

    @Test
    public void endsWith() {
        Assert.assertTrue((boolean)UTF8String.EMPTY_UTF8.endsWith(UTF8String.EMPTY_UTF8));
        Assert.assertTrue((boolean)UTF8String.fromString((String)"hello").endsWith(UTF8String.fromString((String)"ello")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"hello").endsWith(UTF8String.fromString((String)"ellov")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"hello").endsWith(UTF8String.fromString((String)"hhhello")));
        Assert.assertTrue((boolean)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c").endsWith(UTF8String.fromString((String)"\u4e16\u754c")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c").endsWith(UTF8String.fromString((String)"\u4e16")));
        Assert.assertFalse((boolean)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").endsWith(UTF8String.fromString((String)"\u6211\u7684\u6570\u636e\u7816\u5934")));
    }

    @Test
    public void substring() {
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"hello").substring(0, 0));
        Assert.assertEquals((Object)UTF8String.fromString((String)"el"), (Object)UTF8String.fromString((String)"hello").substring(1, 3));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").substring(0, 1));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u636e\u7816"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").substring(1, 3));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").substring(3, 5));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u07f5\u68b7"), (Object)UTF8String.fromString((String)"\u07f5\u68b7").substring(0, 2));
    }

    @Test
    public void trims() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"1"), (Object)UTF8String.fromString((String)"1").trim());
        Assert.assertEquals((Object)UTF8String.fromString((String)"1"), (Object)UTF8String.fromString((String)"1\t").trimAll());
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello"), (Object)UTF8String.fromString((String)"  hello ").trim());
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello "), (Object)UTF8String.fromString((String)"  hello ").trimLeft());
        Assert.assertEquals((Object)UTF8String.fromString((String)"  hello"), (Object)UTF8String.fromString((String)"  hello ").trimRight());
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.EMPTY_UTF8.trim());
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"  ").trim());
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"  ").trimLeft());
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"  ").trimRight());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934 ").trim());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934 "), (Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934 ").trimLeft());
        Assert.assertEquals((Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934 ").trimRight());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").trim());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").trimLeft());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").trimRight());
        char[] charsLessThan0x20 = new char[10];
        Arrays.fill(charsLessThan0x20, '\u001f');
        String stringStartingWithSpace = new String(charsLessThan0x20) + "hello" + new String(charsLessThan0x20);
        Assert.assertEquals((Object)UTF8String.fromString((String)stringStartingWithSpace), (Object)UTF8String.fromString((String)stringStartingWithSpace).trim());
        Assert.assertEquals((Object)UTF8String.fromString((String)stringStartingWithSpace), (Object)UTF8String.fromString((String)stringStartingWithSpace).trimLeft());
        Assert.assertEquals((Object)UTF8String.fromString((String)stringStartingWithSpace), (Object)UTF8String.fromString((String)stringStartingWithSpace).trimRight());
    }

    @Test
    public void indexOf() {
        Assert.assertEquals((long)0L, (long)UTF8String.EMPTY_UTF8.indexOf(UTF8String.EMPTY_UTF8, 0));
        Assert.assertEquals((long)-1L, (long)UTF8String.EMPTY_UTF8.indexOf(UTF8String.fromString((String)"l"), 0));
        Assert.assertEquals((long)0L, (long)UTF8String.fromString((String)"hello").indexOf(UTF8String.EMPTY_UTF8, 0));
        Assert.assertEquals((long)2L, (long)UTF8String.fromString((String)"hello").indexOf(UTF8String.fromString((String)"l"), 0));
        Assert.assertEquals((long)3L, (long)UTF8String.fromString((String)"hello").indexOf(UTF8String.fromString((String)"l"), 3));
        Assert.assertEquals((long)-1L, (long)UTF8String.fromString((String)"hello").indexOf(UTF8String.fromString((String)"a"), 0));
        Assert.assertEquals((long)2L, (long)UTF8String.fromString((String)"hello").indexOf(UTF8String.fromString((String)"ll"), 0));
        Assert.assertEquals((long)-1L, (long)UTF8String.fromString((String)"hello").indexOf(UTF8String.fromString((String)"ll"), 4));
        Assert.assertEquals((long)1L, (long)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").indexOf(UTF8String.fromString((String)"\u636e\u7816"), 0));
        Assert.assertEquals((long)-1L, (long)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").indexOf(UTF8String.fromString((String)"\u6570"), 3));
        Assert.assertEquals((long)0L, (long)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").indexOf(UTF8String.fromString((String)"\u6570"), 0));
        Assert.assertEquals((long)3L, (long)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").indexOf(UTF8String.fromString((String)"\u5934"), 0));
    }

    @Test
    public void substring_index() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"www.apache.org"), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"."), 3));
        Assert.assertEquals((Object)UTF8String.fromString((String)"www.apache"), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"."), 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"www"), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"."), 1));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"."), 0));
        Assert.assertEquals((Object)UTF8String.fromString((String)"org"), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"."), -1));
        Assert.assertEquals((Object)UTF8String.fromString((String)"apache.org"), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"."), -2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"www.apache.org"), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"."), -3));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"").subStringIndex(UTF8String.fromString((String)"."), 1));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)""), 1));
        Assert.assertEquals((Object)UTF8String.fromString((String)"www.apache.org"), (Object)UTF8String.fromString((String)"www.apache.org").subStringIndex(UTF8String.fromString((String)"#"), 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"www||apache"), (Object)UTF8String.fromString((String)"www||apache||org").subStringIndex(UTF8String.fromString((String)"||"), 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"apache||org"), (Object)UTF8String.fromString((String)"www||apache||org").subStringIndex(UTF8String.fromString((String)"||"), -2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c\u5927"), (Object)UTF8String.fromString((String)"\u5927\u5343\u4e16\u754c\u5927\u5343\u4e16\u754c").subStringIndex(UTF8String.fromString((String)"\u5343"), 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"||"), (Object)UTF8String.fromString((String)"||||||").subStringIndex(UTF8String.fromString((String)"|||"), 3));
        Assert.assertEquals((Object)UTF8String.fromString((String)"|||"), (Object)UTF8String.fromString((String)"||||||").subStringIndex(UTF8String.fromString((String)"|||"), -4));
    }

    @Test
    public void reverse() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"olleh"), (Object)UTF8String.fromString((String)"hello").reverse());
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.EMPTY_UTF8.reverse());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u8005\u884c\u5b59"), (Object)UTF8String.fromString((String)"\u5b59\u884c\u8005").reverse());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u8005\u884c\u5b59 olleh"), (Object)UTF8String.fromString((String)"hello \u5b59\u884c\u8005").reverse());
    }

    @Test
    public void repeat() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570d\u6570d\u6570d\u6570d\u6570d"), (Object)UTF8String.fromString((String)"\u6570d").repeat(5));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570d"), (Object)UTF8String.fromString((String)"\u6570d").repeat(1));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"\u6570d").repeat(-1));
    }

    @Test
    public void pad() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"hel"), (Object)UTF8String.fromString((String)"hello").lpad(3, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello"), (Object)UTF8String.fromString((String)"hello").lpad(5, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"?hello"), (Object)UTF8String.fromString((String)"hello").lpad(6, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"???????hello"), (Object)UTF8String.fromString((String)"hello").lpad(12, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"?????hello"), (Object)UTF8String.fromString((String)"hello").lpad(10, UTF8String.fromString((String)"?????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"???????"), (Object)UTF8String.EMPTY_UTF8.lpad(7, UTF8String.fromString((String)"?????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"hel"), (Object)UTF8String.fromString((String)"hello").rpad(3, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello"), (Object)UTF8String.fromString((String)"hello").rpad(5, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello?"), (Object)UTF8String.fromString((String)"hello").rpad(6, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello???????"), (Object)UTF8String.fromString((String)"hello").rpad(12, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello?????"), (Object)UTF8String.fromString((String)"hello").rpad(10, UTF8String.fromString((String)"?????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"???????"), (Object)UTF8String.EMPTY_UTF8.rpad(7, UTF8String.fromString((String)"?????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(3, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"?\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(5, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"??\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(6, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5b59\u884c\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(6, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5b59\u884c\u8005\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(7, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5b59\u884c\u8005\u5b59\u884c\u8005\u5b59\u884c\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(12, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(3, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934?"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(5, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934??"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(6, UTF8String.fromString((String)"????")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934\u5b59\u884c"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(6, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934\u5b59\u884c\u8005"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(7, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934\u5b59\u884c\u8005\u5b59\u884c\u8005\u5b59\u884c"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(12, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(-10, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(-10, UTF8String.EMPTY_UTF8));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(5, UTF8String.EMPTY_UTF8));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").lpad(3, UTF8String.EMPTY_UTF8));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.EMPTY_UTF8.lpad(3, UTF8String.EMPTY_UTF8));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(-10, UTF8String.fromString((String)"\u5b59\u884c\u8005")));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(-10, UTF8String.EMPTY_UTF8));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(5, UTF8String.EMPTY_UTF8));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816"), (Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934").rpad(3, UTF8String.EMPTY_UTF8));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.EMPTY_UTF8.rpad(3, UTF8String.EMPTY_UTF8));
    }

    @Test
    public void substringSQL() {
        UTF8String e = UTF8String.fromString((String)"example");
        Assert.assertEquals((Object)UTF8String.fromString((String)"ex"), (Object)e.substringSQL(0, 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"ex"), (Object)e.substringSQL(1, 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"example"), (Object)e.substringSQL(0, 7));
        Assert.assertEquals((Object)UTF8String.fromString((String)"ex"), (Object)e.substringSQL(1, 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"example"), (Object)e.substringSQL(0, 100));
        Assert.assertEquals((Object)UTF8String.fromString((String)"example"), (Object)e.substringSQL(1, 100));
        Assert.assertEquals((Object)UTF8String.fromString((String)"xa"), (Object)e.substringSQL(2, 2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"exampl"), (Object)e.substringSQL(1, 6));
        Assert.assertEquals((Object)UTF8String.fromString((String)"xample"), (Object)e.substringSQL(2, 100));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)e.substringSQL(0, 0));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)e.substringSQL(100, 4));
        Assert.assertEquals((Object)UTF8String.fromString((String)"example"), (Object)e.substringSQL(0, Integer.MAX_VALUE));
        Assert.assertEquals((Object)UTF8String.fromString((String)"example"), (Object)e.substringSQL(1, Integer.MAX_VALUE));
        Assert.assertEquals((Object)UTF8String.fromString((String)"xample"), (Object)e.substringSQL(2, Integer.MAX_VALUE));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)e.substringSQL(-100, -100));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)e.substringSQL(-1207959552, -1207959552));
        Assert.assertEquals((Object)UTF8String.fromString((String)"pl"), (Object)e.substringSQL(-3, 2));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)e.substringSQL(Integer.MIN_VALUE, 6));
    }

    @Test
    public void split() {
        Object[] negativeAndZeroLimitCase = new UTF8String[]{UTF8String.fromString((String)"ab"), UTF8String.fromString((String)"def"), UTF8String.fromString((String)"ghi"), UTF8String.fromString((String)"")};
        Assert.assertTrue((boolean)Arrays.equals(UTF8String.fromString((String)"ab,def,ghi,").split(UTF8String.fromString((String)","), 0), negativeAndZeroLimitCase));
        Assert.assertTrue((boolean)Arrays.equals(UTF8String.fromString((String)"ab,def,ghi,").split(UTF8String.fromString((String)","), -1), negativeAndZeroLimitCase));
        Assert.assertTrue((boolean)Arrays.equals(UTF8String.fromString((String)"ab,def,ghi,").split(UTF8String.fromString((String)","), 2), new UTF8String[]{UTF8String.fromString((String)"ab"), UTF8String.fromString((String)"def,ghi,")}));
    }

    @Test
    public void replace() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"re123ace"), (Object)UTF8String.fromString((String)"replace").replace(UTF8String.fromString((String)"pl"), UTF8String.fromString((String)"123")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"reace"), (Object)UTF8String.fromString((String)"replace").replace(UTF8String.fromString((String)"pl"), UTF8String.fromString((String)"")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"replace"), (Object)UTF8String.fromString((String)"replace").replace(UTF8String.fromString((String)""), UTF8String.fromString((String)"123")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"a12ca12c"), (Object)UTF8String.fromString((String)"abcabc").replace(UTF8String.fromString((String)"b"), UTF8String.fromString((String)"12")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"adad"), (Object)UTF8String.fromString((String)"abcdabcd").replace(UTF8String.fromString((String)"bc"), UTF8String.fromString((String)"")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"AbcAbc"), (Object)UTF8String.fromString((String)"abcabc").replace(UTF8String.fromString((String)"a"), UTF8String.fromString((String)"A")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"abcabc"), (Object)UTF8String.fromString((String)"abcabc").replace(UTF8String.fromString((String)"Z"), UTF8String.fromString((String)"A")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u82b1ab\u754c"), (Object)UTF8String.fromString((String)"\u82b1\u82b1\u4e16\u754c").replace(UTF8String.fromString((String)"\u82b1\u4e16"), UTF8String.fromString((String)"ab")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"a\u6c34c"), (Object)UTF8String.fromString((String)"a\u706bc").replace(UTF8String.fromString((String)"\u706b"), UTF8String.fromString((String)"\u6c34")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"abcd").repeat(17), (Object)UTF8String.fromString((String)"a").repeat(17).replace(UTF8String.fromString((String)"a"), UTF8String.fromString((String)"abcd")));
    }

    @Test
    public void levenshteinDistance() {
        Assert.assertEquals((long)0L, (long)UTF8String.EMPTY_UTF8.levenshteinDistance(UTF8String.EMPTY_UTF8));
        Assert.assertEquals((long)1L, (long)UTF8String.EMPTY_UTF8.levenshteinDistance(UTF8String.fromString((String)"a")));
        Assert.assertEquals((long)7L, (long)UTF8String.fromString((String)"aaapppp").levenshteinDistance(UTF8String.EMPTY_UTF8));
        Assert.assertEquals((long)1L, (long)UTF8String.fromString((String)"frog").levenshteinDistance(UTF8String.fromString((String)"fog")));
        Assert.assertEquals((long)3L, (long)UTF8String.fromString((String)"fly").levenshteinDistance(UTF8String.fromString((String)"ant")));
        Assert.assertEquals((long)7L, (long)UTF8String.fromString((String)"elephant").levenshteinDistance(UTF8String.fromString((String)"hippo")));
        Assert.assertEquals((long)7L, (long)UTF8String.fromString((String)"hippo").levenshteinDistance(UTF8String.fromString((String)"elephant")));
        Assert.assertEquals((long)8L, (long)UTF8String.fromString((String)"hippo").levenshteinDistance(UTF8String.fromString((String)"zzzzzzzz")));
        Assert.assertEquals((long)1L, (long)UTF8String.fromString((String)"hello").levenshteinDistance(UTF8String.fromString((String)"hallo")));
        Assert.assertEquals((long)4L, (long)UTF8String.fromString((String)"\u4e16\u754c\u5343\u4e16").levenshteinDistance(UTF8String.fromString((String)"\u5343a\u4e16b")));
    }

    @Test
    public void translate() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"1a2s3ae"), (Object)UTF8String.fromString((String)"translate").translate((Map)ImmutableMap.of((Object)Character.valueOf('r'), (Object)Character.valueOf('1'), (Object)Character.valueOf('n'), (Object)Character.valueOf('2'), (Object)Character.valueOf('l'), (Object)Character.valueOf('3'), (Object)Character.valueOf('t'), (Object)Character.valueOf('\u0000'))));
        Assert.assertEquals((Object)UTF8String.fromString((String)"translate"), (Object)UTF8String.fromString((String)"translate").translate(new HashMap()));
        Assert.assertEquals((Object)UTF8String.fromString((String)"asae"), (Object)UTF8String.fromString((String)"translate").translate((Map)ImmutableMap.of((Object)Character.valueOf('r'), (Object)Character.valueOf('\u0000'), (Object)Character.valueOf('n'), (Object)Character.valueOf('\u0000'), (Object)Character.valueOf('l'), (Object)Character.valueOf('\u0000'), (Object)Character.valueOf('t'), (Object)Character.valueOf('\u0000'))));
        Assert.assertEquals((Object)UTF8String.fromString((String)"aa\u4e16b"), (Object)UTF8String.fromString((String)"\u82b1\u82b1\u4e16\u754c").translate((Map)ImmutableMap.of((Object)Character.valueOf('\u82b1'), (Object)Character.valueOf('a'), (Object)Character.valueOf('\u754c'), (Object)Character.valueOf('b'))));
    }

    @Test
    public void createBlankString() {
        Assert.assertEquals((Object)UTF8String.fromString((String)" "), (Object)UTF8String.blankString((int)1));
        Assert.assertEquals((Object)UTF8String.fromString((String)"  "), (Object)UTF8String.blankString((int)2));
        Assert.assertEquals((Object)UTF8String.fromString((String)"   "), (Object)UTF8String.blankString((int)3));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.blankString((int)0));
    }

    @Test
    public void findInSet() {
        Assert.assertEquals((long)1L, (long)UTF8String.fromString((String)"ab").findInSet(UTF8String.fromString((String)"ab")));
        Assert.assertEquals((long)2L, (long)UTF8String.fromString((String)"a,b").findInSet(UTF8String.fromString((String)"b")));
        Assert.assertEquals((long)3L, (long)UTF8String.fromString((String)"abc,b,ab,c,def").findInSet(UTF8String.fromString((String)"ab")));
        Assert.assertEquals((long)1L, (long)UTF8String.fromString((String)"ab,abc,b,ab,c,def").findInSet(UTF8String.fromString((String)"ab")));
        Assert.assertEquals((long)4L, (long)UTF8String.fromString((String)",,,ab,abc,b,ab,c,def").findInSet(UTF8String.fromString((String)"ab")));
        Assert.assertEquals((long)1L, (long)UTF8String.fromString((String)",ab,abc,b,ab,c,def").findInSet(UTF8String.fromString((String)"")));
        Assert.assertEquals((long)4L, (long)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934,abc,b,ab,c,def").findInSet(UTF8String.fromString((String)"ab")));
        Assert.assertEquals((long)6L, (long)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934,abc,b,ab,c,def").findInSet(UTF8String.fromString((String)"def")));
    }

    @Test
    public void soundex() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"R163"), (Object)UTF8String.fromString((String)"Robert").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"R163"), (Object)UTF8String.fromString((String)"Rupert").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"R150"), (Object)UTF8String.fromString((String)"Rubin").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"A261"), (Object)UTF8String.fromString((String)"Ashcraft").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"A261"), (Object)UTF8String.fromString((String)"Ashcroft").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"B620"), (Object)UTF8String.fromString((String)"Burroughs").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"B620"), (Object)UTF8String.fromString((String)"Burrows").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"E251"), (Object)UTF8String.fromString((String)"Ekzampul").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"E251"), (Object)UTF8String.fromString((String)"Example").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"E460"), (Object)UTF8String.fromString((String)"Ellery").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"E460"), (Object)UTF8String.fromString((String)"Euler").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"G200"), (Object)UTF8String.fromString((String)"Ghosh").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"G200"), (Object)UTF8String.fromString((String)"Gauss").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"G362"), (Object)UTF8String.fromString((String)"Gutierrez").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"H416"), (Object)UTF8String.fromString((String)"Heilbronn").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"H416"), (Object)UTF8String.fromString((String)"Hilbert").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"J250"), (Object)UTF8String.fromString((String)"Jackson").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"K530"), (Object)UTF8String.fromString((String)"Kant").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"K530"), (Object)UTF8String.fromString((String)"Knuth").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"L000"), (Object)UTF8String.fromString((String)"Lee").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"L222"), (Object)UTF8String.fromString((String)"Lukasiewicz").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"L222"), (Object)UTF8String.fromString((String)"Lissajous").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"L300"), (Object)UTF8String.fromString((String)"Ladd").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"L300"), (Object)UTF8String.fromString((String)"Lloyd").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"M220"), (Object)UTF8String.fromString((String)"Moses").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"O600"), (Object)UTF8String.fromString((String)"O'Hara").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"P236"), (Object)UTF8String.fromString((String)"Pfister").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"R150"), (Object)UTF8String.fromString((String)"Rubin").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"R163"), (Object)UTF8String.fromString((String)"Robert").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"R163"), (Object)UTF8String.fromString((String)"Rupert").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"S532"), (Object)UTF8String.fromString((String)"Soundex").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"S532"), (Object)UTF8String.fromString((String)"Sownteks").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"T522"), (Object)UTF8String.fromString((String)"Tymczak").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"V532"), (Object)UTF8String.fromString((String)"VanDeusen").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"W252"), (Object)UTF8String.fromString((String)"Washington").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"W350"), (Object)UTF8String.fromString((String)"Wheaton").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"A000"), (Object)UTF8String.fromString((String)"a").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"A100"), (Object)UTF8String.fromString((String)"ab").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"A120"), (Object)UTF8String.fromString((String)"abc").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"A123"), (Object)UTF8String.fromString((String)"abcd").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"123"), (Object)UTF8String.fromString((String)"123").soundex());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u4e16\u754c\u5343\u4e16"), (Object)UTF8String.fromString((String)"\u4e16\u754c\u5343\u4e16").soundex());
    }

    @Test
    public void writeToOutputStreamUnderflow() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] test = "01234567".getBytes(StandardCharsets.UTF_8);
        for (int i = 1; i <= Platform.BYTE_ARRAY_OFFSET; ++i) {
            UTF8String.fromAddress((Object)test, (long)(Platform.BYTE_ARRAY_OFFSET - i), (int)(test.length + i)).writeTo((OutputStream)outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(outputStream.toByteArray(), i, test.length);
            Assert.assertEquals((Object)"01234567", (Object)StandardCharsets.UTF_8.decode(buffer).toString());
            outputStream.reset();
        }
    }

    @Test
    public void writeToOutputStreamSlice() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] test = "01234567".getBytes(StandardCharsets.UTF_8);
        for (int i = 0; i < test.length; ++i) {
            for (int j = 0; j < test.length - i; ++j) {
                UTF8String.fromAddress((Object)test, (long)(Platform.BYTE_ARRAY_OFFSET + i), (int)j).writeTo((OutputStream)outputStream);
                Assert.assertArrayEquals((byte[])Arrays.copyOfRange(test, i, i + j), (byte[])outputStream.toByteArray());
                outputStream.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeToOutputStreamOverflow() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] test = "01234567".getBytes(StandardCharsets.UTF_8);
        HashSet<Long> offsets = new HashSet<Long>();
        for (int i = 0; i < 16; ++i) {
            offsets.add(Integer.MAX_VALUE - (long)i);
            offsets.add(Long.MAX_VALUE - (long)Platform.BYTE_ARRAY_OFFSET - (long)i);
        }
        for (long i = 1L; i > 0L; i <<= 1) {
            for (long j = 0L; j < 32L; ++j) {
                offsets.add(i + j);
            }
        }
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            long offset = (Long)iterator.next();
            try {
                try {
                    UTF8String.fromAddress((Object)test, (long)((long)Platform.BYTE_ARRAY_OFFSET + offset), (int)test.length).writeTo((OutputStream)outputStream);
                    throw new IllegalStateException(Long.toString(offset));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    outputStream.reset();
                }
            }
            catch (Throwable throwable) {
                outputStream.reset();
                throw throwable;
            }
        }
    }

    @Test
    public void writeToOutputStream() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        UTF8String.EMPTY_UTF8.writeTo((OutputStream)outputStream);
        Assert.assertEquals((Object)"", (Object)outputStream.toString(StandardCharsets.UTF_8.name()));
        outputStream.reset();
        UTF8String.fromString((String)"\u6570\u636e\u7816\u5f88\u91cd").writeTo((OutputStream)outputStream);
        Assert.assertEquals((Object)"\u6570\u636e\u7816\u5f88\u91cd", (Object)outputStream.toString(StandardCharsets.UTF_8.name()));
        outputStream.reset();
    }

    @Test
    public void writeToOutputStreamIntArray() throws IOException {
        ByteBuffer buffer = StandardCharsets.UTF_8.encode("\u5927\u5343\u4e16\u754c");
        buffer.position(0);
        buffer.order(ByteOrder.nativeOrder());
        int length = buffer.limit();
        Assert.assertEquals((long)12L, (long)length);
        int ints = length / 4;
        int[] array = new int[ints];
        for (int i = 0; i < ints; ++i) {
            array[i] = buffer.getInt();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        UTF8String.fromAddress((Object)array, (long)Platform.INT_ARRAY_OFFSET, (int)length).writeTo((OutputStream)outputStream);
        Assert.assertEquals((Object)"\u5927\u5343\u4e16\u754c", (Object)outputStream.toString(StandardCharsets.UTF_8.name()));
    }

    @Test
    public void testToShort() throws IOException {
        HashMap<String, Short> inputToExpectedOutput = new HashMap<String, Short>();
        inputToExpectedOutput.put("1", (short)1);
        inputToExpectedOutput.put("+1", (short)1);
        inputToExpectedOutput.put("-1", (short)-1);
        inputToExpectedOutput.put("0", (short)0);
        inputToExpectedOutput.put("1111.12345678901234567890", (short)1111);
        inputToExpectedOutput.put(String.valueOf(Short.MAX_VALUE), (short)Short.MAX_VALUE);
        inputToExpectedOutput.put(String.valueOf(Short.MIN_VALUE), (short)Short.MIN_VALUE);
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            short value = (short)rand.nextInt();
            inputToExpectedOutput.put(String.valueOf(value), value);
        }
        UTF8String.IntWrapper wrapper = new UTF8String.IntWrapper();
        for (Map.Entry entry : inputToExpectedOutput.entrySet()) {
            Assert.assertTrue((String)((String)entry.getKey()), (boolean)UTF8String.fromString((String)((String)entry.getKey())).toShort(wrapper));
            Assert.assertEquals((long)((Short)entry.getValue()).shortValue(), (long)wrapper.value);
        }
        List<String> negativeInputs = Arrays.asList("", "  ", "null", "NULL", "\n", "~1212121", "3276700");
        for (String negativeInput : negativeInputs) {
            Assert.assertFalse((String)negativeInput, (boolean)UTF8String.fromString((String)negativeInput).toShort(wrapper));
        }
    }

    @Test
    public void testToByte() throws IOException {
        HashMap<String, Byte> inputToExpectedOutput = new HashMap<String, Byte>();
        inputToExpectedOutput.put("1", (byte)1);
        inputToExpectedOutput.put("+1", (byte)1);
        inputToExpectedOutput.put("-1", (byte)-1);
        inputToExpectedOutput.put("0", (byte)0);
        inputToExpectedOutput.put("111.12345678901234567890", (byte)111);
        inputToExpectedOutput.put(String.valueOf(127), (byte)127);
        inputToExpectedOutput.put(String.valueOf(-128), (byte)-128);
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            byte value = (byte)rand.nextInt();
            inputToExpectedOutput.put(String.valueOf(value), value);
        }
        UTF8String.IntWrapper intWrapper = new UTF8String.IntWrapper();
        for (Map.Entry entry : inputToExpectedOutput.entrySet()) {
            Assert.assertTrue((String)((String)entry.getKey()), (boolean)UTF8String.fromString((String)((String)entry.getKey())).toByte(intWrapper));
            Assert.assertEquals((long)((Byte)entry.getValue()).byteValue(), (long)intWrapper.value);
        }
        List<String> negativeInputs = Arrays.asList("", "  ", "null", "NULL", "\n", "~1212121", "12345678901234567890");
        for (String negativeInput : negativeInputs) {
            Assert.assertFalse((String)negativeInput, (boolean)UTF8String.fromString((String)negativeInput).toByte(intWrapper));
        }
    }

    @Test
    public void testToInt() throws IOException {
        HashMap<String, Integer> inputToExpectedOutput = new HashMap<String, Integer>();
        inputToExpectedOutput.put("1", 1);
        inputToExpectedOutput.put("+1", 1);
        inputToExpectedOutput.put("-1", -1);
        inputToExpectedOutput.put("0", 0);
        inputToExpectedOutput.put("11111.1234567", 11111);
        inputToExpectedOutput.put(String.valueOf(Integer.MAX_VALUE), Integer.MAX_VALUE);
        inputToExpectedOutput.put(String.valueOf(Integer.MIN_VALUE), Integer.MIN_VALUE);
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            int value = rand.nextInt();
            inputToExpectedOutput.put(String.valueOf(value), value);
        }
        UTF8String.IntWrapper intWrapper = new UTF8String.IntWrapper();
        for (Map.Entry entry : inputToExpectedOutput.entrySet()) {
            Assert.assertTrue((String)((String)entry.getKey()), (boolean)UTF8String.fromString((String)((String)entry.getKey())).toInt(intWrapper));
            Assert.assertEquals((long)((Integer)entry.getValue()).intValue(), (long)intWrapper.value);
        }
        List<String> negativeInputs = Arrays.asList("", "  ", "null", "NULL", "\n", "~1212121", "12345678901234567890");
        for (String negativeInput : negativeInputs) {
            Assert.assertFalse((String)negativeInput, (boolean)UTF8String.fromString((String)negativeInput).toInt(intWrapper));
        }
    }

    @Test
    public void testToLong() throws IOException {
        HashMap<String, Long> inputToExpectedOutput = new HashMap<String, Long>();
        inputToExpectedOutput.put("1", 1L);
        inputToExpectedOutput.put("+1", 1L);
        inputToExpectedOutput.put("-1", -1L);
        inputToExpectedOutput.put("0", 0L);
        inputToExpectedOutput.put("1076753423.12345678901234567890", 1076753423L);
        inputToExpectedOutput.put(String.valueOf(Long.MAX_VALUE), Long.MAX_VALUE);
        inputToExpectedOutput.put(String.valueOf(Long.MIN_VALUE), Long.MIN_VALUE);
        Random rand = new Random();
        for (int i = 0; i < 10; ++i) {
            long value = rand.nextLong();
            inputToExpectedOutput.put(String.valueOf(value), value);
        }
        UTF8String.LongWrapper wrapper = new UTF8String.LongWrapper();
        for (Map.Entry entry : inputToExpectedOutput.entrySet()) {
            Assert.assertTrue((String)((String)entry.getKey()), (boolean)UTF8String.fromString((String)((String)entry.getKey())).toLong(wrapper));
            Assert.assertEquals((long)((Long)entry.getValue()), (long)wrapper.value);
        }
        List<String> negativeInputs = Arrays.asList("", "  ", "null", "NULL", "\n", "~1212121", "1234567890123456789012345678901234");
        for (String negativeInput : negativeInputs) {
            Assert.assertFalse((String)negativeInput, (boolean)UTF8String.fromString((String)negativeInput).toLong(wrapper));
        }
    }

    @Test
    public void trimBothWithTrimString() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"hello"), (Object)UTF8String.fromString((String)"  hello ").trim(UTF8String.fromString((String)" ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"o"), (Object)UTF8String.fromString((String)"  hello ").trim(UTF8String.fromString((String)" hle")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"h e"), (Object)UTF8String.fromString((String)"ooh e ooo").trim(UTF8String.fromString((String)"o ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"ooo...oooo").trim(UTF8String.fromString((String)"o.")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"b"), (Object)UTF8String.fromString((String)"%^b[]@").trim(UTF8String.fromString((String)"][@^%")));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"  ").trim(UTF8String.fromString((String)" ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934 ").trim());
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570"), (Object)UTF8String.fromString((String)"a\u6570b").trim(UTF8String.fromString((String)"ab")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"a").trim(UTF8String.fromString((String)"a\u6570b")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"\u6570\u6570 \u6570\u6570\u6570").trim(UTF8String.fromString((String)"\u6570 ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570]\u6570[\u6570\u636e\u7816\u5934#\u6570\u6570").trim(UTF8String.fromString((String)"[\u6570]#")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u636e\u7816\u5934\u6570\u6570 "), (Object)UTF8String.fromString((String)"\u6570\u6570\u6570\u636e\u7816\u5934\u6570\u6570 ").trim(UTF8String.fromString((String)"\u6570")));
    }

    @Test
    public void trimLeftWithTrimString() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"  hello "), (Object)UTF8String.fromString((String)"  hello ").trimLeft(UTF8String.fromString((String)"")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"a").trimLeft(UTF8String.fromString((String)"a")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"b"), (Object)UTF8String.fromString((String)"b").trimLeft(UTF8String.fromString((String)"a")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"ba"), (Object)UTF8String.fromString((String)"ba").trimLeft(UTF8String.fromString((String)"a")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"aaaaaaa").trimLeft(UTF8String.fromString((String)"a")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"trim"), (Object)UTF8String.fromString((String)"oabtrim").trimLeft(UTF8String.fromString((String)"bao")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"rim "), (Object)UTF8String.fromString((String)"ooootrim ").trimLeft(UTF8String.fromString((String)"otm")));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"  ").trimLeft(UTF8String.fromString((String)" ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u636e\u7816\u5934 "), (Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934 ").trimLeft(UTF8String.fromString((String)" ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570"), (Object)UTF8String.fromString((String)"\u6570").trimLeft(UTF8String.fromString((String)"a")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"a"), (Object)UTF8String.fromString((String)"a").trimLeft(UTF8String.fromString((String)"\u6570")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u7816\u5934\u6570\u6570"), (Object)UTF8String.fromString((String)"\u6570\u6570\u6570\u636e\u7816\u5934\u6570\u6570").trimLeft(UTF8String.fromString((String)"\u636e\u6570")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u636e\u7816\u5934\u6570\u6570"), (Object)UTF8String.fromString((String)" \u6570\u6570\u6570\u636e\u7816\u5934\u6570\u6570").trimLeft(UTF8String.fromString((String)"\u6570 ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u636e\u7816\u5934\u6570\u6570"), (Object)UTF8String.fromString((String)"aa\u6570\u6570\u6570\u636e\u7816\u5934\u6570\u6570").trimLeft(UTF8String.fromString((String)"a\u6570\u7816")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"$S,.$BR"), (Object)UTF8String.fromString((String)",,,,%$S,.$BR").trimLeft(UTF8String.fromString((String)"%,")));
    }

    @Test
    public void trimRightWithTrimString() {
        Assert.assertEquals((Object)UTF8String.fromString((String)"  hello "), (Object)UTF8String.fromString((String)"  hello ").trimRight(UTF8String.fromString((String)"")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"a").trimRight(UTF8String.fromString((String)"a")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"cc"), (Object)UTF8String.fromString((String)"ccbaaaa").trimRight(UTF8String.fromString((String)"ba")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"aabbbbaaa").trimRight(UTF8String.fromString((String)"ab")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"  he"), (Object)UTF8String.fromString((String)"  hello ").trimRight(UTF8String.fromString((String)" ol")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"oohell"), (Object)UTF8String.fromString((String)"oohellooo../*&").trimRight(UTF8String.fromString((String)"./,&%*o")));
        Assert.assertEquals((Object)UTF8String.EMPTY_UTF8, (Object)UTF8String.fromString((String)"  ").trimRight(UTF8String.fromString((String)" ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934"), (Object)UTF8String.fromString((String)"  \u6570\u636e\u7816\u5934 ").trimRight(UTF8String.fromString((String)" ")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u6570\u6570\u7816\u5934"), (Object)UTF8String.fromString((String)"\u6570\u6570\u7816\u5934\u6570aa\u6570").trimRight(UTF8String.fromString((String)"a\u6570")));
        Assert.assertEquals((Object)UTF8String.fromString((String)""), (Object)UTF8String.fromString((String)"\u6570\u6570\u6570\u636e\u7816ab").trimRight(UTF8String.fromString((String)"\u6570\u636e\u7816ab")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5934"), (Object)UTF8String.fromString((String)"\u5934a???/").trimRight(UTF8String.fromString((String)"\u6570?/*&^%a")));
        Assert.assertEquals((Object)UTF8String.fromString((String)"\u5934"), (Object)UTF8String.fromString((String)"\u5934\u6570b\u6570\u6570 [").trimRight(UTF8String.fromString((String)" []\u6570b")));
    }

    @Test
    public void skipWrongFirstByte() {
        int[] wrongFirstBytes = new int[]{128, 159, 191, 192, 194, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
        byte[] c = new byte[1];
        for (int i = 0; i < wrongFirstBytes.length; ++i) {
            c[0] = (byte)wrongFirstBytes[i];
            Assert.assertEquals((long)1L, (long)UTF8String.fromBytes((byte[])c).numChars());
        }
    }
}

