/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.netty.implementation.DeferredCacheImmutableMap;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class NettyToAzureCoreHttpHeadersWrapper
extends HttpHeaders {
    private static final ClientLogger LOGGER = new ClientLogger(NettyToAzureCoreHttpHeadersWrapper.class);
    private final io.netty.handler.codec.http.HttpHeaders nettyHeaders;
    private Map<String, String> abstractMap;
    private Map<String, String[]> abstractMultiMap;

    public NettyToAzureCoreHttpHeadersWrapper(io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        this.nettyHeaders = nettyHeaders;
    }

    @Override
    public int getSize() {
        return this.nettyHeaders.size();
    }

    @Override
    public HttpHeaders set(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.set(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpHeaders set(String name, List<String> values) {
        if (name == null) {
            return this;
        }
        if (values == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.set(name, (Iterable<?>)values);
        }
        return this;
    }

    @Override
    public HttpHeaders add(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.add(name, (Object)value);
        }
        return this;
    }

    @Override
    public HttpHeader get(String name) {
        List<String> values = this.nettyHeaders.getAll(name);
        return CoreUtils.isNullOrEmpty(values) ? null : new NettyHttpHeader(this, name, values);
    }

    @Override
    public HttpHeader remove(String name) {
        HttpHeader header = this.get(name);
        this.nettyHeaders.remove(name);
        return header;
    }

    @Override
    public String getValue(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValue();
    }

    @Override
    public String[] getValues(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValues();
    }

    @Override
    public Map<String, String> toMap() {
        if (this.abstractMap == null) {
            this.abstractMap = new DeferredCacheImmutableMap<String>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> CoreUtils.stringJoin(",", getAll));
        }
        return this.abstractMap;
    }

    Map<String, String[]> toMultiMap() {
        if (this.abstractMultiMap == null) {
            this.abstractMultiMap = new DeferredCacheImmutableMap<String[]>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> getAll.toArray(new String[0]));
        }
        return this.abstractMultiMap;
    }

    @Override
    public Iterator<HttpHeader> iterator() {
        return new NettyHeadersIterator(this);
    }

    @Override
    public Stream<HttpHeader> stream() {
        return this.nettyHeaders.names().stream().map(name -> new NettyHttpHeader(this, (String)name, this.nettyHeaders.getAll((String)name)));
    }

    static class NettyHttpHeader
    extends HttpHeader {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, String value) {
            super(name, value);
            this.allHeaders = allHeaders;
        }

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, List<String> values) {
            super(name, values);
            this.allHeaders = allHeaders;
        }

        @Override
        public void addValue(String value) {
            super.addValue(value);
            this.allHeaders.add(this.getName(), value);
        }
    }

    static final class NettyHeadersIterator
    implements Iterator<HttpHeader> {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;
        private final Iterator<String> headerNames;

        NettyHeadersIterator(NettyToAzureCoreHttpHeadersWrapper allHeaders) {
            this.allHeaders = allHeaders;
            this.headerNames = allHeaders.nettyHeaders.names().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.headerNames.hasNext();
        }

        @Override
        public NettyHttpHeader next() {
            String headerName = this.headerNames.next();
            return new NettyHttpHeader(this.allHeaders, headerName, this.allHeaders.nettyHeaders.getAll(headerName));
        }
    }
}

