/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.implementation.logging.LoggingUtils;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.LogLevel;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class LoggingEventBuilder {
    private static final JsonStringEncoder JSON_STRING_ENCODER = JsonStringEncoder.getInstance();
    private static final LoggingEventBuilder NOOP = new LoggingEventBuilder(null, null, null, false);
    private static final String AZURE_SDK_LOG_MESSAGE_KEY = "az.sdk.message";
    private final Logger logger;
    private final LogLevel level;
    private List<ContextKeyValuePair> context;
    private final String globalContextCached;
    private final boolean hasGlobalContext;
    private final boolean isEnabled;

    static LoggingEventBuilder create(Logger logger, LogLevel level, String globalContextSerialized, boolean canLogAtLevel) {
        if (canLogAtLevel) {
            return new LoggingEventBuilder(logger, level, globalContextSerialized, true);
        }
        return NOOP;
    }

    private LoggingEventBuilder(Logger logger, LogLevel level, String globalContextSerialized, boolean isEnabled) {
        this.logger = logger;
        this.level = level;
        this.isEnabled = isEnabled;
        this.context = Collections.emptyList();
        this.globalContextCached = globalContextSerialized == null ? "" : globalContextSerialized;
        this.hasGlobalContext = !this.globalContextCached.isEmpty();
    }

    public LoggingEventBuilder addKeyValue(String key, String value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Object value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value == null ? null : value.toString());
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, boolean value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, long value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Supplier<String> valueSupplier) {
        if (this.isEnabled) {
            if (this.context.isEmpty()) {
                this.context = new ArrayList<ContextKeyValuePair>();
            }
            this.context.add(new ContextKeyValuePair(key, valueSupplier));
        }
        return this;
    }

    public void log(String message) {
        if (this.isEnabled) {
            this.performLogging(this.level, message, new Object[0]);
        }
    }

    public void log(Supplier<String> messageSupplier) {
        if (this.isEnabled) {
            String message = messageSupplier != null ? messageSupplier.get() : null;
            this.performLogging(this.level, message, new Object[0]);
        }
    }

    public void log(Supplier<String> messageSupplier, Throwable throwable) {
        if (this.isEnabled) {
            String message = messageSupplier != null ? messageSupplier.get() : null;
            this.performLogging(this.level, message, throwable);
        }
    }

    public void log(String format, Object ... args) {
        if (this.isEnabled) {
            this.performLogging(this.level, format, args);
        }
    }

    public Throwable log(Throwable throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, null, throwable);
        }
        return throwable;
    }

    public RuntimeException log(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, null, runtimeException);
        }
        return runtimeException;
    }

    private String getMessageWithContext(String message, Throwable throwable) {
        if (message == null) {
            message = "";
        }
        StringBuilder sb = new StringBuilder(20 + this.context.size() * 20 + message.length() + this.globalContextCached.length());
        sb.append("{\"").append(AZURE_SDK_LOG_MESSAGE_KEY).append("\":\"");
        JSON_STRING_ENCODER.quoteAsString(message, sb);
        sb.append("\"");
        if (throwable != null) {
            sb.append(",\"exception\":");
            String exceptionMessage = throwable.getMessage();
            if (exceptionMessage != null) {
                sb.append("\"");
                JSON_STRING_ENCODER.quoteAsString(exceptionMessage, sb);
                sb.append("\"");
            } else {
                sb.append("null");
            }
        }
        if (this.hasGlobalContext) {
            sb.append(",").append(this.globalContextCached);
        }
        for (int i = 0; i < this.context.size(); ++i) {
            this.context.get(i).write(sb.append(","));
        }
        sb.append("}");
        return sb.toString();
    }

    private void addKeyValueInternal(String key, Object value) {
        if (this.context.isEmpty()) {
            this.context = new ArrayList<ContextKeyValuePair>();
        }
        this.context.add(new ContextKeyValuePair(key, value));
    }

    private void performLogging(LogLevel logLevel, String format, Object ... args) {
        Throwable throwable = null;
        if (LoggingUtils.doesArgsHaveThrowable(args)) {
            Object throwableObj = args[args.length - 1];
            if (throwableObj instanceof Throwable) {
                throwable = (Throwable)throwableObj;
            }
            if (!this.logger.isDebugEnabled()) {
                args = LoggingUtils.removeThrowable(args);
            }
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(format, args);
        String message = this.getMessageWithContext(tuple.getMessage(), throwable);
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(message, tuple.getThrowable());
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(message, tuple.getThrowable());
                break;
            }
            case WARNING: {
                this.logger.warn(message, tuple.getThrowable());
                break;
            }
            case ERROR: {
                this.logger.error(message, tuple.getThrowable());
                break;
            }
        }
    }

    static String writeJsonFragment(Map<String, Object> context) {
        if (CoreUtils.isNullOrEmpty(context)) {
            return "";
        }
        StringBuilder formatter = new StringBuilder(context.size() * 20);
        for (Map.Entry<String, Object> pair : context.entrySet()) {
            LoggingEventBuilder.writeKeyAndValue(pair.getKey(), pair.getValue(), formatter).append(",");
        }
        return formatter.deleteCharAt(formatter.length() - 1).toString();
    }

    private static StringBuilder writeKeyAndValue(String key, Object value, StringBuilder formatter) {
        formatter.append("\"");
        JSON_STRING_ENCODER.quoteAsString(key, formatter);
        formatter.append("\":");
        if (value == null) {
            return formatter.append("null");
        }
        if (LoggingEventBuilder.isPrimitive(value)) {
            JSON_STRING_ENCODER.quoteAsString(value.toString(), formatter);
            return formatter;
        }
        formatter.append("\"");
        JSON_STRING_ENCODER.quoteAsString(value.toString(), formatter);
        return formatter.append("\"");
    }

    private static boolean isPrimitive(Object value) {
        if (value instanceof String) {
            return false;
        }
        return value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Byte || value instanceof Double || value instanceof Float;
    }

    private static final class ContextKeyValuePair {
        private final String key;
        private final Object value;
        private final Supplier<String> valueSupplier;

        ContextKeyValuePair(String key, Object value) {
            this.key = key;
            this.value = value;
            this.valueSupplier = null;
        }

        ContextKeyValuePair(String key, Supplier<String> valueSupplier) {
            this.key = key;
            this.value = null;
            this.valueSupplier = valueSupplier;
        }

        public StringBuilder write(StringBuilder formatter) {
            if (this.valueSupplier == null) {
                return LoggingEventBuilder.writeKeyAndValue(this.key, this.value, formatter);
            }
            return LoggingEventBuilder.writeKeyAndValue(this.key, this.valueSupplier.get(), formatter);
        }
    }
}

