/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.metrics;

import com.azure.core.util.MetricsOptions;
import com.azure.core.util.TelemetryAttributes;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.metrics.LongGauge;
import com.azure.core.util.metrics.Meter;
import com.azure.core.util.metrics.MeterProvider;
import com.azure.core.util.metrics.NoopMeter;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

final class DefaultMeterProvider
implements MeterProvider {
    private static final MeterProvider INSTANCE = new DefaultMeterProvider();
    private static final RuntimeException ERROR;
    private static final ClientLogger LOGGER;
    private static final AutoCloseable NOOP_CLOSEABLE;
    private static MeterProvider meterProvider;
    static final LongGauge NOOP_GAUGE;

    private DefaultMeterProvider() {
    }

    static MeterProvider getInstance() {
        if (ERROR != null) {
            throw LOGGER.logThrowableAsError(ERROR);
        }
        return INSTANCE;
    }

    @Override
    public Meter createMeter(String libraryName, String libraryVersion, MetricsOptions options) {
        Objects.requireNonNull(libraryName, "'libraryName' cannot be null.");
        if (meterProvider != null && (options == null || options.isEnabled())) {
            return meterProvider.createMeter(libraryName, libraryVersion, options);
        }
        return NoopMeter.INSTANCE;
    }

    static {
        LOGGER = new ClientLogger(DefaultMeterProvider.class);
        NOOP_CLOSEABLE = () -> {};
        ServiceLoader<MeterProvider> serviceLoader = ServiceLoader.load(MeterProvider.class, MeterProvider.class.getClassLoader());
        Iterator<MeterProvider> iterator = serviceLoader.iterator();
        if (iterator.hasNext()) {
            meterProvider = iterator.next();
            if (iterator.hasNext()) {
                String allProviders = StreamSupport.stream(serviceLoader.spliterator(), false).map(p -> p.getClass().getName()).collect(Collectors.joining(", "));
                String message = String.format("Expected only one MeterProvider on the classpath, but found multiple providers: %s. Please pick one MeterProvider implementation and remove or exclude packages that bring other implementations", allProviders);
                ERROR = new IllegalStateException(message);
                LOGGER.error(message);
            } else {
                ERROR = null;
                LOGGER.info("Found MeterProvider implementation on the classpath: {}", meterProvider.getClass().getName());
            }
        } else {
            ERROR = null;
        }
        NOOP_GAUGE = new LongGauge(){

            @Override
            public AutoCloseable registerCallback(Supplier<Long> valueSupplier, TelemetryAttributes attributes) {
                return NOOP_CLOSEABLE;
            }

            @Override
            public boolean isEnabled() {
                return false;
            }
        };
    }
}

