/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Base64Util;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockFromUrlHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsAppendBlockHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.AppendBlobsSealHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.EncryptionAlgorithmType;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AppendBlobsImpl {
    private final AppendBlobsService service;
    private final AzureBlobStorageImpl client;

    AppendBlobsImpl(AzureBlobStorageImpl client) {
        this.service = RestProxy.create(AppendBlobsService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsCreateHeaders, Void>> createWithResponseAsync(String containerName, String blob, long contentLength, Integer timeout, Map<String, String> metadata, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, String blobTagsString, OffsetDateTime immutabilityPolicyExpiry, BlobImmutabilityPolicyMode immutabilityPolicyMode, Boolean legalHold, BlobHttpHeaders blobHttpHeaders, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String blobType = "AppendBlob";
        String accept = "application/xml";
        String contentTypeInternal = null;
        if (blobHttpHeaders != null) {
            contentTypeInternal = blobHttpHeaders.getContentType();
        }
        String contentType = contentTypeInternal;
        String contentEncodingInternal = null;
        if (blobHttpHeaders != null) {
            contentEncodingInternal = blobHttpHeaders.getContentEncoding();
        }
        String contentEncoding = contentEncodingInternal;
        String contentLanguageInternal = null;
        if (blobHttpHeaders != null) {
            contentLanguageInternal = blobHttpHeaders.getContentLanguage();
        }
        String contentLanguage = contentLanguageInternal;
        byte[] contentMd5Internal = null;
        if (blobHttpHeaders != null) {
            contentMd5Internal = blobHttpHeaders.getContentMd5();
        }
        byte[] contentMd5 = contentMd5Internal;
        String cacheControlInternal = null;
        if (blobHttpHeaders != null) {
            cacheControlInternal = blobHttpHeaders.getCacheControl();
        }
        String cacheControl = cacheControlInternal;
        String contentDispositionInternal = null;
        if (blobHttpHeaders != null) {
            contentDispositionInternal = blobHttpHeaders.getContentDisposition();
        }
        String contentDisposition = contentDispositionInternal;
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String contentMd5Converted = Base64Util.encodeToString(contentMd5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 immutabilityPolicyExpiryConverted = immutabilityPolicyExpiry == null ? null : new DateTimeRfc1123(immutabilityPolicyExpiry);
        return this.service.create(this.client.getUrl(), containerName, blob, "AppendBlob", timeout, contentLength, contentType, contentEncoding, contentLanguage, contentMd5Converted, cacheControl, metadata, leaseId, contentDisposition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, blobTagsString, immutabilityPolicyExpiryConverted, immutabilityPolicyMode, legalHold, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlockWithResponseAsync(String containerName, String blob, long contentLength, Flux<ByteBuffer> body, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "appendblock";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.appendBlock(this.client.getUrl(), containerName, blob, "appendblock", timeout, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlockWithResponseAsync(String containerName, String blob, long contentLength, BinaryData body, Integer timeout, byte[] transactionalContentMD5, byte[] transactionalContentCrc64, String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, String requestId, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "appendblock";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        String transactionalContentCrc64Converted = Base64Util.encodeToString(transactionalContentCrc64);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.appendBlock(this.client.getUrl(), containerName, blob, "appendblock", timeout, contentLength, transactionalContentMD5Converted, transactionalContentCrc64Converted, leaseId, maxSize, appendPosition, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, this.client.getVersion(), requestId, body, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsAppendBlockFromUrlHeaders, Void>> appendBlockFromUrlWithResponseAsync(String containerName, String blob, String sourceUrl, long contentLength, String sourceRange, byte[] sourceContentMD5, byte[] sourceContentcrc64, Integer timeout, byte[] transactionalContentMD5, String leaseId, Long maxSize, Long appendPosition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, String ifTags, OffsetDateTime sourceIfModifiedSince, OffsetDateTime sourceIfUnmodifiedSince, String sourceIfMatch, String sourceIfNoneMatch, String requestId, String copySourceAuthorization, CpkInfo cpkInfo, EncryptionScope encryptionScopeParam, Context context) {
        String comp = "appendblock";
        String accept = "application/xml";
        String encryptionKeyInternal = null;
        if (cpkInfo != null) {
            encryptionKeyInternal = cpkInfo.getEncryptionKey();
        }
        String encryptionKey = encryptionKeyInternal;
        String encryptionKeySha256Internal = null;
        if (cpkInfo != null) {
            encryptionKeySha256Internal = cpkInfo.getEncryptionKeySha256();
        }
        String encryptionKeySha256 = encryptionKeySha256Internal;
        EncryptionAlgorithmType encryptionAlgorithmInternal = null;
        if (cpkInfo != null) {
            encryptionAlgorithmInternal = cpkInfo.getEncryptionAlgorithm();
        }
        EncryptionAlgorithmType encryptionAlgorithm = encryptionAlgorithmInternal;
        String encryptionScopeInternal = null;
        if (encryptionScopeParam != null) {
            encryptionScopeInternal = encryptionScopeParam.getEncryptionScope();
        }
        String encryptionScope = encryptionScopeInternal;
        String sourceContentMD5Converted = Base64Util.encodeToString(sourceContentMD5);
        String sourceContentcrc64Converted = Base64Util.encodeToString(sourceContentcrc64);
        String transactionalContentMD5Converted = Base64Util.encodeToString(transactionalContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        DateTimeRfc1123 sourceIfModifiedSinceConverted = sourceIfModifiedSince == null ? null : new DateTimeRfc1123(sourceIfModifiedSince);
        DateTimeRfc1123 sourceIfUnmodifiedSinceConverted = sourceIfUnmodifiedSince == null ? null : new DateTimeRfc1123(sourceIfUnmodifiedSince);
        return this.service.appendBlockFromUrl(this.client.getUrl(), containerName, blob, "appendblock", sourceUrl, sourceRange, sourceContentMD5Converted, sourceContentcrc64Converted, timeout, contentLength, transactionalContentMD5Converted, encryptionKey, encryptionKeySha256, encryptionAlgorithm, encryptionScope, leaseId, maxSize, appendPosition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, ifTags, sourceIfModifiedSinceConverted, sourceIfUnmodifiedSinceConverted, sourceIfMatch, sourceIfNoneMatch, this.client.getVersion(), requestId, copySourceAuthorization, "application/xml", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ResponseBase<AppendBlobsSealHeaders, Void>> sealWithResponseAsync(String containerName, String blob, Integer timeout, String requestId, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatch, String ifNoneMatch, Long appendPosition, Context context) {
        String comp = "seal";
        String accept = "application/xml";
        DateTimeRfc1123 ifModifiedSinceConverted = ifModifiedSince == null ? null : new DateTimeRfc1123(ifModifiedSince);
        DateTimeRfc1123 ifUnmodifiedSinceConverted = ifUnmodifiedSince == null ? null : new DateTimeRfc1123(ifUnmodifiedSince);
        return this.service.seal(this.client.getUrl(), containerName, blob, "seal", timeout, this.client.getVersion(), requestId, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatch, ifNoneMatch, appendPosition, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureBlobStorageAppe")
    public static interface AppendBlobsService {
        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<AppendBlobsCreateHeaders, Void>> create(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @HeaderParam(value="x-ms-blob-type") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="x-ms-blob-content-type") String var8, @HeaderParam(value="x-ms-blob-content-encoding") String var9, @HeaderParam(value="x-ms-blob-content-language") String var10, @HeaderParam(value="x-ms-blob-content-md5") String var11, @HeaderParam(value="x-ms-blob-cache-control") String var12, @HeaderParam(value="x-ms-meta-") Map<String, String> var13, @HeaderParam(value="x-ms-lease-id") String var14, @HeaderParam(value="x-ms-blob-content-disposition") String var15, @HeaderParam(value="x-ms-encryption-key") String var16, @HeaderParam(value="x-ms-encryption-key-sha256") String var17, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var18, @HeaderParam(value="x-ms-encryption-scope") String var19, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var20, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Match") String var22, @HeaderParam(value="If-None-Match") String var23, @HeaderParam(value="x-ms-if-tags") String var24, @HeaderParam(value="x-ms-version") String var25, @HeaderParam(value="x-ms-client-request-id") String var26, @HeaderParam(value="x-ms-tags") String var27, @HeaderParam(value="x-ms-immutability-policy-until-date") DateTimeRfc1123 var28, @HeaderParam(value="x-ms-immutability-policy-mode") BlobImmutabilityPolicyMode var29, @HeaderParam(value="x-ms-legal-hold") Boolean var30, @HeaderParam(value="Accept") String var31, Context var32);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlock(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-blob-condition-maxsize") Long var11, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var12, @HeaderParam(value="x-ms-encryption-key") String var13, @HeaderParam(value="x-ms-encryption-key-sha256") String var14, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var15, @HeaderParam(value="x-ms-encryption-scope") String var16, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var17, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var18, @HeaderParam(value="If-Match") String var19, @HeaderParam(value="If-None-Match") String var20, @HeaderParam(value="x-ms-if-tags") String var21, @HeaderParam(value="x-ms-version") String var22, @HeaderParam(value="x-ms-client-request-id") String var23, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<AppendBlobsAppendBlockHeaders, Void>> appendBlock(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Content-MD5") String var8, @HeaderParam(value="x-ms-content-crc64") String var9, @HeaderParam(value="x-ms-lease-id") String var10, @HeaderParam(value="x-ms-blob-condition-maxsize") Long var11, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var12, @HeaderParam(value="x-ms-encryption-key") String var13, @HeaderParam(value="x-ms-encryption-key-sha256") String var14, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var15, @HeaderParam(value="x-ms-encryption-scope") String var16, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var17, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var18, @HeaderParam(value="If-Match") String var19, @HeaderParam(value="If-None-Match") String var20, @HeaderParam(value="x-ms-if-tags") String var21, @HeaderParam(value="x-ms-version") String var22, @HeaderParam(value="x-ms-client-request-id") String var23, @BodyParam(value="application/octet-stream") BinaryData var24, @HeaderParam(value="Accept") String var25, Context var26);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<AppendBlobsAppendBlockFromUrlHeaders, Void>> appendBlockFromUrl(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @HeaderParam(value="x-ms-copy-source") String var5, @HeaderParam(value="x-ms-source-range") String var6, @HeaderParam(value="x-ms-source-content-md5") String var7, @HeaderParam(value="x-ms-source-content-crc64") String var8, @QueryParam(value="timeout") Integer var9, @HeaderParam(value="Content-Length") long var10, @HeaderParam(value="Content-MD5") String var12, @HeaderParam(value="x-ms-encryption-key") String var13, @HeaderParam(value="x-ms-encryption-key-sha256") String var14, @HeaderParam(value="x-ms-encryption-algorithm") EncryptionAlgorithmType var15, @HeaderParam(value="x-ms-encryption-scope") String var16, @HeaderParam(value="x-ms-lease-id") String var17, @HeaderParam(value="x-ms-blob-condition-maxsize") Long var18, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var19, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var20, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var21, @HeaderParam(value="If-Match") String var22, @HeaderParam(value="If-None-Match") String var23, @HeaderParam(value="x-ms-if-tags") String var24, @HeaderParam(value="x-ms-source-if-modified-since") DateTimeRfc1123 var25, @HeaderParam(value="x-ms-source-if-unmodified-since") DateTimeRfc1123 var26, @HeaderParam(value="x-ms-source-if-match") String var27, @HeaderParam(value="x-ms-source-if-none-match") String var28, @HeaderParam(value="x-ms-version") String var29, @HeaderParam(value="x-ms-client-request-id") String var30, @HeaderParam(value="x-ms-copy-source-authorization") String var31, @HeaderParam(value="Accept") String var32, Context var33);

        @Put(value="/{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=BlobStorageException.class)
        public Mono<ResponseBase<AppendBlobsSealHeaders, Void>> seal(@HostParam(value="url") String var1, @PathParam(value="containerName") String var2, @PathParam(value="blob") String var3, @QueryParam(value="comp") String var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @HeaderParam(value="x-ms-lease-id") String var8, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var9, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Match") String var11, @HeaderParam(value="If-None-Match") String var12, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var13, @HeaderParam(value="Accept") String var14, Context var15);
    }
}

