/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

@JacksonXmlRootElement(localName="null")
public final class BlobsQueryHeaders {
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType xMsLeaseStatus;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType xMsLeaseState;
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String xMsEncryptionKeySha256;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType xMsBlobType;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="x-ms-copy-status-description")
    private String xMsCopyStatusDescription;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType xMsLeaseDuration;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-copy-id")
    private String xMsCopyId;
    @JsonProperty(value="x-ms-copy-source")
    private String xMsCopySource;
    @JsonProperty(value="x-ms-content-crc64")
    private byte[] xMsContentCrc64;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long xMsBlobSequenceNumber;
    @JsonProperty(value="x-ms-copy-progress")
    private String xMsCopyProgress;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer xMsBlobCommittedBlockCount;
    @JsonProperty(value="x-ms-blob-content-md5")
    private byte[] xMsBlobContentMd5;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> xMsMeta;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMD5;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 xMsCopyCompletionTime;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean xMsServerEncrypted;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType xMsCopyStatus;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="x-ms-encryption-scope")
    private String xMsEncryptionScope;

    public BlobsQueryHeaders(HttpHeaders rawHeaders) {
        if (rawHeaders.getValue("x-ms-lease-status") != null) {
            this.xMsLeaseStatus = LeaseStatusType.fromString(rawHeaders.getValue("x-ms-lease-status"));
        }
        this.contentRange = rawHeaders.getValue("Content-Range");
        if (rawHeaders.getValue("x-ms-lease-state") != null) {
            this.xMsLeaseState = LeaseStateType.fromString(rawHeaders.getValue("x-ms-lease-state"));
        }
        if (rawHeaders.getValue("Last-Modified") != null) {
            this.lastModified = new DateTimeRfc1123(rawHeaders.getValue("Last-Modified"));
        }
        this.xMsEncryptionKeySha256 = rawHeaders.getValue("x-ms-encryption-key-sha256");
        if (rawHeaders.getValue("x-ms-blob-type") != null) {
            this.xMsBlobType = BlobType.fromString(rawHeaders.getValue("x-ms-blob-type"));
        }
        this.contentEncoding = rawHeaders.getValue("Content-Encoding");
        this.xMsCopyStatusDescription = rawHeaders.getValue("x-ms-copy-status-description");
        if (rawHeaders.getValue("x-ms-lease-duration") != null) {
            this.xMsLeaseDuration = LeaseDurationType.fromString(rawHeaders.getValue("x-ms-lease-duration"));
        }
        if (rawHeaders.getValue("Content-Length") != null) {
            this.contentLength = Long.parseLong(rawHeaders.getValue("Content-Length"));
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.contentType = rawHeaders.getValue("Content-Type");
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.xMsCopyId = rawHeaders.getValue("x-ms-copy-id");
        this.xMsCopySource = rawHeaders.getValue("x-ms-copy-source");
        if (rawHeaders.getValue("x-ms-content-crc64") != null) {
            this.xMsContentCrc64 = Base64.getDecoder().decode(rawHeaders.getValue("x-ms-content-crc64"));
        }
        if (rawHeaders.getValue("x-ms-blob-sequence-number") != null) {
            this.xMsBlobSequenceNumber = Long.parseLong(rawHeaders.getValue("x-ms-blob-sequence-number"));
        }
        this.xMsCopyProgress = rawHeaders.getValue("x-ms-copy-progress");
        if (rawHeaders.getValue("x-ms-blob-committed-block-count") != null) {
            this.xMsBlobCommittedBlockCount = Integer.parseInt(rawHeaders.getValue("x-ms-blob-committed-block-count"));
        }
        if (rawHeaders.getValue("x-ms-blob-content-md5") != null) {
            this.xMsBlobContentMd5 = Base64.getDecoder().decode(rawHeaders.getValue("x-ms-blob-content-md5"));
        }
        HashMap<String, String> xMsMetaHeaderCollection = new HashMap<String, String>();
        for (HttpHeader header : rawHeaders) {
            if (!header.getName().startsWith("x-ms-meta-")) continue;
            xMsMetaHeaderCollection.put(header.getName().substring(10), header.getValue());
        }
        this.xMsMeta = xMsMetaHeaderCollection;
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
        if (rawHeaders.getValue("Content-MD5") != null) {
            this.contentMD5 = Base64.getDecoder().decode(rawHeaders.getValue("Content-MD5"));
        }
        if (rawHeaders.getValue("x-ms-copy-completion-time") != null) {
            this.xMsCopyCompletionTime = new DateTimeRfc1123(rawHeaders.getValue("x-ms-copy-completion-time"));
        }
        this.acceptRanges = rawHeaders.getValue("Accept-Ranges");
        if (rawHeaders.getValue("x-ms-server-encrypted") != null) {
            this.xMsServerEncrypted = Boolean.parseBoolean(rawHeaders.getValue("x-ms-server-encrypted"));
        }
        this.cacheControl = rawHeaders.getValue("Cache-Control");
        this.eTag = rawHeaders.getValue("ETag");
        this.contentDisposition = rawHeaders.getValue("Content-Disposition");
        if (rawHeaders.getValue("x-ms-copy-status") != null) {
            this.xMsCopyStatus = CopyStatusType.fromString(rawHeaders.getValue("x-ms-copy-status"));
        }
        this.contentLanguage = rawHeaders.getValue("Content-Language");
        this.xMsClientRequestId = rawHeaders.getValue("x-ms-client-request-id");
        this.xMsEncryptionScope = rawHeaders.getValue("x-ms-encryption-scope");
    }

    public LeaseStatusType getXMsLeaseStatus() {
        return this.xMsLeaseStatus;
    }

    public BlobsQueryHeaders setXMsLeaseStatus(LeaseStatusType xMsLeaseStatus) {
        this.xMsLeaseStatus = xMsLeaseStatus;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public BlobsQueryHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public LeaseStateType getXMsLeaseState() {
        return this.xMsLeaseState;
    }

    public BlobsQueryHeaders setXMsLeaseState(LeaseStateType xMsLeaseState) {
        this.xMsLeaseState = xMsLeaseState;
        return this;
    }

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobsQueryHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public String getXMsEncryptionKeySha256() {
        return this.xMsEncryptionKeySha256;
    }

    public BlobsQueryHeaders setXMsEncryptionKeySha256(String xMsEncryptionKeySha256) {
        this.xMsEncryptionKeySha256 = xMsEncryptionKeySha256;
        return this;
    }

    public BlobType getXMsBlobType() {
        return this.xMsBlobType;
    }

    public BlobsQueryHeaders setXMsBlobType(BlobType xMsBlobType) {
        this.xMsBlobType = xMsBlobType;
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobsQueryHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getXMsCopyStatusDescription() {
        return this.xMsCopyStatusDescription;
    }

    public BlobsQueryHeaders setXMsCopyStatusDescription(String xMsCopyStatusDescription) {
        this.xMsCopyStatusDescription = xMsCopyStatusDescription;
        return this;
    }

    public LeaseDurationType getXMsLeaseDuration() {
        return this.xMsLeaseDuration;
    }

    public BlobsQueryHeaders setXMsLeaseDuration(LeaseDurationType xMsLeaseDuration) {
        this.xMsLeaseDuration = xMsLeaseDuration;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobsQueryHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsQueryHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobsQueryHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsQueryHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsCopyId() {
        return this.xMsCopyId;
    }

    public BlobsQueryHeaders setXMsCopyId(String xMsCopyId) {
        this.xMsCopyId = xMsCopyId;
        return this;
    }

    public String getXMsCopySource() {
        return this.xMsCopySource;
    }

    public BlobsQueryHeaders setXMsCopySource(String xMsCopySource) {
        this.xMsCopySource = xMsCopySource;
        return this;
    }

    public byte[] getXMsContentCrc64() {
        return CoreUtils.clone(this.xMsContentCrc64);
    }

    public BlobsQueryHeaders setXMsContentCrc64(byte[] xMsContentCrc64) {
        this.xMsContentCrc64 = CoreUtils.clone(xMsContentCrc64);
        return this;
    }

    public Long getXMsBlobSequenceNumber() {
        return this.xMsBlobSequenceNumber;
    }

    public BlobsQueryHeaders setXMsBlobSequenceNumber(Long xMsBlobSequenceNumber) {
        this.xMsBlobSequenceNumber = xMsBlobSequenceNumber;
        return this;
    }

    public String getXMsCopyProgress() {
        return this.xMsCopyProgress;
    }

    public BlobsQueryHeaders setXMsCopyProgress(String xMsCopyProgress) {
        this.xMsCopyProgress = xMsCopyProgress;
        return this;
    }

    public Integer getXMsBlobCommittedBlockCount() {
        return this.xMsBlobCommittedBlockCount;
    }

    public BlobsQueryHeaders setXMsBlobCommittedBlockCount(Integer xMsBlobCommittedBlockCount) {
        this.xMsBlobCommittedBlockCount = xMsBlobCommittedBlockCount;
        return this;
    }

    public byte[] getXMsBlobContentMd5() {
        return CoreUtils.clone(this.xMsBlobContentMd5);
    }

    public BlobsQueryHeaders setXMsBlobContentMd5(byte[] xMsBlobContentMd5) {
        this.xMsBlobContentMd5 = CoreUtils.clone(xMsBlobContentMd5);
        return this;
    }

    public Map<String, String> getXMsMeta() {
        return this.xMsMeta;
    }

    public BlobsQueryHeaders setXMsMeta(Map<String, String> xMsMeta) {
        this.xMsMeta = xMsMeta;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public BlobsQueryHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public byte[] getContentMD5() {
        return CoreUtils.clone(this.contentMD5);
    }

    public BlobsQueryHeaders setContentMD5(byte[] contentMD5) {
        this.contentMD5 = CoreUtils.clone(contentMD5);
        return this;
    }

    public OffsetDateTime getXMsCopyCompletionTime() {
        if (this.xMsCopyCompletionTime == null) {
            return null;
        }
        return this.xMsCopyCompletionTime.getDateTime();
    }

    public BlobsQueryHeaders setXMsCopyCompletionTime(OffsetDateTime xMsCopyCompletionTime) {
        this.xMsCopyCompletionTime = xMsCopyCompletionTime == null ? null : new DateTimeRfc1123(xMsCopyCompletionTime);
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public BlobsQueryHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public Boolean isXMsServerEncrypted() {
        return this.xMsServerEncrypted;
    }

    public BlobsQueryHeaders setXMsServerEncrypted(Boolean xMsServerEncrypted) {
        this.xMsServerEncrypted = xMsServerEncrypted;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobsQueryHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobsQueryHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobsQueryHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public CopyStatusType getXMsCopyStatus() {
        return this.xMsCopyStatus;
    }

    public BlobsQueryHeaders setXMsCopyStatus(CopyStatusType xMsCopyStatus) {
        this.xMsCopyStatus = xMsCopyStatus;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobsQueryHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsQueryHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public String getXMsEncryptionScope() {
        return this.xMsEncryptionScope;
    }

    public BlobsQueryHeaders setXMsEncryptionScope(String xMsEncryptionScope) {
        this.xMsEncryptionScope = xMsEncryptionScope;
        return this;
    }
}

