/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobImmutabilityPolicyMode;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

@JacksonXmlRootElement(localName="null")
public final class BlobsSetImmutabilityPolicyHeaders {
    @JsonProperty(value="x-ms-immutability-policy-mode")
    private BlobImmutabilityPolicyMode xMsImmutabilityPolicyMode;
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-immutability-policy-until-date")
    private DateTimeRfc1123 xMsImmutabilityPolicyUntilDate;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;

    public BlobsSetImmutabilityPolicyHeaders(HttpHeaders rawHeaders) {
        if (rawHeaders.getValue("x-ms-immutability-policy-mode") != null) {
            this.xMsImmutabilityPolicyMode = BlobImmutabilityPolicyMode.fromString(rawHeaders.getValue("x-ms-immutability-policy-mode"));
        }
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        if (rawHeaders.getValue("x-ms-immutability-policy-until-date") != null) {
            this.xMsImmutabilityPolicyUntilDate = new DateTimeRfc1123(rawHeaders.getValue("x-ms-immutability-policy-until-date"));
        }
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsClientRequestId = rawHeaders.getValue("x-ms-client-request-id");
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
    }

    public BlobImmutabilityPolicyMode getXMsImmutabilityPolicyMode() {
        return this.xMsImmutabilityPolicyMode;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsImmutabilityPolicyMode(BlobImmutabilityPolicyMode xMsImmutabilityPolicyMode) {
        this.xMsImmutabilityPolicyMode = xMsImmutabilityPolicyMode;
        return this;
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public OffsetDateTime getXMsImmutabilityPolicyUntilDate() {
        if (this.xMsImmutabilityPolicyUntilDate == null) {
            return null;
        }
        return this.xMsImmutabilityPolicyUntilDate.getDateTime();
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsImmutabilityPolicyUntilDate(OffsetDateTime xMsImmutabilityPolicyUntilDate) {
        this.xMsImmutabilityPolicyUntilDate = xMsImmutabilityPolicyUntilDate == null ? null : new DateTimeRfc1123(xMsImmutabilityPolicyUntilDate);
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public BlobsSetImmutabilityPolicyHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public BlobsSetImmutabilityPolicyHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }
}

