/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.io.IOUtils;
import com.azure.storage.blob.implementation.accesshelpers.BlobDownloadAsyncResponseConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobsDownloadHeaders;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.DownloadRetryOptions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.util.Objects;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BlobDownloadAsyncResponse
extends ResponseBase<BlobDownloadHeaders, Flux<ByteBuffer>>
implements Closeable {
    private static final Mono<ByteBuffer> EMPTY_BUFFER_MONO;
    private final StreamResponse sourceResponse;
    private final BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume;
    private final DownloadRetryOptions retryOptions;

    public BlobDownloadAsyncResponse(HttpRequest request, int statusCode, HttpHeaders headers, Flux<ByteBuffer> value, BlobDownloadHeaders deserializedHeaders) {
        super(request, statusCode, headers, value, deserializedHeaders);
        this.sourceResponse = null;
        this.onErrorResume = null;
        this.retryOptions = null;
    }

    BlobDownloadAsyncResponse(StreamResponse sourceResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume2, DownloadRetryOptions retryOptions) {
        super(sourceResponse.getRequest(), sourceResponse.getStatusCode(), sourceResponse.getHeaders(), BlobDownloadAsyncResponse.createResponseFlux(sourceResponse, onErrorResume2, retryOptions), BlobDownloadAsyncResponse.extractHeaders(sourceResponse));
        this.sourceResponse = Objects.requireNonNull(sourceResponse, "'sourceResponse' must not be null");
        this.onErrorResume = Objects.requireNonNull(onErrorResume2, "'onErrorResume' must not be null");
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' must not be null");
    }

    private static BlobDownloadHeaders extractHeaders(StreamResponse response) {
        BlobsDownloadHeaders blobsDownloadHeaders = ModelHelper.transformBlobDownloadHeaders(response.getHeaders());
        return ModelHelper.populateBlobDownloadHeaders(blobsDownloadHeaders, ModelHelper.getErrorCode(response.getHeaders()));
    }

    private static Flux<ByteBuffer> createResponseFlux(StreamResponse sourceResponse, BiFunction<Throwable, Long, Mono<StreamResponse>> onErrorResume2, DownloadRetryOptions retryOptions) {
        return FluxUtil.createRetriableDownloadFlux(sourceResponse::getValue, (throwable, position) -> ((Mono)onErrorResume2.apply((Throwable)throwable, (Long)position)).flatMapMany(StreamResponse::getValue), retryOptions.getMaxRetryRequests()).switchIfEmpty(EMPTY_BUFFER_MONO);
    }

    public Mono<Void> writeValueToAsync(AsynchronousByteChannel channel, ProgressReporter progressReporter) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        if (this.sourceResponse != null) {
            return IOUtils.transferStreamResponseToAsynchronousByteChannel(channel, this.sourceResponse, this.onErrorResume, progressReporter, this.retryOptions.getMaxRetryRequests());
        }
        if (super.getValue() != null) {
            return FluxUtil.writeToAsynchronousByteChannel(FluxUtil.addProgressReporting((Flux)super.getValue(), progressReporter), channel);
        }
        return Mono.empty();
    }

    @Override
    public void close() throws IOException {
        if (this.sourceResponse != null) {
            this.sourceResponse.close();
        } else {
            ((Flux)super.getValue()).subscribe().dispose();
        }
    }

    static {
        BlobDownloadAsyncResponseConstructorProxy.setAccessor(BlobDownloadAsyncResponse::new);
        EMPTY_BUFFER_MONO = Mono.just(ByteBuffer.allocate(0));
    }
}

