/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.AppendBlobRequestConditions;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.options.AppendBlobAppendBlockFromUrlOptions;
import com.azure.storage.blob.options.AppendBlobCreateOptions;
import com.azure.storage.blob.options.AppendBlobSealOptions;
import com.azure.storage.blob.specialized.AppendBlobAsyncClient;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

@ServiceClient(builder=SpecializedBlobClientBuilder.class)
public final class AppendBlobClient
extends BlobClientBase {
    private final AppendBlobAsyncClient appendBlobAsyncClient;
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    AppendBlobClient(AppendBlobAsyncClient appendBlobAsyncClient) {
        super(appendBlobAsyncClient);
        this.appendBlobAsyncClient = appendBlobAsyncClient;
    }

    @Override
    public AppendBlobClient getEncryptionScopeClient(String encryptionScope) {
        return new AppendBlobClient(this.appendBlobAsyncClient.getEncryptionScopeAsyncClient(encryptionScope));
    }

    @Override
    public AppendBlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        return new AppendBlobClient(this.appendBlobAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey));
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(null);
    }

    public BlobOutputStream getBlobOutputStream(AppendBlobRequestConditions requestConditions) {
        return BlobOutputStream.appendBlobOutputStream(this.appendBlobAsyncClient, requestConditions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem create() {
        return this.create(false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem create(boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.createWithResponse(null, null, blobRequestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> createWithResponse(BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return this.createWithResponse(new AppendBlobCreateOptions().setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> createWithResponse(AppendBlobCreateOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.appendBlobAsyncClient.createWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem createIfNotExists() {
        return this.createIfNotExistsWithResponse(new AppendBlobCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> createIfNotExistsWithResponse(AppendBlobCreateOptions options, Duration timeout, Context context) {
        return StorageImplUtils.blockWithOptionalTimeout(this.appendBlobAsyncClient.createIfNotExistsWithResponse(options, context), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem appendBlock(InputStream data, long length) {
        return this.appendBlockWithResponse(data, length, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> appendBlockWithResponse(InputStream data, long length, byte[] contentMd5, AppendBlobRequestConditions appendBlobRequestConditions, Duration timeout, Context context) {
        Objects.requireNonNull(data, "'data' cannot be null.");
        Flux<ByteBuffer> fbb = Utility.convertStreamToByteBuffer(data, length, 0x400000, true);
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlockWithResponse(fbb.subscribeOn(Schedulers.boundedElastic()), length, contentMd5, appendBlobRequestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem appendBlockFromUrl(String sourceUrl, BlobRange sourceRange) {
        return this.appendBlockFromUrlWithResponse(sourceUrl, sourceRange, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> appendBlockFromUrlWithResponse(String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, AppendBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions, Duration timeout, Context context) {
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlockFromUrlWithResponse(new AppendBlobAppendBlockFromUrlOptions(sourceUrl).setSourceRange(sourceRange).setSourceContentMd5(sourceContentMd5).setDestinationRequestConditions(destRequestConditions).setSourceRequestConditions(sourceRequestConditions), context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> appendBlockFromUrlWithResponse(AppendBlobAppendBlockFromUrlOptions options, Duration timeout, Context context) {
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlockFromUrlWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void seal() {
        this.sealWithResponse(new AppendBlobSealOptions(), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sealWithResponse(AppendBlobSealOptions options, Duration timeout, Context context) {
        Mono<Response<Void>> response = this.appendBlobAsyncClient.sealWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }
}

