/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRange;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.models.PageBlobsClearPagesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCopyIncrementalHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesDiffHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsGetPageRangesHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsResizeHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUpdateSequenceNumberHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesFromURLHeaders;
import com.azure.storage.blob.implementation.models.PageBlobsUploadPagesHeaders;
import com.azure.storage.blob.implementation.models.PageListHelper;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.ClearRange;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.models.PageBlobCopyIncrementalRequestConditions;
import com.azure.storage.blob.models.PageBlobItem;
import com.azure.storage.blob.models.PageBlobRequestConditions;
import com.azure.storage.blob.models.PageList;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.PageRangeItem;
import com.azure.storage.blob.models.SequenceNumberActionType;
import com.azure.storage.blob.options.ListPageRangesDiffOptions;
import com.azure.storage.blob.options.ListPageRangesOptions;
import com.azure.storage.blob.options.PageBlobCopyIncrementalOptions;
import com.azure.storage.blob.options.PageBlobCreateOptions;
import com.azure.storage.blob.options.PageBlobUploadPagesFromUrlOptions;
import com.azure.storage.blob.specialized.BlobAsyncClientBase;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SpecializedBlobClientBuilder.class, isAsync=true)
public final class PageBlobAsyncClient
extends BlobAsyncClientBase {
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;
    private static final ClientLogger LOGGER = new ClientLogger(PageBlobAsyncClient.class);

    PageBlobAsyncClient(HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
    }

    @Override
    public PageBlobAsyncClient getEncryptionScopeAsyncClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new PageBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public PageBlobAsyncClient getCustomerProvidedKeyAsyncClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new PageBlobAsyncClient(this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    private static String pageRangeToString(PageRange pageRange) {
        if (pageRange.getStart() < 0L || pageRange.getEnd() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.getStart() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.getEnd() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.getEnd() <= pageRange.getStart()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.getStart() + '-' + pageRange.getEnd();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> create(long size) {
        return this.create(size, false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> create(long size, boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.createWithResponse(size, null, null, null, blobRequestConditions).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> createWithResponse(long size, Long sequenceNumber, BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions) {
        return this.createWithResponse(new PageBlobCreateOptions(size).setSequenceNumber(sequenceNumber).setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> createWithResponse(PageBlobCreateOptions options) {
        try {
            return FluxUtil.withContext(context -> this.createWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageBlobItem>> createWithResponse(PageBlobCreateOptions options, Context context) {
        BlobRequestConditions requestConditions;
        StorageImplUtils.assertNotNull("options", options);
        BlobRequestConditions blobRequestConditions = requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        if (options.getSize() % 512L != 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        if (options.getSequenceNumber() != null && options.getSequenceNumber() < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        context = context == null ? Context.NONE : context;
        BlobImmutabilityPolicy immutabilityPolicy = options.getImmutabilityPolicy() == null ? new BlobImmutabilityPolicy() : options.getImmutabilityPolicy();
        return this.azureBlobStorage.getPageBlobs().createWithResponseAsync(this.containerName, this.blobName, 0L, options.getSize(), null, null, options.getMetadata(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), options.getSequenceNumber(), null, this.tagsToString(options.getTags()), immutabilityPolicy.getExpiryTime(), immutabilityPolicy.getPolicyMode(), options.isLegalHold(), options.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            PageBlobsCreateHeaders hd = (PageBlobsCreateHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), null, hd.getXMsVersionId());
            return new SimpleResponse<PageBlobItem>((Response<?>)rb, item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> createIfNotExists(long size) {
        return this.createIfNotExistsWithResponse(new PageBlobCreateOptions(size)).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> createIfNotExistsWithResponse(PageBlobCreateOptions options) {
        try {
            return this.createIfNotExistsWithResponse(options, null);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageBlobItem>> createIfNotExistsWithResponse(PageBlobCreateOptions options, Context context) {
        try {
            options.setRequestConditions(new BlobRequestConditions().setIfNoneMatch("*").setIfNoneMatch("*"));
            return this.createWithResponse(options, context).onErrorResume(t -> t instanceof BlobStorageException && ((BlobStorageException)t).getStatusCode() == 409, t -> {
                HttpResponse response = ((BlobStorageException)t).getResponse();
                return Mono.just(new SimpleResponse<Object>(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> uploadPages(PageRange pageRange, Flux<ByteBuffer> body) {
        return this.uploadPagesWithResponse(pageRange, body, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> uploadPagesWithResponse(PageRange pageRange, Flux<ByteBuffer> body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.uploadPagesWithResponse(pageRange, body, contentMd5, pageBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageBlobItem>> uploadPagesWithResponse(PageRange pageRange, Flux<ByteBuffer> body, byte[] contentMd5, PageBlobRequestConditions pageBlobRequestConditions, Context context) {
        PageBlobRequestConditions pageBlobRequestConditions2 = pageBlobRequestConditions = pageBlobRequestConditions == null ? new PageBlobRequestConditions() : pageBlobRequestConditions;
        if (pageRange == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("pageRange cannot be null."));
        }
        String pageRangeStr = PageBlobAsyncClient.pageRangeToString(pageRange);
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().uploadPagesWithResponseAsync(this.containerName, this.blobName, pageRange.getEnd() - pageRange.getStart() + 1L, body, contentMd5, null, null, pageRangeStr, pageBlobRequestConditions.getLeaseId(), pageBlobRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), pageBlobRequestConditions.getIfSequenceNumberLessThan(), pageBlobRequestConditions.getIfSequenceNumberEqualTo(), pageBlobRequestConditions.getIfModifiedSince(), pageBlobRequestConditions.getIfUnmodifiedSince(), pageBlobRequestConditions.getIfMatch(), pageBlobRequestConditions.getIfNoneMatch(), pageBlobRequestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            PageBlobsUploadPagesHeaders hd = (PageBlobsUploadPagesHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), hd.getXMsBlobSequenceNumber());
            return new SimpleResponse<PageBlobItem>((Response<?>)rb, item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> uploadPagesFromUrl(PageRange range, String sourceUrl, Long sourceOffset) {
        return this.uploadPagesFromUrlWithResponse(range, sourceUrl, sourceOffset, null, null, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> uploadPagesFromUrlWithResponse(PageRange range, String sourceUrl, Long sourceOffset, byte[] sourceContentMd5, PageBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions) {
        return this.uploadPagesFromUrlWithResponse(new PageBlobUploadPagesFromUrlOptions(range, sourceUrl).setSourceOffset(sourceOffset).setSourceContentMd5(sourceContentMd5).setDestinationRequestConditions(destRequestConditions).setSourceRequestConditions(sourceRequestConditions));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> uploadPagesFromUrlWithResponse(PageBlobUploadPagesFromUrlOptions options) {
        try {
            return FluxUtil.withContext(context -> this.uploadPagesFromUrlWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageBlobItem>> uploadPagesFromUrlWithResponse(PageBlobUploadPagesFromUrlOptions options, Context context) {
        if (options.getRange() == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("range cannot be null."));
        }
        String rangeString = PageBlobAsyncClient.pageRangeToString(options.getRange());
        long sourceOffset = options.getSourceOffset() == null ? 0L : options.getSourceOffset();
        String sourceRangeString = PageBlobAsyncClient.pageRangeToString(new PageRange().setStart(sourceOffset).setEnd(sourceOffset + (options.getRange().getEnd() - options.getRange().getStart())));
        PageBlobRequestConditions destRequestConditions = options.getDestinationRequestConditions() == null ? new PageBlobRequestConditions() : options.getDestinationRequestConditions();
        BlobRequestConditions sourceRequestConditions = options.getSourceRequestConditions() == null ? new BlobRequestConditions() : options.getSourceRequestConditions();
        try {
            new URL(options.getSourceUrl());
        }
        catch (MalformedURLException ex) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'sourceUrl' is not a valid url.", ex));
        }
        context = context == null ? Context.NONE : context;
        String sourceAuth = options.getSourceAuthorization() == null ? null : options.getSourceAuthorization().toString();
        return this.azureBlobStorage.getPageBlobs().uploadPagesFromURLWithResponseAsync(this.containerName, this.blobName, options.getSourceUrl(), sourceRangeString, 0L, rangeString, options.getSourceContentMd5(), null, null, destRequestConditions.getLeaseId(), destRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), destRequestConditions.getIfSequenceNumberLessThan(), destRequestConditions.getIfSequenceNumberEqualTo(), destRequestConditions.getIfModifiedSince(), destRequestConditions.getIfUnmodifiedSince(), destRequestConditions.getIfMatch(), destRequestConditions.getIfNoneMatch(), destRequestConditions.getTagsConditions(), sourceRequestConditions.getIfModifiedSince(), sourceRequestConditions.getIfUnmodifiedSince(), sourceRequestConditions.getIfMatch(), sourceRequestConditions.getIfNoneMatch(), null, sourceAuth, this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            PageBlobsUploadPagesFromURLHeaders hd = (PageBlobsUploadPagesFromURLHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), null);
            return new SimpleResponse<PageBlobItem>((Response<?>)rb, item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> clearPages(PageRange pageRange) {
        return this.clearPagesWithResponse(pageRange, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions) {
        try {
            return FluxUtil.withContext(context -> this.clearPagesWithResponse(pageRange, pageBlobRequestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageBlobItem>> clearPagesWithResponse(PageRange pageRange, PageBlobRequestConditions pageBlobRequestConditions, Context context) {
        PageBlobRequestConditions pageBlobRequestConditions2 = pageBlobRequestConditions = pageBlobRequestConditions == null ? new PageBlobRequestConditions() : pageBlobRequestConditions;
        if (pageRange == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("pageRange cannot be null."));
        }
        String pageRangeStr = PageBlobAsyncClient.pageRangeToString(pageRange);
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().clearPagesWithResponseAsync(this.containerName, this.blobName, 0L, null, pageRangeStr, pageBlobRequestConditions.getLeaseId(), pageBlobRequestConditions.getIfSequenceNumberLessThanOrEqualTo(), pageBlobRequestConditions.getIfSequenceNumberLessThan(), pageBlobRequestConditions.getIfSequenceNumberEqualTo(), pageBlobRequestConditions.getIfModifiedSince(), pageBlobRequestConditions.getIfUnmodifiedSince(), pageBlobRequestConditions.getIfMatch(), pageBlobRequestConditions.getIfNoneMatch(), pageBlobRequestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            PageBlobsClearPagesHeaders hd = (PageBlobsClearPagesHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), null, hd.getXMsBlobSequenceNumber());
            return new SimpleResponse<PageBlobItem>((Response<?>)rb, item);
        });
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageList> getPageRanges(BlobRange blobRange) {
        return this.getPageRangesWithResponse(blobRange, null).flatMap(FluxUtil::toMono);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesWithResponse(blobRange, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageList>> getPageRangesWithResponse(BlobRange blobRange, BlobRequestConditions requestConditions, Context context) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().getPageRangesWithResponseAsync(this.containerName, this.blobName, this.getSnapshotId(), null, blobRange.toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, null, null, context.addData("az.namespace", "Microsoft.Storage")).map(response -> new SimpleResponse<PageList>(response.getRequest(), response.getStatusCode(), response.getHeaders(), (PageList)response.getValue()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PageRangeItem> listPageRanges(BlobRange blobRange) {
        return this.listPageRanges(new ListPageRangesOptions(blobRange));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PageRangeItem> listPageRanges(ListPageRangesOptions options) {
        return new PagedFlux<PageRangeItem>(pageSize -> FluxUtil.withContext(context -> this.listPageRangesWithOptionalTimeout(options, null, (Context)context).apply((String)null, (Integer)pageSize)), (continuationToken, pageSize) -> FluxUtil.withContext(context -> this.listPageRangesWithOptionalTimeout(options, null, (Context)context).apply((String)continuationToken, (Integer)pageSize)));
    }

    BiFunction<String, Integer, Mono<PagedResponse<PageRangeItem>>> listPageRangesWithOptionalTimeout(ListPageRangesOptions options, Duration timeout, Context context) {
        return (marker, pageSize) -> {
            ListPageRangesOptions finalOptions = pageSize != null ? new ListPageRangesOptions(options.getRange()).setMaxResultsPerPage((Integer)pageSize) : options;
            return this.getPageRangesSegment((String)marker, finalOptions, timeout, context).map(response -> {
                List value = response.getValue() == null ? Collections.emptyList() : Stream.concat(((PageList)response.getValue()).getPageRange().stream().map(PageBlobAsyncClient::toPageBlobRange), ((PageList)response.getValue()).getClearRange().stream().map(PageBlobAsyncClient::toPageBlobRange)).collect(Collectors.toList());
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, PageListHelper.getNextMarker((PageList)response.getValue()), (PageBlobsGetPageRangesHeaders)response.getDeserializedHeaders());
            });
        };
    }

    private Mono<ResponseBase<PageBlobsGetPageRangesHeaders, PageList>> getPageRangesSegment(String marker, ListPageRangesOptions options, Duration timeout, Context context) {
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getPageBlobs().getPageRangesWithResponseAsync(this.containerName, this.blobName, this.getSnapshotId(), null, options.getRange().toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, marker, options.getMaxResultsPerPage(), context.addData("az.namespace", "Microsoft.Storage")), timeout);
    }

    private static PageRangeItem toPageBlobRange(PageRange range) {
        return new PageRangeItem(new HttpRange(range.getStart(), range.getEnd() - range.getStart() + 1L), false);
    }

    private static PageRangeItem toPageBlobRange(ClearRange range) {
        return new PageRangeItem(new HttpRange(range.getStart(), range.getEnd() - range.getStart() + 1L), true);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageList> getPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null).flatMap(FluxUtil::toMono);
    }

    @Deprecated
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageList>> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesDiffWithResponse(blobRange, prevSnapshot, null, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PageRangeItem> listPageRangesDiff(BlobRange blobRange, String prevSnapshot) {
        return this.listPageRangesDiff(new ListPageRangesDiffOptions(blobRange, prevSnapshot));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PageRangeItem> listPageRangesDiff(ListPageRangesDiffOptions options) {
        return new PagedFlux<PageRangeItem>(pageSize -> FluxUtil.withContext(context -> this.listPageRangesDiffWithOptionalTimeout(options, null, (Context)context).apply((String)null, (Integer)pageSize)), (continuationToken, pageSize) -> FluxUtil.withContext(context -> this.listPageRangesDiffWithOptionalTimeout(options, null, (Context)context).apply((String)continuationToken, (Integer)pageSize)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageList> getManagedDiskPageRangesDiff(BlobRange blobRange, String prevSnapshotUrl) {
        return this.getManagedDiskPageRangesDiffWithResponse(blobRange, prevSnapshotUrl, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageList>> getManagedDiskPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshotUrl, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.getPageRangesDiffWithResponse(blobRange, null, prevSnapshotUrl, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageList>> getPageRangesDiffWithResponse(BlobRange blobRange, String prevSnapshot, String prevSnapshotUrl, BlobRequestConditions requestConditions, Context context) {
        blobRange = blobRange == null ? new BlobRange(0L) : blobRange;
        BlobRequestConditions blobRequestConditions = requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        if (prevSnapshotUrl == null && prevSnapshot == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("prevSnapshot cannot be null"));
        }
        if (prevSnapshotUrl != null) {
            try {
                new URL(prevSnapshotUrl);
            }
            catch (MalformedURLException ex) {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("'prevSnapshotUrl' is not a valid url.", ex));
            }
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().getPageRangesDiffWithResponseAsync(this.containerName, this.blobName, this.getSnapshotId(), null, prevSnapshot, prevSnapshotUrl, blobRange.toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, null, null, context.addData("az.namespace", "Microsoft.Storage")).map(response -> new SimpleResponse<PageList>(response.getRequest(), response.getStatusCode(), response.getHeaders(), (PageList)response.getValue()));
    }

    BiFunction<String, Integer, Mono<PagedResponse<PageRangeItem>>> listPageRangesDiffWithOptionalTimeout(ListPageRangesDiffOptions options, Duration timeout, Context context) {
        return (marker, pageSize) -> {
            ListPageRangesDiffOptions finalOptions = pageSize != null ? new ListPageRangesDiffOptions(options.getRange(), options.getPreviousSnapshot()).setRequestConditions(options.getRequestConditions()).setMaxResultsPerPage((Integer)pageSize) : options;
            return this.getPageRangesDiffSegment((String)marker, finalOptions, timeout, context).map(response -> {
                List value = response.getValue() == null ? Collections.emptyList() : Stream.concat(((PageList)response.getValue()).getPageRange().stream().map(PageBlobAsyncClient::toPageBlobRange), ((PageList)response.getValue()).getClearRange().stream().map(PageBlobAsyncClient::toPageBlobRange)).collect(Collectors.toList());
                return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), value, PageListHelper.getNextMarker((PageList)response.getValue()), (PageBlobsGetPageRangesDiffHeaders)response.getDeserializedHeaders());
            });
        };
    }

    private Mono<ResponseBase<PageBlobsGetPageRangesDiffHeaders, PageList>> getPageRangesDiffSegment(String marker, ListPageRangesDiffOptions options, Duration timeout, Context context) {
        BlobRequestConditions requestConditions = options.getRequestConditions() == null ? new BlobRequestConditions() : options.getRequestConditions();
        context = context == null ? Context.NONE : context;
        return StorageImplUtils.applyOptionalTimeout(this.azureBlobStorage.getPageBlobs().getPageRangesDiffWithResponseAsync(this.containerName, this.blobName, this.getSnapshotId(), null, options.getPreviousSnapshot(), null, options.getRange().toHeaderValue(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, marker, options.getMaxResultsPerPage(), context.addData("az.namespace", "Microsoft.Storage")), timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> resize(long size) {
        return this.resizeWithResponse(size, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> resizeWithResponse(long size, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.resizeWithResponse(size, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageBlobItem>> resizeWithResponse(long size, BlobRequestConditions requestConditions, Context context) {
        if (size % 512L != 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("size must be a multiple of PageBlobAsyncClient.PAGE_BYTES."));
        }
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().resizeWithResponseAsync(this.containerName, this.blobName, size, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, this.getCustomerProvidedKey(), this.encryptionScope, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            PageBlobsResizeHeaders hd = (PageBlobsResizeHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getXMsBlobSequenceNumber());
            return new SimpleResponse<PageBlobItem>((Response<?>)rb, item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PageBlobItem> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber) {
        return this.updateSequenceNumberWithResponse(action, sequenceNumber, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PageBlobItem>> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions) {
        try {
            return FluxUtil.withContext(context -> this.updateSequenceNumberWithResponse(action, sequenceNumber, requestConditions, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<PageBlobItem>> updateSequenceNumberWithResponse(SequenceNumberActionType action, Long sequenceNumber, BlobRequestConditions requestConditions, Context context) {
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("SequenceNumber must be greater than or equal to 0."));
        }
        requestConditions = requestConditions == null ? new BlobRequestConditions() : requestConditions;
        sequenceNumber = action == SequenceNumberActionType.INCREMENT ? null : sequenceNumber;
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().updateSequenceNumberWithResponseAsync(this.containerName, this.blobName, action, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), sequenceNumber, null, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> {
            PageBlobsUpdateSequenceNumberHeaders hd = (PageBlobsUpdateSequenceNumberHeaders)rb.getDeserializedHeaders();
            PageBlobItem item = new PageBlobItem(hd.getETag(), hd.getLastModified(), null, null, null, null, hd.getXMsBlobSequenceNumber());
            return new SimpleResponse<PageBlobItem>((Response<?>)rb, item);
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CopyStatusType> copyIncremental(String source, String snapshot) {
        return this.copyIncrementalWithResponse(source, snapshot, null).flatMap(FluxUtil::toMono);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyStatusType>> copyIncrementalWithResponse(String source, String snapshot, RequestConditions modifiedRequestConditions) {
        return this.copyIncrementalWithResponse(new PageBlobCopyIncrementalOptions(source, snapshot).setRequestConditions(ModelHelper.populateBlobDestinationRequestConditions(modifiedRequestConditions)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CopyStatusType>> copyIncrementalWithResponse(PageBlobCopyIncrementalOptions options) {
        try {
            return FluxUtil.withContext(context -> this.copyIncrementalWithResponse(options, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError(LOGGER, ex);
        }
    }

    Mono<Response<CopyStatusType>> copyIncrementalWithResponse(PageBlobCopyIncrementalOptions options, Context context) {
        StorageImplUtils.assertNotNull("options", options);
        UrlBuilder builder = UrlBuilder.parse(options.getSource());
        builder.setQueryParameter("snapshot", options.getSnapshot());
        PageBlobCopyIncrementalRequestConditions modifiedRequestConditions = options.getRequestConditions() == null ? new PageBlobCopyIncrementalRequestConditions() : options.getRequestConditions();
        try {
            builder.toUrl();
        }
        catch (MalformedURLException e) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(e));
        }
        context = context == null ? Context.NONE : context;
        return this.azureBlobStorage.getPageBlobs().copyIncrementalWithResponseAsync(this.containerName, this.blobName, builder.toString(), null, modifiedRequestConditions.getIfModifiedSince(), modifiedRequestConditions.getIfUnmodifiedSince(), modifiedRequestConditions.getIfMatch(), modifiedRequestConditions.getIfNoneMatch(), modifiedRequestConditions.getTagsConditions(), null, context.addData("az.namespace", "Microsoft.Storage")).map(rb -> new SimpleResponse<CopyStatusType>((Response<?>)rb, ((PageBlobsCopyIncrementalHeaders)rb.getDeserializedHeaders()).getXMsCopyStatus()));
    }
}

