/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.fetcher.azblob;

import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.blob.models.BlobProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import org.apache.tika.config.Field;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.pipes.fetcher.AbstractFetcher;
import org.apache.tika.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AZBlobFetcher
extends AbstractFetcher
implements Initializable {
    private static String PREFIX = "az-blob";
    private static final Logger LOGGER = LoggerFactory.getLogger(AZBlobFetcher.class);
    private String sasToken;
    private String container;
    private String endpoint;
    private BlobClientFactory blobClientFactory;
    private boolean extractUserMetadata = true;
    private BlobServiceClient blobServiceClient;
    private BlobContainerClient blobContainerClient;
    private boolean spoolToTemp = true;

    public InputStream fetch(String fetchKey, Metadata metadata) throws TikaException, IOException {
        LOGGER.debug("about to fetch fetchkey={} from endpoint ({})", (Object)fetchKey, (Object)this.endpoint);
        try {
            BlobProperties properties;
            BlobClient blobClient = this.blobClientFactory.getClient(fetchKey);
            if (this.extractUserMetadata && (properties = blobClient.getProperties()).getMetadata() != null) {
                for (Map.Entry<String, String> e : properties.getMetadata().entrySet()) {
                    metadata.add(PREFIX + ":" + e.getKey(), e.getValue());
                }
            }
            if (!this.spoolToTemp) {
                return TikaInputStream.get((InputStream)blobClient.openInputStream());
            }
            long start = System.currentTimeMillis();
            TemporaryResources tmpResources = new TemporaryResources();
            Path tmp = tmpResources.createTempFile();
            try (OutputStream os = Files.newOutputStream(tmp, new OpenOption[0]);){
                blobClient.download(os);
            }
            TikaInputStream tis = TikaInputStream.get((Path)tmp, (Metadata)metadata, (TemporaryResources)tmpResources);
            long elapsed = System.currentTimeMillis() - start;
            LOGGER.debug("took {} ms to copy to local tmp file", (Object)elapsed);
            return tis;
        }
        catch (Exception e) {
            throw new IOException("az-blob storage exception", e);
        }
    }

    @Field
    public void setSpoolToTemp(boolean spoolToTemp) {
        this.spoolToTemp = spoolToTemp;
    }

    @Field
    public void setSasToken(String sasToken) {
        this.sasToken = sasToken;
    }

    @Field
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Field
    public void setContainer(String container) {
        this.container = container;
    }

    @Field
    public void setExtractUserMetadata(boolean extractUserMetadata) {
        this.extractUserMetadata = extractUserMetadata;
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
        if (!StringUtils.isBlank((String)this.sasToken)) {
            LOGGER.debug("Setting up immutable endpoint, token and container");
            this.blobClientFactory = new SingleBlobContainerFactory(this.endpoint, this.sasToken, this.container);
        } else {
            LOGGER.debug("Setting up blobclientfactory to recieve the full sas url for the blob");
            this.blobClientFactory = new SASUrlFactory();
        }
    }

    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (!(StringUtils.isBlank((String)this.sasToken) && StringUtils.isBlank((String)this.endpoint) && StringUtils.isBlank((String)this.container))) {
            TikaConfig.mustNotBeEmpty((String)"sasToken", (String)this.sasToken);
            TikaConfig.mustNotBeEmpty((String)"endpoint", (String)this.endpoint);
            TikaConfig.mustNotBeEmpty((String)"container", (String)this.container);
        }
    }

    private static class SASUrlFactory
    implements BlobClientFactory {
        private SASUrlFactory() {
        }

        @Override
        public BlobClient getClient(String fetchKey) {
            return new BlobClientBuilder().connectionString(fetchKey).buildClient();
        }
    }

    private static class SingleBlobContainerFactory
    implements BlobClientFactory {
        private final BlobContainerClient blobContainerClient;

        private SingleBlobContainerFactory(String endpoint, String sasToken, String container) {
            BlobServiceClient blobServiceClient = new BlobServiceClientBuilder().endpoint(endpoint).sasToken(sasToken).buildClient();
            this.blobContainerClient = blobServiceClient.getBlobContainerClient(container);
        }

        @Override
        public BlobClient getClient(String fetchKey) {
            return this.blobContainerClient.getBlobClient(fetchKey);
        }
    }

    private static interface BlobClientFactory {
        public BlobClient getClient(String var1);
    }
}

