/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.XMPMM;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.image.PSDParser;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class PSDParserTest
extends TikaTest {
    private final Parser parser = new PSDParser();

    @Test
    public void testPSD() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/x-psd");
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPSD.psd");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"537", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"51", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"8", (Object)metadata.get(Metadata.BITS_PER_SAMPLE));
    }

    @Test
    public void testOddPSD() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/x-psd");
        try (InputStream stream = this.getResourceAsStream("/test-documents/testPSD2.psd");){
            this.parser.parse(stream, (ContentHandler)new DefaultHandler(), metadata, new ParseContext());
        }
        Assertions.assertEquals((Object)"69", (Object)metadata.get(Metadata.IMAGE_WIDTH));
        Assertions.assertEquals((Object)"70", (Object)metadata.get(Metadata.IMAGE_LENGTH));
        Assertions.assertEquals((Object)"8", (Object)metadata.get(Metadata.BITS_PER_SAMPLE));
    }

    @Test
    public void testXMP() throws Exception {
        Metadata metadata = this.getXML((String)"testPSD_xmp.psd").metadata;
        Assertions.assertEquals((Object)"Adobe Photoshop CC 2014 (Macintosh)", (Object)metadata.get(XMPMM.HISTORY_SOFTWARE_AGENT));
        Assertions.assertEquals((Object)"xmp.iid:63681182-81a0-4035-b4b2-19bea6201c05", (Object)metadata.get(XMPMM.HISTORY_EVENT_INSTANCEID));
    }

    @Test
    public void testMaxLength() throws Exception {
        TikaConfig config = new TikaConfig(this.getResourceAsStream("tika-config-TIKA-3243.xml"));
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", "image/x-psd");
        Assertions.assertThrows(TikaException.class, () -> this.getXML("testPSD_xmp.psd", config.getParser(), metadata));
    }
}

