/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.ContainerExtractor;
import org.apache.tika.extractor.EmbeddedResourceHandler;
import org.apache.tika.extractor.ParserContainerExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.mail.RFC822Parser;
import org.apache.tika.parser.ocr.TesseractOCRParserTest;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class RFC822ParserTest
extends TikaTest {
    private static Parser EXTRACT_ALL_ALTERNATIVES_PARSER;
    private static TikaConfig TIKA_CONFIG;

    private static InputStream getStream(String name) {
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        Assertions.assertNotNull((Object)stream, (String)("Test file not found " + name));
        return stream;
    }

    @BeforeAll
    public static void setUp() throws Exception {
        try (InputStream is = RFC822ParserTest.getStream("org/apache/tika/parser/mail/tika-config-extract-all-alternatives.xml");){
            TIKA_CONFIG = new TikaConfig(is);
        }
        EXTRACT_ALL_ALTERNATIVES_PARSER = new AutoDetectParser(TIKA_CONFIG);
    }

    @Test
    public void testSimple() throws Exception {
        Metadata metadata = new Metadata();
        InputStream stream = RFC822ParserTest.getStream("test-documents/testRFC822");
        ContentHandler handler = (ContentHandler)Mockito.mock(DefaultHandler.class);
        try {
            EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, handler, metadata, new ParseContext());
            ((ContentHandler)Mockito.verify((Object)handler)).startDocument();
            ((ContentHandler)Mockito.verify((Object)handler)).startElement((String)ArgumentMatchers.eq((Object)"http://www.w3.org/1999/xhtml"), (String)ArgumentMatchers.eq((Object)"p"), (String)ArgumentMatchers.eq((Object)"p"), (Attributes)ArgumentMatchers.any(Attributes.class));
            ((ContentHandler)Mockito.verify((Object)handler)).endElement("http://www.w3.org/1999/xhtml", "p", "p");
            ((ContentHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).startElement((String)ArgumentMatchers.eq((Object)"http://www.w3.org/1999/xhtml"), (String)ArgumentMatchers.eq((Object)"div"), (String)ArgumentMatchers.eq((Object)"div"), (Attributes)ArgumentMatchers.any(Attributes.class));
            ((ContentHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.never())).endElement("http://www.w3.org/1999/xhtml", "div", "div");
            ((ContentHandler)Mockito.verify((Object)handler)).endDocument();
            Assertions.assertEquals((Object)"Julien Nioche (JIRA) <jira@apache.org>", (Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertEquals((Object)"[jira] Commented: (TIKA-461) RFC822 messages not parsed", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"[jira] Commented: (TIKA-461) RFC822 messages not parsed", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
        catch (Exception e) {
            Assertions.fail((String)("Exception thrown: " + e.getMessage()));
        }
    }

    @Test
    public void testExtendedToFromMetadata() throws Exception {
        Metadata m = this.getXML((String)"testRFC822").metadata;
        Assertions.assertEquals((Object)"Julien Nioche (JIRA)", (Object)m.get(Message.MESSAGE_FROM_NAME));
        Assertions.assertEquals((Object)"jira@apache.org", (Object)m.get(Message.MESSAGE_FROM_EMAIL));
        m = this.getXML((String)"testRFC822-multipart").metadata;
        Assertions.assertEquals((Object)"DigitalPebble", (Object)m.get(Message.MESSAGE_FROM_NAME));
        Assertions.assertEquals((Object)"julien@digitalpebble.com", (Object)m.get(Message.MESSAGE_FROM_EMAIL));
        m = this.getXML((String)"testRFC822_quoted").metadata;
        Assertions.assertEquals((Object)"Another Person", (Object)m.get(Message.MESSAGE_FROM_NAME));
        Assertions.assertEquals((Object)"another.person@another-example.com", (Object)m.get(Message.MESSAGE_FROM_EMAIL));
        m = this.getXML((String)"testRFC822_i18nheaders").metadata;
        Assertions.assertEquals((Object)"Keld J\u00f8rn Simonsen", (Object)m.get(Message.MESSAGE_FROM_NAME));
        Assertions.assertEquals((Object)"keld@dkuug.dk", (Object)m.get(Message.MESSAGE_FROM_EMAIL));
        m = this.getXML((String)"testEmailWithPNGAtt.eml", (Parser)new RFC822Parser()).metadata;
        Assertions.assertEquals((Object)"Tika Test", (Object)m.get(Message.MESSAGE_FROM_NAME));
        Assertions.assertEquals((Object)"XXXX@apache.org", (Object)m.get(Message.MESSAGE_FROM_EMAIL));
    }

    @Test
    public void testMultipart() {
        Metadata metadata = new Metadata();
        InputStream stream = RFC822ParserTest.getStream("test-documents/testRFC822-multipart");
        ContentHandler handler = (ContentHandler)Mockito.mock(XHTMLContentHandler.class);
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)EXTRACT_ALL_ALTERNATIVES_PARSER);
        try {
            EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, handler, metadata, context);
            ((ContentHandler)Mockito.verify((Object)handler)).startDocument();
            int bodyExpectedTimes = 4;
            int multipackExpectedTimes = 5;
            if (!TesseractOCRParserTest.canRun()) {
                ((ContentHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)bodyExpectedTimes))).startElement((String)ArgumentMatchers.eq((Object)"http://www.w3.org/1999/xhtml"), (String)ArgumentMatchers.eq((Object)"div"), (String)ArgumentMatchers.eq((Object)"div"), (Attributes)ArgumentMatchers.any(Attributes.class));
                ((ContentHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)bodyExpectedTimes))).endElement("http://www.w3.org/1999/xhtml", "div", "div");
            }
            ((ContentHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)multipackExpectedTimes))).startElement((String)ArgumentMatchers.eq((Object)"http://www.w3.org/1999/xhtml"), (String)ArgumentMatchers.eq((Object)"p"), (String)ArgumentMatchers.eq((Object)"p"), (Attributes)ArgumentMatchers.any(Attributes.class));
            ((ContentHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)multipackExpectedTimes))).endElement("http://www.w3.org/1999/xhtml", "p", "p");
            ((ContentHandler)Mockito.verify((Object)handler)).endDocument();
        }
        catch (Exception e) {
            Assertions.fail((String)("Exception thrown: " + e.getMessage()));
        }
        metadata = new Metadata();
        stream = RFC822ParserTest.getStream("test-documents/testRFC822-multipart");
        handler = new BodyContentHandler();
        try {
            EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, handler, metadata, context);
            String bodyText = handler.toString();
            Assertions.assertTrue((boolean)bodyText.contains("body 1"));
            Assertions.assertTrue((boolean)bodyText.contains("body 2"));
            Assertions.assertFalse((boolean)bodyText.contains("R0lGODlhNgE8AMQAA"));
        }
        catch (Exception e) {
            Assertions.fail((String)("Exception thrown: " + e.getMessage()));
        }
    }

    @Test
    public void testQuotedPrintable() {
        Metadata metadata = new Metadata();
        InputStream stream = RFC822ParserTest.getStream("test-documents/testRFC822_quoted");
        BodyContentHandler handler = new BodyContentHandler();
        ParseContext context = new ParseContext();
        try {
            EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, (ContentHandler)handler, metadata, context);
            String bodyText = handler.toString();
            Assertions.assertTrue((boolean)bodyText.contains("D\u00fcsseldorf has non-ascii."));
            Assertions.assertTrue((boolean)bodyText.contains("Lines can be split like this."));
            Assertions.assertTrue((boolean)bodyText.contains("Spaces at the end of a line \r\nmust be encoded.\r\n"));
            Assertions.assertFalse((boolean)bodyText.contains("="));
        }
        catch (Exception e) {
            Assertions.fail((String)("Exception thrown: " + e.getMessage()));
        }
    }

    @Test
    public void testBase64() throws Exception {
        Metadata metadata = new Metadata();
        InputStream stream = RFC822ParserTest.getStream("test-documents/testRFC822_base64");
        BodyContentHandler handler = new BodyContentHandler();
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)EXTRACT_ALL_ALTERNATIVES_PARSER);
        metadata.set("Content-Type", "message/rfc822");
        try {
            EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, (ContentHandler)handler, metadata, context);
            RFC822ParserTest.assertContains((String)"Here is some text, with international characters, voil\u00e0!", (String)handler.toString());
        }
        catch (Exception e) {
            Assertions.fail((String)("Exception thrown: " + e.getMessage()));
        }
    }

    @Test
    public void testI18NHeaders() {
        Metadata metadata = new Metadata();
        InputStream stream = RFC822ParserTest.getStream("test-documents/testRFC822_i18nheaders");
        ContentHandler handler = (ContentHandler)Mockito.mock(DefaultHandler.class);
        try {
            EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, handler, metadata, new ParseContext());
            Assertions.assertEquals((Object)"Keld J\u00f8rn Simonsen <keld@dkuug.dk>", (Object)metadata.get(TikaCoreProperties.CREATOR));
            Assertions.assertEquals((Object)"If you can read this you understand the example.", (Object)metadata.get(TikaCoreProperties.TITLE));
            Assertions.assertEquals((Object)"If you can read this you understand the example.", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        }
        catch (Exception e) {
            Assertions.fail((String)("Exception thrown: " + e.getMessage()));
        }
    }

    @Test
    public void testUnusualFromAddress() throws Exception {
        Metadata metadata = new Metadata();
        InputStream stream = RFC822ParserTest.getStream("test-documents/testRFC822_oddfrom");
        ContentHandler handler = (ContentHandler)Mockito.mock(DefaultHandler.class);
        EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, handler, metadata, new ParseContext());
        Assertions.assertEquals((Object)"Saved by Windows Internet Explorer 7", (Object)metadata.get(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"Air Permit Programs | Air & Radiation | US EPA", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"Air Permit Programs | Air & Radiation | US EPA", (Object)metadata.get(TikaCoreProperties.SUBJECT));
    }

    @Test
    public void testLongHeader() throws Exception {
        StringBuilder inputBuilder = new StringBuilder();
        for (int i = 0; i < 2000; ++i) {
            inputBuilder.append("really really really really really really long name ");
        }
        String name = inputBuilder.toString();
        byte[] data = ("Status: 520\r\nFrom: " + name + "\r\n\r\n").getBytes(StandardCharsets.US_ASCII);
        DefaultHandler handler = new DefaultHandler();
        Metadata metadata = new Metadata();
        ParseContext context = new ParseContext();
        try {
            EXTRACT_ALL_ALTERNATIVES_PARSER.parse((InputStream)new ByteArrayInputStream(data), (ContentHandler)handler, metadata, context);
            Assertions.fail();
        }
        catch (TikaException tikaException) {
            // empty catch block
        }
        MimeConfig config = new MimeConfig.Builder().setMaxHeaderLen(-1).setMaxLineLen(-1).build();
        context.set(MimeConfig.class, (Object)config);
        EXTRACT_ALL_ALTERNATIVES_PARSER.parse((InputStream)new ByteArrayInputStream(data), (ContentHandler)handler, metadata, context);
        Assertions.assertEquals((Object)name.trim(), (Object)metadata.get(TikaCoreProperties.CREATOR));
    }

    @Test
    public void testSomeMissingHeaders() throws Exception {
        Metadata metadata = new Metadata();
        InputStream stream = RFC822ParserTest.getStream("test-documents/testRFC822-limitedheaders");
        BodyContentHandler handler = new BodyContentHandler();
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)EXTRACT_ALL_ALTERNATIVES_PARSER);
        EXTRACT_ALL_ALTERNATIVES_PARSER.parse(stream, (ContentHandler)handler, metadata, context);
        Assertions.assertEquals((Object)true, (Object)metadata.isMultiValued(TikaCoreProperties.CREATOR));
        Assertions.assertEquals((Object)"xyz", (Object)metadata.getValues(TikaCoreProperties.CREATOR)[0]);
        Assertions.assertEquals((Object)"abc", (Object)metadata.getValues(TikaCoreProperties.CREATOR)[1]);
        Assertions.assertEquals((Object)true, (Object)metadata.isMultiValued("Message-From"));
        Assertions.assertEquals((Object)"xyz", (Object)metadata.getValues("Message-From")[0]);
        Assertions.assertEquals((Object)"abc", (Object)metadata.getValues("Message-From")[1]);
        Assertions.assertEquals((Object)true, (Object)metadata.isMultiValued("Message-To"));
        Assertions.assertEquals((Object)"abc", (Object)metadata.getValues("Message-To")[0]);
        Assertions.assertEquals((Object)"def", (Object)metadata.getValues("Message-To")[1]);
        Assertions.assertEquals((Object)"abcd", (Object)metadata.get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((Object)"abcd", (Object)metadata.get(TikaCoreProperties.SUBJECT));
        RFC822ParserTest.assertContains((String)"bar biz bat", (String)handler.toString());
    }

    @Test
    public void testGetAttachmentsAsEmbeddedResources() throws Exception {
        TikaTest.TrackingHandler tracker = new TikaTest.TrackingHandler();
        ParserContainerExtractor ex = new ParserContainerExtractor(TIKA_CONFIG);
        try (TikaInputStream tis = TikaInputStream.get((InputStream)RFC822ParserTest.getStream("test-documents/testRFC822-multipart"));){
            Assertions.assertEquals((Object)true, (Object)ex.isSupported(tis));
            ex.extract(tis, (ContainerExtractor)ex, (EmbeddedResourceHandler)tracker);
        }
        Assertions.assertEquals((int)3, (int)tracker.filenames.size());
        Assertions.assertEquals((int)3, (int)tracker.mediaTypes.size());
        Assertions.assertEquals(null, tracker.filenames.get(0));
        Assertions.assertEquals(null, tracker.filenames.get(1));
        Assertions.assertEquals((Object)"logo.gif", tracker.filenames.get(2));
        Assertions.assertEquals((Object)MediaType.TEXT_PLAIN, tracker.mediaTypes.get(0));
        Assertions.assertEquals((Object)MediaType.TEXT_HTML, tracker.mediaTypes.get(1));
        Assertions.assertEquals((Object)MediaType.image((String)"gif"), tracker.mediaTypes.get(2));
    }

    @Test
    public void testDetection() throws Exception {
        TikaTest.XMLResult r = this.getXML("testRFC822_date_utf8");
        Assertions.assertEquals((Object)"message/rfc822", (Object)r.metadata.get("Content-Type"));
        r = this.getXML("testRFC822_eml");
        Assertions.assertEquals((Object)"message/rfc822", (Object)r.metadata.get("Content-Type"));
    }

    @Test
    public void testDates() throws Exception {
        TikaTest.XMLResult r = this.getXML("testRFC822_date_utf8");
        Assertions.assertEquals((Object)"2016-05-16T08:30:32Z", (Object)r.metadata.get(TikaCoreProperties.CREATED));
        r = this.getXML("testRFC822_eml");
        Assertions.assertEquals((Object)"2016-05-16T08:30:32Z", (Object)r.metadata.get(TikaCoreProperties.CREATED));
    }

    @Test
    public void testMultipleSubjects() throws Exception {
        String s = "From: Shawn Jones [chiroshawn@yahoo.com]\nSubject: 2006N-3502\nSubject: I Urge You to Require Notice of Mercury";
        RFC822Parser p = new RFC822Parser();
        Metadata m = new Metadata();
        p.parse((InputStream)TikaInputStream.get((byte[])s.getBytes(StandardCharsets.UTF_8)), (ContentHandler)new DefaultHandler(), m, new ParseContext());
        Assertions.assertEquals((Object)"I Urge You to Require Notice of Mercury", (Object)m.get(TikaCoreProperties.TITLE));
    }

    @Test
    public void testExtractAttachments() throws Exception {
        List metadataList = this.getRecursiveMetadata("testEmailWithPNGAtt.eml", EXTRACT_ALL_ALTERNATIVES_PARSER);
        Assertions.assertEquals((Object)"Tika Test <XXXX@apache.org>", (Object)((Metadata)metadataList.get(3)).get("Message-From"));
        Assertions.assertEquals((Object)"Test Attachment Email", (Object)((Metadata)metadataList.get(3)).get(TikaCoreProperties.TITLE));
        Assertions.assertEquals((int)4, (int)metadataList.size());
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"image/png", (Object)((Metadata)metadataList.get(2)).get("Content-Type"));
        Assertions.assertEquals((Object)"testPNG.png", (Object)((Metadata)metadataList.get(2)).get("resourceName"));
        RFC822ParserTest.assertContains((String)"This email has a PNG attachment included in it", (String)((Metadata)metadataList.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals(null, (Object)((Metadata)metadataList.get(1)).get("Content-Disposition"));
        Assertions.assertEquals((Object)"attachment; filename=\"testPNG.png\"", (Object)((Metadata)metadataList.get(2)).get("Content-Disposition"));
    }

    @Test
    public void testEmbeddedMetadata() throws Exception {
        List seenMetadata = this.getRecursiveMetadata("testRFC822-multipart", EXTRACT_ALL_ALTERNATIVES_PARSER);
        Assertions.assertEquals((int)4, (int)seenMetadata.size());
        Assertions.assertEquals(null, (Object)((Metadata)seenMetadata.get(1)).get("Content-Disposition"));
        Assertions.assertEquals((Object)"text/plain; charset=UTF-8", (Object)((Metadata)seenMetadata.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"UTF-8", (Object)((Metadata)seenMetadata.get(1)).get("Content-Encoding"));
        Assertions.assertEquals(null, (Object)((Metadata)seenMetadata.get(2)).get("Content-Disposition"));
        Assertions.assertEquals((Object)"text/html; charset=UTF-8", (Object)((Metadata)seenMetadata.get(2)).get("Content-Type"));
        Assertions.assertEquals((Object)"UTF-8", (Object)((Metadata)seenMetadata.get(2)).get("Content-Encoding"));
        Assertions.assertEquals((Object)"attachment; filename=\"logo.gif\"", (Object)((Metadata)seenMetadata.get(3)).get("Content-Disposition"));
        Assertions.assertEquals((Object)"logo.gif", (Object)((Metadata)seenMetadata.get(3)).get("resourceName"));
        Assertions.assertEquals((Object)"image/gif", (Object)((Metadata)seenMetadata.get(3)).get("Content-Type"));
    }

    @Test
    public void testMultipartFlags() throws Exception {
        List metadataList = this.getRecursiveMetadata("testRFC822-multipart", EXTRACT_ALL_ALTERNATIVES_PARSER);
        Assertions.assertEquals((Object)"mixed", (Object)((Metadata)metadataList.get(0)).get("Multipart-Subtype"));
        Assertions.assertEquals((Object)"0016e64606800312ee04913db790", (Object)((Metadata)metadataList.get(0)).get("Multipart-Boundary"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(1)).get("Content-Type").equals("text/plain; charset=UTF-8"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(1)).get("Multipart-Subtype").equals("alternative"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(1)).get("Multipart-Boundary").equals("0016e64606800312ea04913db78e"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(2)).get("Content-Type").equals("text/html; charset=UTF-8"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(2)).get("Multipart-Subtype").equals("alternative"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(2)).get("Multipart-Boundary").equals("0016e64606800312ea04913db78e"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(3)).get("Content-Type").equals("image/gif"));
        Assertions.assertEquals((Object)"mixed", (Object)((Metadata)metadataList.get(3)).get("Multipart-Subtype"));
        Assertions.assertEquals((Object)"0016e64606800312ee04913db790", (Object)((Metadata)metadataList.get(3)).get("Multipart-Boundary"));
    }

    @Test
    public void testBasicAlternativeBodyHandling() throws Exception {
        List metadataList = this.getRecursiveMetadata("testRFC822-multipart");
        Assertions.assertEquals((int)2, (int)metadataList.size());
        String body = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        RFC822ParserTest.assertContains((String)"body 2", (String)body);
        RFC822ParserTest.assertNotContained((String)"body 1", (String)body);
        Assertions.assertEquals((Object)"message/rfc822", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        Assertions.assertEquals((Object)"image/gif", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"/logo.gif", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
    }

    @Test
    public void testMixedRelatedMultipart() throws Exception {
        List metadataList = this.getRecursiveMetadata("testRFC822-mixed-simple");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        RFC822ParserTest.assertContains((String)"body 2", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        RFC822ParserTest.assertNotContained((String)"body 1", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)"message/rfc822", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        Assertions.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"/Mary with cooler.jpeg", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.INLINE.toString(), (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertEquals((Object)"image/jpeg", (Object)((Metadata)metadataList.get(2)).get("Content-Type"));
        Assertions.assertEquals((Object)"/mary-coffee.jpg", (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString(), (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
    }

    @Test
    public void testAlternativeWithComplexMixedChild() throws Exception {
        List metadataList = this.getRecursiveMetadata("testRFC822-mixed-with-pdf-inline");
        Assertions.assertEquals((int)2, (int)metadataList.size());
        String body = ((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT);
        RFC822ParserTest.assertContains((String)"body 2", (String)body);
        RFC822ParserTest.assertContains((String)"body 3", (String)body);
        RFC822ParserTest.assertNotContained((String)"body 1", (String)body);
        Assertions.assertEquals((Object)"message/rfc822", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        Assertions.assertEquals((Object)"application/pdf", (Object)((Metadata)metadataList.get(1)).get("Content-Type"));
        Assertions.assertEquals((Object)"/tzora-titan-4-hummer-xl-manual.pdf", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
    }

    @Test
    public void testArc() throws Exception {
        List metadataList = this.getRecursiveMetadata("testRFC822-ARC");
        Assertions.assertEquals((int)1, (int)metadataList.size());
        Assertions.assertEquals((Object)"message/rfc822", (Object)((Metadata)metadataList.get(0)).get("Content-Type"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(0)).get(TikaCoreProperties.CREATED).startsWith("2022-01-"));
    }

    @Test
    public void testSimpleBodyInlined() throws Exception {
        List metadataList = this.getRecursiveMetadata("testRFC822_simple_inline_body.txt");
        Assertions.assertEquals((int)1, (int)metadataList.size());
        RFC822ParserTest.assertContains((String)"asked", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
    }

    @Test
    public void testGroupwise() throws Exception {
        List metadataList = this.getRecursiveMetadata("testGroupWiseEml.eml");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        RFC822ParserTest.assertContains((String)"test<", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        RFC822ParserTest.assertContains((String)"test2", (String)((Metadata)metadataList.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString(), (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertEquals((Object)"/test.eml", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        RFC822ParserTest.assertContains((String)"ssssss", (String)((Metadata)metadataList.get(2)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString(), (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertEquals((Object)"/Neues Textdokument.txt", (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
    }

    @Test
    public void testMultipartTextAttachment() throws Exception {
        List metadataList = this.getRecursiveMetadata("testRFC822_multipart_attachments.eml");
        Assertions.assertEquals((int)3, (int)metadataList.size());
        RFC822ParserTest.assertContains((String)"This is the html body of the main msg.", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        RFC822ParserTest.assertContains((String)"This is Test TXTA File for parser", (String)((Metadata)metadataList.get(1)).get(TikaCoreProperties.TIKA_CONTENT));
        RFC822ParserTest.assertNotContained((String)"This is Test TXTA File for parser", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)"/Test TxtA.txt", (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString(), (Object)((Metadata)metadataList.get(1)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(1)).get(TikaCoreProperties.CREATED).startsWith("2022-11-"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(1)).get(TikaCoreProperties.MODIFIED).startsWith("2022-11-"));
        RFC822ParserTest.assertContains((String)"This is Test TXTB File for parser", (String)((Metadata)metadataList.get(2)).get(TikaCoreProperties.TIKA_CONTENT));
        RFC822ParserTest.assertNotContained((String)"This is Test TXTB File for parser", (String)((Metadata)metadataList.get(0)).get(TikaCoreProperties.TIKA_CONTENT));
        Assertions.assertEquals((Object)"/Test TxtB.txt", (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_PATH));
        Assertions.assertEquals((Object)TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString(), (Object)((Metadata)metadataList.get(2)).get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(2)).get(TikaCoreProperties.CREATED).startsWith("2022-11-"));
        Assertions.assertTrue((boolean)((Metadata)metadataList.get(2)).get(TikaCoreProperties.MODIFIED).startsWith("2022-11-"));
    }
}

