/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ocr;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.tika.TikaTest;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.ocr.TesseractOCRParser;
import org.junit.Assert;
import org.junit.Test;

public class TesseractOCRConfigTest
extends TikaTest {
    @Test
    public void testNoConfig() throws Exception {
        TesseractOCRConfig config = new TesseractOCRConfig();
        Assert.assertEquals((String)"Invalid default language value", (Object)"eng", (Object)config.getLanguage());
        Assert.assertEquals((String)"Invalid default pageSegMode value", (Object)"1", (Object)config.getPageSegMode());
        Assert.assertEquals((String)"Invalid default minFileSizeToOcr value", (long)0L, (long)config.getMinFileSizeToOcr());
        Assert.assertEquals((String)"Invalid default maxFileSizeToOcr value", (long)Integer.MAX_VALUE, (long)config.getMaxFileSizeToOcr());
        Assert.assertEquals((String)"Invalid default timeout value", (long)120L, (long)config.getTimeoutSeconds());
        Assert.assertEquals((String)"Invalid default density value", (long)300L, (long)config.getDensity());
        Assert.assertEquals((String)"Invalid default depth value", (long)4L, (long)config.getDepth());
        Assert.assertEquals((String)"Invalid default colorpsace value", (Object)"gray", (Object)config.getColorspace());
        Assert.assertEquals((String)"Invalid default filter value", (Object)"triangle", (Object)config.getFilter());
        Assert.assertEquals((String)"Invalid default resize value", (long)200L, (long)config.getResize());
        Assert.assertEquals((String)"Invalid default applyRotation value", (Object)false, (Object)config.isApplyRotation());
    }

    @Test
    public void testPartialConfig() throws Exception {
        InputStream stream = this.getResourceAsStream("/test-configs/tika-config-tesseract-partial.xml");
        TesseractOCRParser parser = (TesseractOCRParser)((CompositeParser)new TikaConfig(stream).getParser()).getAllComponentParsers().get(0);
        TesseractOCRConfig config = parser.getDefaultConfig();
        Assert.assertEquals((String)"Invalid overridden language value", (Object)"fra+deu", (Object)config.getLanguage());
        Assert.assertEquals((String)"Invalid default pageSegMode value", (Object)"1", (Object)config.getPageSegMode());
        Assert.assertEquals((String)"Invalid overridden minFileSizeToOcr value", (long)1L, (long)config.getMinFileSizeToOcr());
        Assert.assertEquals((String)"Invalid default maxFileSizeToOcr value", (long)Integer.MAX_VALUE, (long)config.getMaxFileSizeToOcr());
        Assert.assertEquals((String)"Invalid overridden timeout value", (long)240L, (long)config.getTimeoutSeconds());
        Assert.assertEquals((String)"Invalid overridden density value", (long)200L, (long)config.getDensity());
        Assert.assertEquals((String)"Invalid overridden depth value", (long)8L, (long)config.getDepth());
        Assert.assertEquals((String)"Invalid overridden filter value", (Object)"box", (Object)config.getFilter());
        Assert.assertEquals((String)"Invalid overridden resize value", (long)300L, (long)config.getResize());
        Assert.assertEquals((String)"Invalid default applyRotation value", (Object)false, (Object)config.isApplyRotation());
    }

    @Test
    public void testFullConfig() throws Exception {
        InputStream stream = this.getResourceAsStream("/test-configs/tika-config-tesseract-full.xml");
        TesseractOCRParser parser = (TesseractOCRParser)((CompositeParser)new TikaConfig(stream).getParser()).getAllComponentParsers().get(0);
        TesseractOCRConfig config = parser.getDefaultConfig();
        Assert.assertEquals((String)"Invalid overridden language value", (Object)"ceb", (Object)config.getLanguage());
        Assert.assertEquals((String)"Invalid overridden pageSegMode value", (Object)"2", (Object)config.getPageSegMode());
        Assert.assertEquals((String)"Invalid overridden minFileSizeToOcr value", (long)1L, (long)config.getMinFileSizeToOcr());
        Assert.assertEquals((String)"Invalid overridden maxFileSizeToOcr value", (long)2000000L, (long)config.getMaxFileSizeToOcr());
        Assert.assertEquals((String)"Invalid overridden timeout value", (long)240L, (long)config.getTimeoutSeconds());
        Assert.assertEquals((String)"Invalid overridden density value", (long)200L, (long)config.getDensity());
        Assert.assertEquals((String)"Invalid overridden depth value", (long)8L, (long)config.getDepth());
        Assert.assertEquals((String)"Invalid overridden filter value", (Object)"box", (Object)config.getFilter());
        Assert.assertEquals((String)"Invalid overridden resize value", (long)300L, (long)config.getResize());
        Assert.assertEquals((String)"Invalid overridden applyRotation value", (Object)true, (Object)config.isApplyRotation());
    }

    @Test
    public void testValidateValidLanguage() {
        List<String> validLanguages = Arrays.asList("eng", "slk_frak", "chi_tra", "eng+fra", "tgk+chi_tra+slk_frak", "chi_tra_vert", "tgk+chi_tra_vert+slk_frak", "eng+script/Arabic", "script/HanT_vert");
        TesseractOCRConfig config = new TesseractOCRConfig();
        for (String language : validLanguages) {
            config.setLanguage(language);
            Assert.assertEquals((String)"Valid language not set", (Object)language, (Object)config.getLanguage());
        }
    }

    @Test
    public void testValidateInvalidLanguage() {
        List<String> invalidLanguages = Arrays.asList("+", "en", "en+", "eng+fra+", "Arabic", "/script/Arabic", "rm -rf *");
        TesseractOCRConfig config = new TesseractOCRConfig();
        for (String language : invalidLanguages) {
            try {
                config.setLanguage(language);
                Assert.fail((String)("Invalid language set: " + language));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidatePageSegMode() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setPageSegMode("0");
        config.setPageSegMode("10");
        Assert.assertTrue((String)"Couldn't set valid values", (boolean)true);
        config.setPageSegMode("14");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateDensity() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setDensity(300);
        config.setDensity(400);
        Assert.assertTrue((String)"Couldn't set valid values", (boolean)true);
        config.setDensity(1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateDepth() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setDepth(4);
        config.setDepth(8);
        Assert.assertTrue((String)"Couldn't set valid values", (boolean)true);
        config.setDepth(6);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateFilter() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setFilter("Triangle");
        config.setFilter("box");
        Assert.assertTrue((String)"Couldn't set valid values", (boolean)true);
        config.setFilter("abc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateResize() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setResize(200);
        config.setResize(400);
        Assert.assertTrue((String)"Couldn't set valid values", (boolean)true);
        config.setResize(1000);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDataPathCheck() {
        TesseractOCRParser parser = new TesseractOCRParser();
        parser.setTessdataPath("blah\u0000deblah");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPathCheck() {
        TesseractOCRParser parser = new TesseractOCRParser();
        parser.setTesseractPath("blah\u0000deblah");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadOtherKey() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.addOtherTesseractConfig("bad bad", "bad");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadOtherValue() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.addOtherTesseractConfig("bad", "bad bad");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadOtherValueSlash() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.addOtherTesseractConfig("bad", "bad\\bad");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadOtherValueControl() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.addOtherTesseractConfig("bad", "bad\u0001bad");
    }

    @Test
    public void testGoodOtherParameters() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.addOtherTesseractConfig("good", "good");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadLanguageCode() throws Exception {
        TesseractOCRConfig tesseractOCRConfig = new TesseractOCRConfig();
        tesseractOCRConfig.setLanguage("kerplekistani");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadColorSpace() {
        TesseractOCRConfig config = new TesseractOCRConfig();
        config.setColorspace("someth!ng");
    }

    @Test
    public void testUpdatingConfigs() throws Exception {
        TesseractOCRConfig configA = new TesseractOCRConfig();
        configA.setLanguage("eng");
        configA.setMinFileSizeToOcr(100L);
        configA.setOutputType(TesseractOCRConfig.OUTPUT_TYPE.TXT);
        configA.addOtherTesseractConfig("k1", "a1");
        configA.addOtherTesseractConfig("k2", "a2");
        TesseractOCRConfig configB = new TesseractOCRConfig();
        configB.setLanguage("fra");
        configB.setMinFileSizeToOcr(1000L);
        configB.setOutputType(TesseractOCRConfig.OUTPUT_TYPE.HOCR);
        configB.addOtherTesseractConfig("k1", "b1");
        configB.addOtherTesseractConfig("k2", "b2");
        TesseractOCRConfig clone = configA.cloneAndUpdate(configB);
        Assert.assertEquals((Object)"fra", (Object)clone.getLanguage());
        Assert.assertEquals((long)1000L, (long)clone.getMinFileSizeToOcr());
        Assert.assertEquals((Object)TesseractOCRConfig.OUTPUT_TYPE.HOCR, (Object)clone.getOutputType());
        Assert.assertEquals((Object)"b1", clone.getOtherTesseractConfig().get("k1"));
        Assert.assertEquals((Object)"b2", clone.getOtherTesseractConfig().get("k2"));
    }
}

