/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.sqlite3;

import java.io.InputStream;
import org.apache.tika.TikaTest;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.jupiter.api.Test;
import org.xml.sax.ContentHandler;

public class SQLite3ParserTest
extends TikaTest {
    private static final String TEST_FILE_NAME = "testSqlite3b.db";
    private static final String TEST_FILE1 = "/test-documents/testSqlite3b.db";

    @Test
    public void testSpacesInBodyContentHandler() throws Exception {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", TEST_FILE_NAME);
        BodyContentHandler handler = new BodyContentHandler(-1);
        ParseContext ctx = new ParseContext();
        try (InputStream stream = this.getResourceAsStream(TEST_FILE1);){
            TikaTest.AUTO_DETECT_PARSER.parse(stream, (ContentHandler)handler, metadata, ctx);
        }
        String s = handler.toString();
        TikaTest.assertContains((String)"0\t2.3\t2.4\tlorem", (String)s);
        TikaTest.assertContains((String)"tempor\n", (String)s);
    }

    @Test
    public void testNulls() throws Exception {
        String xml = this.getXML((String)TEST_FILE_NAME).xml.replaceAll("\\s+", "");
        TikaTest.assertContains((String)"<tr><td>2</td><td/><td/><td/><td/><td/><td/><td/><td/><td/></tr>", (String)xml);
    }
}

