/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.pipes.pipesiterator.azblob;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.tika.pipes.FetchEmitTuple;
import org.apache.tika.pipes.pipesiterator.PipesIterator;
import org.apache.tika.pipes.pipesiterator.azblob.AZBlobPipesIterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

@Disabled(value="turn into an actual unit test")
public class TestAZBlobPipesIterator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() throws Exception {
        AZBlobPipesIterator it = new AZBlobPipesIterator();
        it.setContainer("");
        it.setEndpoint("");
        it.setSasToken("");
        it.initialize(Collections.EMPTY_MAP);
        int numConsumers = 2;
        ArrayBlockingQueue<FetchEmitTuple> queue = new ArrayBlockingQueue<FetchEmitTuple>(10);
        ExecutorService es = Executors.newFixedThreadPool(numConsumers + 1);
        ExecutorCompletionService<Integer> c = new ExecutorCompletionService<Integer>(es);
        ArrayList<MockFetcher> fetchers = new ArrayList<MockFetcher>();
        for (int i = 0; i < numConsumers; ++i) {
            MockFetcher fetcher = new MockFetcher(queue);
            fetchers.add(fetcher);
            c.submit(fetcher);
        }
        for (FetchEmitTuple t : it) {
            queue.offer(t);
        }
        for (int i = 0; i < numConsumers; ++i) {
            queue.offer(PipesIterator.COMPLETED_SEMAPHORE);
        }
        int completed = 0;
        try {
            for (int finished = 0; finished < numConsumers; ++finished) {
                Future f = c.take();
                completed += ((Integer)f.get()).intValue();
            }
        }
        finally {
            es.shutdownNow();
        }
        Assertions.assertEquals((int)1, (int)completed);
    }

    private static class MockFetcher
    implements Callable<Integer> {
        private final ArrayBlockingQueue<FetchEmitTuple> queue;
        private final List<FetchEmitTuple> pairs = new ArrayList<FetchEmitTuple>();

        private MockFetcher(ArrayBlockingQueue<FetchEmitTuple> queue) {
            this.queue = queue;
        }

        @Override
        public Integer call() throws Exception {
            FetchEmitTuple t;
            while ((t = this.queue.poll(1L, TimeUnit.HOURS)) != PipesIterator.COMPLETED_SEMAPHORE) {
                this.pairs.add(t);
            }
            return this.pairs.size();
        }
    }
}

