/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.netty.implementation.AzureNettyHttpClientContext;
import com.azure.core.http.netty.implementation.NettyAsyncHttpBufferedResponse;
import com.azure.core.http.netty.implementation.NettyAsyncHttpResponse;
import com.azure.core.http.netty.implementation.Utility;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.ByteArrayContent;
import com.azure.core.implementation.util.FileContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.implementation.util.SerializableContent;
import com.azure.core.implementation.util.StringContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.Contexts;
import com.azure.core.util.ProgressReporter;
import com.azure.core.util.logging.ClientLogger;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.net.ssl.SSLException;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;
import reactor.netty.http.client.HttpClientResponse;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

class NettyAsyncHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(NettyAsyncHttpClient.class);
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final String AZURE_EAGERLY_READ_RESPONSE = "azure-eagerly-read-response";
    private static final String AZURE_IGNORE_RESPONSE_BODY = "azure-ignore-response-body";
    private static final String AZURE_RESPONSE_TIMEOUT = "azure-response-timeout";
    private static final String AZURE_EAGERLY_CONVERT_HEADERS = "azure-eagerly-convert-headers";
    final boolean disableBufferCopy;
    final boolean addProxyHandler;
    final reactor.netty.http.client.HttpClient nettyClient;

    NettyAsyncHttpClient(reactor.netty.http.client.HttpClient nettyClient, boolean disableBufferCopy, boolean addProxyHandler) {
        this.nettyClient = nettyClient;
        this.disableBufferCopy = disableBufferCopy;
        this.addProxyHandler = addProxyHandler;
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        Objects.requireNonNull(request.getHttpMethod(), "'request.getHttpMethod()' cannot be null.");
        Objects.requireNonNull(request.getUrl(), "'request.getUrl()' cannot be null.");
        Objects.requireNonNull(request.getUrl().getProtocol(), "'request.getUrl().getProtocol()' cannot be null.");
        boolean eagerlyReadResponse = (Boolean)context.getData(AZURE_EAGERLY_READ_RESPONSE).orElse(false);
        boolean ignoreResponseBody = (Boolean)context.getData(AZURE_IGNORE_RESPONSE_BODY).orElse(false);
        boolean headersEagerlyConverted = (Boolean)context.getData(AZURE_EAGERLY_CONVERT_HEADERS).orElse(false);
        Long responseTimeout = context.getData(AZURE_RESPONSE_TIMEOUT).filter(timeoutDuration -> timeoutDuration instanceof Duration).map(timeoutDuration -> ((Duration)timeoutDuration).toMillis()).orElse(null);
        ProgressReporter progressReporter = Contexts.with(context).getHttpRequestProgressReporter();
        return this.attemptAsync(request, eagerlyReadResponse, ignoreResponseBody, headersEagerlyConverted, responseTimeout, progressReporter, false);
    }

    private Mono<HttpResponse> attemptAsync(HttpRequest request, boolean eagerlyReadResponse, boolean ignoreResponseBody, boolean headersEagerlyConverted, Long responseTimeout, ProgressReporter progressReporter, boolean proxyRetry) {
        Flux<Tuple2<HttpResponse, HttpHeaders>> nettyRequest = ((HttpClient.RequestSender)this.nettyClient.request(NettyAsyncHttpClient.toReactorNettyHttpMethod(request.getHttpMethod())).uri(request.getUrl().toString())).send(NettyAsyncHttpClient.bodySendDelegate(request)).responseConnection(NettyAsyncHttpClient.responseDelegate(request, this.disableBufferCopy, eagerlyReadResponse, ignoreResponseBody, headersEagerlyConverted));
        if (responseTimeout != null || progressReporter != null) {
            nettyRequest = nettyRequest.contextWrite(ctx -> ctx.put("azure-sdk-pipeline-data", new AzureNettyHttpClientContext(responseTimeout, progressReporter)));
        }
        return nettyRequest.single().flatMap(responseAndHeaders -> {
            HttpResponse response = (HttpResponse)responseAndHeaders.getT1();
            if (this.addProxyHandler && response.getStatusCode() == 407) {
                if (proxyRetry) {
                    return Mono.error(new HttpProxyHandler.HttpProxyConnectException("Failed to connect to proxy. Status: 407", (HttpHeaders)responseAndHeaders.getT2()));
                }
                return this.attemptAsync(request, eagerlyReadResponse, ignoreResponseBody, headersEagerlyConverted, responseTimeout, progressReporter, true);
            }
            return Mono.just(response);
        }).onErrorResume(throwable -> NettyAsyncHttpClient.shouldRetryProxyError(proxyRetry, throwable) ? this.attemptAsync(request, eagerlyReadResponse, ignoreResponseBody, headersEagerlyConverted, responseTimeout, progressReporter, true) : Mono.error(throwable));
    }

    private static boolean shouldRetryProxyError(boolean proxyRetry, Throwable throwable) {
        return !proxyRetry && (throwable instanceof ProxyConnectException || throwable instanceof SSLException && throwable.getCause() instanceof ProxyConnectException);
    }

    @Override
    public HttpResponse sendSync(HttpRequest request, Context context) {
        try {
            return this.send(request, context).block();
        }
        catch (Exception e) {
            Throwable unwrapped = Exceptions.unwrap(e);
            if (unwrapped instanceof RuntimeException) {
                throw LOGGER.logExceptionAsError((RuntimeException)unwrapped);
            }
            if (unwrapped instanceof IOException) {
                throw LOGGER.logExceptionAsError(new UncheckedIOException((IOException)unwrapped));
            }
            throw LOGGER.logExceptionAsError(new RuntimeException(unwrapped));
        }
    }

    private static BiFunction<HttpClientRequest, NettyOutbound, Publisher<Void>> bodySendDelegate(HttpRequest restRequest) {
        return (reactorNettyRequest, reactorNettyOutbound) -> {
            for (HttpHeader hdr : restRequest.getHeaders()) {
                reactorNettyRequest.requestHeaders().set(hdr.getName(), (Iterable<?>)hdr.getValuesList());
            }
            BinaryData body = restRequest.getBodyAsBinaryData();
            if (body != null) {
                BinaryDataContent bodyContent = BinaryDataHelper.getContent(body);
                if (bodyContent instanceof ByteArrayContent) {
                    return reactorNettyOutbound.send(Mono.just(Unpooled.wrappedBuffer(bodyContent.toBytes())));
                }
                if (bodyContent instanceof StringContent || bodyContent instanceof SerializableContent) {
                    return reactorNettyOutbound.send(Mono.fromSupplier(() -> Unpooled.wrappedBuffer(bodyContent.toBytes())));
                }
                if (bodyContent instanceof FileContent) {
                    return NettyAsyncHttpClient.sendFile(restRequest, reactorNettyOutbound, (FileContent)bodyContent);
                }
                if (bodyContent instanceof InputStreamContent) {
                    return NettyAsyncHttpClient.sendInputStream(reactorNettyOutbound, (InputStreamContent)bodyContent);
                }
                Flux<ByteBuf> nettyByteBufFlux = restRequest.getBody().map(Unpooled::wrappedBuffer);
                return reactorNettyOutbound.send(nettyByteBufFlux);
            }
            return reactorNettyOutbound;
        };
    }

    private static NettyOutbound sendFile(HttpRequest restRequest, NettyOutbound reactorNettyOutbound, FileContent fileContent) {
        if (fileContent.getLength() == 0L) {
            return reactorNettyOutbound.sendByteArray(Flux.just(EMPTY_BYTES));
        }
        if (restRequest.getUrl().getProtocol().equals("https")) {
            return reactorNettyOutbound.sendUsing(() -> FileChannel.open(fileContent.getFile(), StandardOpenOption.READ), (c, fc) -> {
                if (c.channel().pipeline().get(ChunkedWriteHandler.class) == null) {
                    c.addHandlerLast("reactor.left.chunkedWriter", new ChunkedWriteHandler());
                }
                try {
                    return new ChunkedNioFile((FileChannel)fc, fileContent.getPosition(), fileContent.getLength(), fileContent.getChunkSize());
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
                }
            }, fc -> {
                try {
                    fc.close();
                }
                catch (IOException e) {
                    throw LOGGER.logExceptionAsError(new UncheckedIOException(e));
                }
            });
        }
        return reactorNettyOutbound.sendFile(fileContent.getFile(), fileContent.getPosition(), fileContent.getLength());
    }

    private static NettyOutbound sendInputStream(NettyOutbound reactorNettyOutbound, InputStreamContent bodyContent) {
        return reactorNettyOutbound.sendUsing(bodyContent::toStream, (c, stream) -> {
            if (c.channel().pipeline().get(ChunkedWriteHandler.class) == null) {
                c.addHandlerLast("reactor.left.chunkedWriter", new ChunkedWriteHandler());
            }
            return new ChunkedStream((InputStream)stream);
        }, stream -> {});
    }

    private static BiFunction<HttpClientResponse, Connection, Mono<Tuple2<HttpResponse, HttpHeaders>>> responseDelegate(HttpRequest restRequest, boolean disableBufferCopy, boolean eagerlyReadResponse, boolean ignoreResponseBody, boolean headersEagerlyConverted) {
        return (reactorNettyResponse, reactorNettyConnection) -> {
            if (eagerlyReadResponse || ignoreResponseBody) {
                return Mono.using(() -> reactorNettyConnection, connection -> connection.inbound().receive().aggregate().asByteArray().switchIfEmpty(Mono.just(EMPTY_BYTES)).map(bytes -> Tuples.of(new NettyAsyncHttpBufferedResponse((HttpClientResponse)reactorNettyResponse, restRequest, (byte[])bytes, headersEagerlyConverted), reactorNettyResponse.responseHeaders())), Utility::closeConnection);
            }
            return Mono.just(Tuples.of(new NettyAsyncHttpResponse((HttpClientResponse)reactorNettyResponse, (Connection)reactorNettyConnection, restRequest, disableBufferCopy, headersEagerlyConverted), reactorNettyResponse.responseHeaders()));
        };
    }

    private static io.netty.handler.codec.http.HttpMethod toReactorNettyHttpMethod(HttpMethod azureHttpMethod) {
        switch (azureHttpMethod) {
            case GET: {
                return io.netty.handler.codec.http.HttpMethod.GET;
            }
            case PUT: {
                return io.netty.handler.codec.http.HttpMethod.PUT;
            }
            case HEAD: {
                return io.netty.handler.codec.http.HttpMethod.HEAD;
            }
            case POST: {
                return io.netty.handler.codec.http.HttpMethod.POST;
            }
            case DELETE: {
                return io.netty.handler.codec.http.HttpMethod.DELETE;
            }
            case PATCH: {
                return io.netty.handler.codec.http.HttpMethod.PATCH;
            }
            case TRACE: {
                return io.netty.handler.codec.http.HttpMethod.TRACE;
            }
            case CONNECT: {
                return io.netty.handler.codec.http.HttpMethod.CONNECT;
            }
            case OPTIONS: {
                return io.netty.handler.codec.http.HttpMethod.OPTIONS;
            }
        }
        throw LOGGER.logExceptionAsError(new IllegalStateException("Unknown HttpMethod '" + (Object)((Object)azureHttpMethod) + "'."));
    }
}

