/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.annotation.ResumeOperation;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.implementation.http.rest.LengthValidatingInputStream;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataHelper;
import com.azure.core.implementation.util.FluxByteBufferContent;
import com.azure.core.implementation.util.InputStreamContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class RestProxyUtils {
    private static final ByteBuffer VALIDATION_BUFFER = ByteBuffer.allocate(0);
    public static final String BODY_TOO_LARGE = "Request body emitted %d bytes, more than the expected %d bytes.";
    public static final String BODY_TOO_SMALL = "Request body emitted %d bytes, less than the expected %d bytes.";
    public static final ClientLogger LOGGER = new ClientLogger(RestProxyUtils.class);

    private RestProxyUtils() {
    }

    public static Mono<HttpRequest> validateLengthAsync(HttpRequest request) {
        BinaryData body = request.getBodyAsBinaryData();
        if (body == null) {
            return Mono.just(request);
        }
        return Mono.fromCallable(() -> {
            BinaryDataContent content = BinaryDataHelper.getContent(body);
            long expectedLength = Long.parseLong(request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
            if (content instanceof InputStreamContent) {
                LengthValidatingInputStream validatingInputStream = new LengthValidatingInputStream(content.toStream(), expectedLength);
                request.setBody(BinaryData.fromStream(validatingInputStream, expectedLength));
            } else if (content instanceof FluxByteBufferContent) {
                request.setBody(RestProxyUtils.validateFluxLength(body.toFluxByteBuffer(), expectedLength));
            } else {
                Long bodyLength = body.getLength();
                if (bodyLength != null) {
                    if (bodyLength < expectedLength) {
                        throw new UnexpectedLengthException(String.format(BODY_TOO_SMALL, bodyLength, expectedLength), bodyLength, expectedLength);
                    }
                    if (bodyLength > expectedLength) {
                        throw new UnexpectedLengthException(String.format(BODY_TOO_LARGE, bodyLength, expectedLength), bodyLength, expectedLength);
                    }
                } else {
                    request.setBody(RestProxyUtils.validateFluxLength(body.toFluxByteBuffer(), expectedLength));
                }
            }
            return request;
        });
    }

    private static Flux<ByteBuffer> validateFluxLength(Flux<ByteBuffer> bbFlux, long expectedLength) {
        if (bbFlux == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            long[] currentTotalLength = new long[1];
            return Flux.concat(bbFlux, Flux.just(VALIDATION_BUFFER)).handle((buffer, sink) -> {
                if (buffer == null) {
                    return;
                }
                if (buffer == VALIDATION_BUFFER) {
                    if (expectedLength != currentTotalLength[0]) {
                        sink.error(new UnexpectedLengthException(String.format(BODY_TOO_SMALL, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    } else {
                        sink.complete();
                    }
                    return;
                }
                currentTotalLength[0] = currentTotalLength[0] + (long)buffer.remaining();
                if (currentTotalLength[0] > expectedLength) {
                    sink.error(new UnexpectedLengthException(String.format(BODY_TOO_LARGE, currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    return;
                }
                sink.next(buffer);
            });
        });
    }

    public static BinaryData validateLengthSync(HttpRequest request) {
        BinaryData binaryData = request.getBodyAsBinaryData();
        if (binaryData == null) {
            return null;
        }
        long expectedLength = Long.parseLong(request.getHeaders().getValue(HttpHeaderName.CONTENT_LENGTH));
        Long length = binaryData.getLength();
        BinaryDataContent bdc = BinaryDataHelper.getContent(binaryData);
        if (bdc instanceof FluxByteBufferContent) {
            throw new IllegalStateException("Flux Byte Buffer is not supported in Synchronous Rest Proxy.");
        }
        if (bdc instanceof InputStreamContent) {
            InputStreamContent inputStreamContent = (InputStreamContent)bdc;
            InputStream inputStream = inputStreamContent.toStream();
            LengthValidatingInputStream lengthValidatingInputStream = new LengthValidatingInputStream(inputStream, expectedLength);
            return BinaryData.fromStream(lengthValidatingInputStream, expectedLength);
        }
        if (length == null) {
            byte[] b = bdc.toBytes();
            length = Integer.valueOf(b.length).longValue();
            RestProxyUtils.validateLength(length, expectedLength);
            return BinaryData.fromBytes(b);
        }
        RestProxyUtils.validateLength(length, expectedLength);
        return binaryData;
    }

    private static void validateLength(long length, long expectedLength) {
        if (length > expectedLength) {
            throw new UnexpectedLengthException(String.format(BODY_TOO_LARGE, length, expectedLength), length, expectedLength);
        }
        if (length < expectedLength) {
            throw new UnexpectedLengthException(String.format(BODY_TOO_SMALL, length, expectedLength), length, expectedLength);
        }
    }

    public static Context mergeRequestOptionsContext(Context context, RequestOptions options) {
        if (options == null) {
            return context;
        }
        Context optionsContext = options.getContext();
        if (optionsContext != null && optionsContext != Context.NONE) {
            context = CoreUtils.mergeContexts(context, optionsContext);
        }
        return context;
    }

    public static void validateResumeOperationIsNotPresent(Method method) {
        if (method.isAnnotationPresent(ResumeOperation.class)) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("'ResumeOperation' isn't supported."));
        }
    }

    public static SerializerAdapter createDefaultSerializer() {
        return JacksonAdapter.createDefaultSerializerAdapter();
    }

    public static HttpPipeline createDefaultPipeline() {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(new UserAgentPolicy());
        policies.add(new RetryPolicy());
        policies.add(new CookiePolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }
}

