/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.implementation.logging.LoggingUtils;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.LogLevel;
import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public final class LoggingEventBuilder {
    private static final JsonStringEncoder JSON_STRING_ENCODER = JsonStringEncoder.getInstance();
    private static final LoggingEventBuilder NOOP = new LoggingEventBuilder(null, null, null, false);
    private static final String AZURE_SDK_LOG_MESSAGE_JSON_START = "{\"az.sdk.message\":\"";
    private final Logger logger;
    private final LogLevel level;
    private List<ContextKeyValuePair> context;
    private final String globalContextCached;
    private final boolean hasGlobalContext;
    private final boolean isEnabled;

    static LoggingEventBuilder create(Logger logger, LogLevel level, String globalContextSerialized, boolean canLogAtLevel) {
        if (canLogAtLevel) {
            return new LoggingEventBuilder(logger, level, globalContextSerialized, true);
        }
        return NOOP;
    }

    private LoggingEventBuilder(Logger logger, LogLevel level, String globalContextSerialized, boolean isEnabled) {
        this.logger = logger;
        this.level = level;
        this.isEnabled = isEnabled;
        this.globalContextCached = globalContextSerialized == null ? "" : globalContextSerialized;
        this.hasGlobalContext = !this.globalContextCached.isEmpty();
    }

    public LoggingEventBuilder addKeyValue(String key, String value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Object value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, boolean value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, long value) {
        if (this.isEnabled) {
            this.addKeyValueInternal(key, value);
        }
        return this;
    }

    public LoggingEventBuilder addKeyValue(String key, Supplier<String> valueSupplier) {
        if (this.isEnabled) {
            if (this.context == null) {
                this.context = new ArrayList<ContextKeyValuePair>();
            }
            this.context.add(new ContextKeyValuePair(key, valueSupplier));
        }
        return this;
    }

    public void log(String message) {
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(message, null), null);
        }
    }

    public void log(Supplier<String> messageSupplier) {
        if (this.isEnabled) {
            String message = messageSupplier != null ? messageSupplier.get() : null;
            this.performLogging(this.level, this.getMessageWithContext(message, null), null);
        }
    }

    public void log(Supplier<String> messageSupplier, Throwable throwable) {
        if (this.isEnabled) {
            String message = messageSupplier != null ? messageSupplier.get() : null;
            this.performLogging(this.level, this.getMessageWithContext(message, throwable), this.logger.isDebugEnabled() ? throwable : null);
        }
    }

    public void log(String format, Object ... args) {
        if (this.isEnabled) {
            this.performLogging(this.level, format, args);
        }
    }

    public Throwable log(Throwable throwable) {
        Objects.requireNonNull(throwable, "'throwable' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(null, throwable), this.logger.isDebugEnabled() ? throwable : null);
        }
        return throwable;
    }

    public RuntimeException log(RuntimeException runtimeException) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        if (this.isEnabled) {
            this.performLogging(this.level, this.getMessageWithContext(null, runtimeException), this.logger.isDebugEnabled() ? runtimeException : null);
        }
        return runtimeException;
    }

    private String getMessageWithContext(String message, Throwable throwable) {
        if (message == null) {
            message = "";
        }
        StringBuilder sb = new StringBuilder(20 + (this.context == null ? 0 : this.context.size()) * 20 + message.length() + this.globalContextCached.length());
        sb.append(AZURE_SDK_LOG_MESSAGE_JSON_START);
        JSON_STRING_ENCODER.quoteAsString(message, sb);
        sb.append('\"');
        if (throwable != null) {
            sb.append(",\"exception\":");
            String exceptionMessage = throwable.getMessage();
            if (exceptionMessage != null) {
                sb.append('\"');
                JSON_STRING_ENCODER.quoteAsString(exceptionMessage, sb);
                sb.append('\"');
            } else {
                sb.append("null");
            }
        }
        if (this.hasGlobalContext) {
            sb.append(',').append(this.globalContextCached);
        }
        if (this.context != null) {
            for (ContextKeyValuePair contextKeyValuePair : this.context) {
                contextKeyValuePair.write(sb.append(','));
            }
        }
        sb.append('}');
        return sb.toString();
    }

    private void addKeyValueInternal(String key, Object value) {
        if (this.context == null) {
            this.context = new ArrayList<ContextKeyValuePair>();
        }
        this.context.add(new ContextKeyValuePair(key, value));
    }

    private void performLogging(LogLevel logLevel, String format, Object ... args) {
        Throwable throwable = null;
        if (LoggingUtils.doesArgsHaveThrowable(args)) {
            Object throwableObj = args[args.length - 1];
            if (throwableObj instanceof Throwable) {
                throwable = (Throwable)throwableObj;
            }
            if (!this.logger.isDebugEnabled()) {
                args = LoggingUtils.removeThrowable(args);
            }
        }
        FormattingTuple tuple = MessageFormatter.arrayFormat(format, args);
        String message = this.getMessageWithContext(tuple.getMessage(), throwable);
        this.performLogging(logLevel, message, tuple.getThrowable());
    }

    private void performLogging(LogLevel logLevel, String message, Throwable throwable) {
        switch (logLevel) {
            case VERBOSE: {
                this.logger.debug(message, throwable);
                break;
            }
            case INFORMATIONAL: {
                this.logger.info(message, throwable);
                break;
            }
            case WARNING: {
                this.logger.warn(message, throwable);
                break;
            }
            case ERROR: {
                this.logger.error(message, throwable);
                break;
            }
        }
    }

    static String writeJsonFragment(Map<String, Object> context) {
        if (CoreUtils.isNullOrEmpty(context)) {
            return "";
        }
        StringBuilder formatter = new StringBuilder(context.size() * 20);
        boolean firstValueWritten = false;
        for (Map.Entry<String, Object> pair : context.entrySet()) {
            if (firstValueWritten) {
                formatter.append(',');
            } else {
                firstValueWritten = true;
            }
            LoggingEventBuilder.writeKeyAndValue(pair.getKey(), pair.getValue(), formatter);
        }
        return formatter.toString();
    }

    private static void writeKeyAndValue(String key, Object value, StringBuilder formatter) {
        formatter.append('\"');
        JSON_STRING_ENCODER.quoteAsString(key, formatter);
        formatter.append("\":");
        if (value == null) {
            formatter.append("null");
        } else if (LoggingEventBuilder.isUnquotedType(value)) {
            JSON_STRING_ENCODER.quoteAsString(value.toString(), formatter);
        } else {
            formatter.append('\"');
            JSON_STRING_ENCODER.quoteAsString(value.toString(), formatter);
            formatter.append('\"');
        }
    }

    private static boolean isUnquotedType(Object value) {
        return value instanceof Boolean || value instanceof Number;
    }

    private static final class ContextKeyValuePair {
        private final String key;
        private final Object value;
        private final Supplier<String> valueSupplier;

        ContextKeyValuePair(String key, Object value) {
            this.key = key;
            this.value = value;
            this.valueSupplier = null;
        }

        ContextKeyValuePair(String key, Supplier<String> valueSupplier) {
            this.key = key;
            this.value = null;
            this.valueSupplier = valueSupplier;
        }

        public void write(StringBuilder formatter) {
            if (this.valueSupplier == null) {
                LoggingEventBuilder.writeKeyAndValue(this.key, this.value, formatter);
            } else {
                LoggingEventBuilder.writeKeyAndValue(this.key, this.valueSupplier.get(), formatter);
            }
        }
    }
}

