/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.actions;

import java.time.OffsetDateTime;
import java.util.HashMap;
import org.apache.unomi.api.ConsentStatus;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.graphql.utils.DateUtils;
import org.apache.unomi.graphql.utils.EventBuilder;

public class CDPConsentUpdateAction
implements ActionExecutor {
    private EventService eventService;

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public int execute(Action action, Event event) {
        String typeIdentifier = (String)event.getProperty("type");
        String consentStatus = (String)event.getProperty("status");
        OffsetDateTime lastUpdate = (OffsetDateTime)event.getProperty("lastUpdate");
        OffsetDateTime expiration = (OffsetDateTime)event.getProperty("expiration");
        Profile profile = event.getProfile();
        if (profile == null) {
            return 0;
        }
        profile.getConsents().forEach((key, consent) -> {
            if (key.endsWith("/" + typeIdentifier)) {
                if (consentStatus != null) {
                    consent.setStatus(ConsentStatus.valueOf((String)consentStatus));
                }
                if (lastUpdate != null) {
                    consent.setStatusDate(DateUtils.toDate(lastUpdate));
                }
                if (expiration != null) {
                    consent.setRevokeDate(DateUtils.toDate(expiration));
                }
            }
        });
        HashMap<String, Object> propertiesToUpdate = new HashMap<String, Object>();
        propertiesToUpdate.put("consents", profile.getConsents());
        Event updatePropertiesEvent = EventBuilder.create("updateProperties", profile).setPropertiesToUpdate(propertiesToUpdate).setPersistent(false).build();
        return this.eventService.send(updatePropertiesEvent);
    }
}

