/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.actions;

import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.types.output.CDPSessionState;

public class CDPSessionAction
implements ActionExecutor {
    private EventService eventService;
    private ProfileService profileService;

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    public int execute(Action action, Event event) {
        Optional<Session> sessionOp;
        CDPSessionState state = CDPSessionState.valueOf((String)event.getProperty("state"));
        String sessionId = (String)event.getProperty("sessionId");
        String scope = (String)event.getProperty("scope");
        Profile profile = event.getProfile();
        if (profile == null) {
            return 0;
        }
        if (state == CDPSessionState.START) {
            Session session2 = new Session(sessionId, profile, new Date(), scope);
            session2.setProperty("state", (Object)state);
            int eventCode = this.eventService.send(new Event("sessionCreated", session2, profile, scope, null, (Item)session2, null, event.getTimeStamp(), false));
            this.profileService.saveSession(session2);
            return eventCode;
        }
        PartialList sessionList = this.profileService.findProfileSessions(profile.getItemId());
        if (sessionList != null && (sessionOp = sessionList.getList().stream().filter(session -> Objects.equals(session.getItemId(), sessionId) && Objects.equals(session.getScope(), scope)).findFirst()).isPresent()) {
            Session sessionToUpdate = sessionOp.get();
            sessionToUpdate.setProperty("state", (Object)state);
            this.profileService.saveSession(sessionToUpdate);
            return 2;
        }
        return 0;
    }
}

