/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.graphql.utils.EventBuilder;

public class CDPUpdateListsAction
implements ActionExecutor {
    private EventService eventService;

    public void setEventService(EventService eventService) {
        this.eventService = eventService;
    }

    public int execute(Action action, Event event) {
        List joinLists = (List)event.getProperty("joinLists");
        List leaveLists = (List)event.getProperty("leaveLists");
        Profile profile = event.getProfile();
        ArrayList<String> existingLists = (ArrayList<String>)profile.getSystemProperties().get("lists");
        if (existingLists == null) {
            existingLists = new ArrayList<String>();
        }
        if (!existingLists.isEmpty() && leaveLists != null && !leaveLists.isEmpty()) {
            existingLists.removeAll(leaveLists);
        }
        if (joinLists != null && !joinLists.isEmpty()) {
            for (String newListIdentifier : joinLists) {
                if (existingLists.contains(newListIdentifier)) continue;
                existingLists.add(newListIdentifier);
            }
        }
        HashMap<String, Object> propertyToUpdate = new HashMap<String, Object>();
        propertyToUpdate.put("systemProperties.lists", existingLists);
        Event updatePropertiesEvent = EventBuilder.create("updateProperties", profile).setPropertiesToUpdate(propertyToUpdate).setPersistent(false).build();
        return this.eventService.send(updatePropertiesEvent);
    }
}

