/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import org.apache.unomi.api.ProfileAlias;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.CDPProfileAliasInput;
import org.apache.unomi.graphql.types.output.CDPProfileAlias;
import org.apache.unomi.persistence.spi.PersistenceService;

public class AddAliasToProfileCommand
extends BaseCommand<CDPProfileAlias> {
    private final CDPProfileAliasInput profileAliasInput;

    public AddAliasToProfileCommand(Builder builder) {
        super(builder);
        this.profileAliasInput = builder.profileAliasInput;
    }

    @Override
    public CDPProfileAlias execute() {
        ProfileService profileService = this.serviceManager.getService(ProfileService.class);
        profileService.addAliasToProfile(this.profileAliasInput.getProfileID().getId(), this.profileAliasInput.getAlias(), this.profileAliasInput.getProfileID().getClient().getId());
        PersistenceService persistenceService = this.serviceManager.getService(PersistenceService.class);
        persistenceService.refreshIndex(ProfileAlias.class, null);
        return new CDPProfileAlias((ProfileAlias)persistenceService.load(this.profileAliasInput.getAlias(), ProfileAlias.class));
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        private CDPProfileAliasInput profileAliasInput;

        public Builder profileAliasInput(CDPProfileAliasInput profileAliasInput) {
            this.profileAliasInput = profileAliasInput;
            return this;
        }

        public AddAliasToProfileCommand build() {
            return new AddAliasToProfileCommand(this);
        }
    }
}

