/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import graphql.schema.DataFetchingEnvironment;
import java.util.Objects;
import org.apache.unomi.graphql.services.ServiceManager;

public abstract class BaseCommand<T> {
    protected final DataFetchingEnvironment environment;
    protected final ServiceManager serviceManager;

    public abstract T execute();

    public BaseCommand(Builder builder) {
        this.environment = builder.environment;
        this.serviceManager = (ServiceManager)this.environment.getContext();
    }

    public static abstract class Builder<B extends Builder> {
        protected DataFetchingEnvironment environment;

        public B setEnvironment(DataFetchingEnvironment environment) {
            this.environment = environment;
            return (B)this;
        }

        public void validate() {
            Objects.requireNonNull(this.environment, "Environment can not be null");
        }
    }
}

