/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.unomi.api.Consent;
import org.apache.unomi.api.ConsentStatus;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;
import org.apache.unomi.graphql.types.input.CDPPersonaConsentInput;
import org.apache.unomi.graphql.types.input.CDPPersonaInput;
import org.apache.unomi.graphql.types.input.CDPProfileIDInput;
import org.apache.unomi.graphql.types.output.CDPPersona;
import org.apache.unomi.graphql.utils.DateUtils;

public class CreateOrUpdatePersonaCommand
extends BaseCommand<CDPPersona> {
    private final CDPPersonaInput personaInput;

    private CreateOrUpdatePersonaCommand(Builder builder) {
        super(builder);
        this.personaInput = builder.personaInput;
    }

    public static Builder create(CDPPersonaInput personaInput) {
        return new Builder(personaInput);
    }

    @Override
    public CDPPersona execute() {
        ProfileService profileService = this.serviceManager.getService(ProfileService.class);
        Map personaAsMap = (Map)this.environment.getArgument("persona");
        Persona persona = profileService.savePersona(this.createPersona(this.personaInput, personaAsMap));
        return new CDPPersona(persona);
    }

    private Persona createPersona(CDPPersonaInput personaInput, Map<String, Object> personaAsMap) {
        Persona persona = new Persona(personaInput.getId());
        persona.setScope(personaInput.getCdp_view());
        persona.getProperties().put("cdp_name", personaInput.getCdp_name());
        if (personaInput.getCdp_profileIDs() != null && !personaInput.getCdp_profileIDs().isEmpty()) {
            String profileIds = personaInput.getCdp_profileIDs().stream().map(CDPProfileIDInput::getId).collect(Collectors.joining(","));
            persona.setMergedWith(profileIds);
        }
        persona.setSegments(personaInput.getCdp_segments());
        if (personaInput.getCdp_consents() != null && !personaInput.getCdp_consents().isEmpty()) {
            personaInput.getCdp_consents().forEach(consentInput -> persona.setConsent(this.createConsent(personaInput.getCdp_view(), (CDPPersonaConsentInput)consentInput)));
        }
        if (personaInput.getCdp_interests() != null && !personaInput.getCdp_consents().isEmpty()) {
            HashMap interestMap = new HashMap();
            personaInput.getCdp_interests().forEach(interestInput -> {
                Integer intScore = interestInput.getScore() != null ? Integer.valueOf(interestInput.getScore().intValue()) : null;
                interestMap.put(interestInput.getTopic(), intScore);
            });
            persona.setScores(interestMap);
        }
        personaAsMap.forEach((graphQlName, value) -> persona.setProperty(PropertyNameTranslator.translateFromGraphQLToUnomi(graphQlName), value));
        return persona;
    }

    private Consent createConsent(String scope, CDPPersonaConsentInput consentInput) {
        return new Consent(scope, consentInput.getType(), ConsentStatus.valueOf((String)consentInput.getStatus()), DateUtils.toDate(consentInput.getLastUpdate()), DateUtils.toDate(consentInput.getExpiration()));
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        final CDPPersonaInput personaInput;

        Builder(CDPPersonaInput personaInput) {
            this.personaInput = personaInput;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.personaInput == null) {
                throw new IllegalArgumentException("Persona input can not be null.");
            }
        }

        public CreateOrUpdatePersonaCommand build() {
            this.validate();
            return new CreateOrUpdatePersonaCommand(this);
        }
    }
}

