/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.schema.GraphQLSchemaUpdater;
import org.apache.unomi.graphql.types.input.CDPPropertyInput;
import org.apache.unomi.graphql.types.input.property.BaseCDPPropertyInput;
import org.apache.unomi.graphql.types.input.property.CDPSetPropertyInput;

public class CreateOrUpdateProfilePropertiesCommand
extends BaseCommand<Boolean> {
    private final List<CDPPropertyInput> properties;
    private ProfileService profileService;

    private CreateOrUpdateProfilePropertiesCommand(Builder builder) {
        super(builder);
        this.properties = builder.properties;
        this.profileService = this.serviceManager.getService(ProfileService.class);
    }

    public static Builder create(List<CDPPropertyInput> properties) {
        return new Builder(properties);
    }

    @Override
    public Boolean execute() {
        this.properties.forEach(cdpPropertyInput -> {
            PropertyType propertyType = this.processPropertyType((CDPPropertyInput)cdpPropertyInput);
            this.profileService.setPropertyType(propertyType);
        });
        this.serviceManager.getService(GraphQLSchemaUpdater.class).updateSchema();
        return true;
    }

    private PropertyType processPropertyType(CDPPropertyInput propertyInput) {
        BaseCDPPropertyInput cdpPropertyTypeInput = propertyInput.getProperty();
        PropertyType propertyType = this.profileService.getPropertyType(cdpPropertyTypeInput.getName());
        if (propertyType == null) {
            propertyType = new PropertyType();
        } else if (!propertyType.getValueTypeId().equals(cdpPropertyTypeInput.getCDPPropertyType())) {
            this.profileService.deletePropertyType(cdpPropertyTypeInput.getName());
        }
        if (cdpPropertyTypeInput instanceof CDPSetPropertyInput) {
            CDPSetPropertyInput cdpSetPropertyInput = (CDPSetPropertyInput)cdpPropertyTypeInput;
            Set propertyTypes = cdpSetPropertyInput.getProperties().stream().map(this::processPropertyType).collect(Collectors.toSet());
            propertyType.setChildPropertyTypes(propertyTypes);
        }
        cdpPropertyTypeInput.updateType(propertyType);
        return propertyType;
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        final List<CDPPropertyInput> properties;

        Builder(List<CDPPropertyInput> properties) {
            this.properties = properties;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.properties == null || this.properties.isEmpty()) {
                throw new IllegalArgumentException("Properties can not be null or empty.");
            }
            this.properties.forEach(prop -> {
                List<BaseCDPPropertyInput> properties = Arrays.asList(prop.getIdentifierPropertyTypeInput(), prop.getStringPropertyTypeInput(), prop.getIntegerPropertyTypeInput(), prop.getLongPropertyTypeInput(), prop.getFloatPropertyTypeInput(), prop.getDatePropertyTypeInput(), prop.getBooleanPropertyTypeInput(), prop.getGeoPointPropertyTypeInput(), prop.getSetPropertyTypeInput(), prop.getJsonPropertyTypeInput());
                List filteredProperties = properties.stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (filteredProperties.size() != 1) {
                    throw new IllegalArgumentException("Only one field is allowed to have a value corresponding to the declared property value type.  All other value fields must be null.");
                }
            });
        }

        public CreateOrUpdateProfilePropertiesCommand build() {
            this.validate();
            return new CreateOrUpdateProfilePropertiesCommand(this);
        }
    }
}

