/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Objects;
import org.apache.unomi.api.Scope;
import org.apache.unomi.api.services.ScopeService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.CDPSourceInput;
import org.apache.unomi.graphql.types.output.CDPSource;

public class CreateOrUpdateSourceCommand
extends BaseCommand<CDPSource> {
    private final CDPSourceInput sourceInput;

    private CreateOrUpdateSourceCommand(Builder builder) {
        super(builder);
        this.sourceInput = builder.sourceInput;
    }

    @Override
    public CDPSource execute() {
        ScopeService scopeService = this.serviceManager.getService(ScopeService.class);
        Scope scope = scopeService.getScope(this.sourceInput.getId());
        if (scope == null) {
            scope = new Scope();
            scope.setItemId(this.sourceInput.getId());
        }
        scopeService.save(scope);
        return new CDPSource(scope.getItemId(), false);
    }

    public static Builder create(CDPSourceInput topicInput) {
        return new Builder(topicInput);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        final CDPSourceInput sourceInput;

        public Builder(CDPSourceInput sourceInput) {
            this.sourceInput = sourceInput;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.sourceInput, "Source can not be null");
            Objects.requireNonNull(this.sourceInput.getId(), "SourceID can not be null");
        }

        public CreateOrUpdateSourceCommand build() {
            this.validate();
            return new CreateOrUpdateSourceCommand(this);
        }
    }
}

