/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Topic;
import org.apache.unomi.api.services.TopicService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.CDPTopicInput;
import org.apache.unomi.graphql.types.output.CDPTopic;

public class CreateOrUpdateTopicCommand
extends BaseCommand<CDPTopic> {
    private final CDPTopicInput topicInput;

    private CreateOrUpdateTopicCommand(Builder builder) {
        super(builder);
        this.topicInput = builder.topicInput;
    }

    @Override
    public CDPTopic execute() {
        TopicService topicService = this.serviceManager.getService(TopicService.class);
        Topic topic = topicService.load(this.topicInput.getId());
        if (topic == null) {
            topic = new Topic();
        }
        String topicId = StringUtils.isEmpty((CharSequence)this.topicInput.getId()) ? this.topicInput.getName() : this.topicInput.getId();
        topic.setTopicId(topicId);
        topic.setItemId(topicId);
        topic.setName(this.topicInput.getName());
        topic.setScope(this.topicInput.getView());
        Topic storedTopic = topicService.save(topic);
        return new CDPTopic(storedTopic);
    }

    public static Builder create(CDPTopicInput topicInput) {
        return new Builder(topicInput);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        final CDPTopicInput topicInput;

        public Builder(CDPTopicInput topicInput) {
            this.topicInput = topicInput;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.topicInput, "Topic can not be null");
            Objects.requireNonNull(this.topicInput.getView(), "View can not be null");
            Objects.requireNonNull(this.topicInput.getName(), "Name can not be null");
        }

        public CreateOrUpdateTopicCommand build() {
            this.validate();
            return new CreateOrUpdateTopicCommand(this);
        }
    }
}

