/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Objects;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.CDPViewInput;
import org.apache.unomi.graphql.types.output.CDPView;

public class CreateOrUpdateViewCommand
extends BaseCommand<CDPView> {
    private final CDPViewInput viewInput;

    private CreateOrUpdateViewCommand(Builder builder) {
        super(builder);
        this.viewInput = builder.viewInput;
    }

    @Override
    public CDPView execute() {
        return new CDPView(this.viewInput.getName());
    }

    public static Builder create(CDPViewInput viewInput) {
        return new Builder(viewInput);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        final CDPViewInput viewInput;

        public Builder(CDPViewInput viewInput) {
            this.viewInput = viewInput;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.viewInput, "View can not be null");
            Objects.requireNonNull(this.viewInput.getName(), "Name can not be null");
        }

        public CreateOrUpdateViewCommand build() {
            this.validate();
            return new CreateOrUpdateViewCommand(this);
        }
    }
}

