/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.services.ServiceManager;

public class DeleteAllPersonalDataCommand
extends BaseCommand<Boolean> {
    private DeleteAllPersonalDataCommand(Builder builder) {
        super(builder);
    }

    @Override
    public Boolean execute() {
        ServiceManager serviceManager = (ServiceManager)this.environment.getContext();
        Map cdpProfileIdInput = (Map)this.environment.getArgument("profileID");
        String profileId = (String)cdpProfileIdInput.get("id");
        Profile profile = serviceManager.getService(ProfileService.class).load(profileId);
        if (profile == null) {
            return false;
        }
        return serviceManager.getService(PrivacyService.class).deleteProfileData(profileId, false);
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        @Override
        public void validate() {
            super.validate();
            Map cdpProfileIDInput = (Map)this.environment.getArgument("profileID");
            Objects.requireNonNull(cdpProfileIDInput, "The \"profileID\" variable can not be null");
            String personaId = (String)cdpProfileIDInput.get("id");
            if (StringUtils.isEmpty((CharSequence)personaId)) {
                throw new IllegalArgumentException("The \"id\" variable can not be null or empty");
            }
        }

        public DeleteAllPersonalDataCommand build() {
            this.validate();
            return new DeleteAllPersonalDataCommand(this);
        }
    }
}

