/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Map;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.services.ServiceManager;

public class DeleteProfileCommand
extends BaseCommand<Boolean> {
    private DeleteProfileCommand(Builder builder) {
        super(builder);
    }

    @Override
    public Boolean execute() {
        ServiceManager serviceManager = (ServiceManager)this.environment.getContext();
        Map cdpProfileIdInput = (Map)this.environment.getArgument("profileID");
        String profileId = (String)cdpProfileIdInput.get("id");
        ProfileService profileService = serviceManager.getService(ProfileService.class);
        Profile profile = profileService.load(profileId);
        if (profile == null) {
            throw new IllegalStateException(String.format("The profile with id \"%s\" not found", profileId));
        }
        profileService.delete(profileId, false);
        return true;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        public DeleteProfileCommand build() {
            this.validate();
            return new DeleteProfileCommand(this);
        }
    }
}

