/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.schema.GraphQLSchemaUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteProfilePropertiesCommand
extends BaseCommand<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteProfilePropertiesCommand.class);
    private final List<String> propertyNames;

    private DeleteProfilePropertiesCommand(Builder builder) {
        super(builder);
        this.propertyNames = builder.propertyNames;
    }

    @Override
    public Boolean execute() {
        ProfileService profileService = this.serviceManager.getService(ProfileService.class);
        Collection propertyTypes = profileService.getTargetPropertyTypes("profiles");
        List persistedPropertyNames = propertyTypes.stream().map(Item::getItemId).collect(Collectors.toList());
        ArrayList<String> incorrectPropertyNames = new ArrayList<String>(this.propertyNames);
        incorrectPropertyNames.removeAll(persistedPropertyNames);
        if (!incorrectPropertyNames.isEmpty()) {
            throw new IllegalArgumentException(String.format("The properties \"%s\" do not belong to profile", ((Object)incorrectPropertyNames).toString()));
        }
        for (String propertyName : this.propertyNames) {
            try {
                boolean deleted = profileService.deletePropertyType(propertyName);
                if (deleted) {
                    LOGGER.info("The property \"{}\" of profile was deleted successfully", (Object)propertyName);
                    continue;
                }
                LOGGER.info("The property \"{}\" of profile was not deleted", (Object)propertyName);
            }
            catch (Exception e) {
                LOGGER.error("The delete property \"{}\" is failed", (Object)propertyName, (Object)e);
            }
        }
        this.serviceManager.getService(GraphQLSchemaUpdater.class).updateSchema();
        return true;
    }

    public static Builder create(List<String> propertyNames) {
        return new Builder(propertyNames);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        private final List<String> propertyNames;

        public Builder(List<String> propertyNames) {
            this.propertyNames = propertyNames;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.propertyNames == null || this.propertyNames.isEmpty()) {
                throw new IllegalArgumentException("The \"propertyNames\" variable can not be null or empty");
            }
        }

        public DeleteProfilePropertiesCommand build() {
            this.validate();
            return new DeleteProfilePropertiesCommand(this);
        }
    }
}

