/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Objects;
import org.apache.unomi.api.services.ScopeService;
import org.apache.unomi.graphql.commands.BaseCommand;

public class DeleteSourceCommand
extends BaseCommand<Boolean> {
    private final String sourceId;

    public DeleteSourceCommand(Builder builder) {
        super(builder);
        this.sourceId = builder.sourceId;
    }

    @Override
    public Boolean execute() {
        return this.serviceManager.getService(ScopeService.class).delete(this.sourceId);
    }

    public static Builder create(String sourceId) {
        return new Builder(sourceId);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        final String sourceId;

        public Builder(String sourceId) {
            this.sourceId = sourceId;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.sourceId, "SourceID can not be null");
        }

        public DeleteSourceCommand build() {
            this.validate();
            return new DeleteSourceCommand(this);
        }
    }
}

