/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import java.util.Objects;
import org.apache.unomi.api.services.TopicService;
import org.apache.unomi.graphql.commands.BaseCommand;

public class DeleteTopicCommand
extends BaseCommand<Boolean> {
    private final String topicId;

    public DeleteTopicCommand(Builder builder) {
        super(builder);
        this.topicId = builder.topicId;
    }

    @Override
    public Boolean execute() {
        TopicService topicService = this.serviceManager.getService(TopicService.class);
        return topicService.delete(this.topicId);
    }

    public static Builder create(String topicId) {
        return new Builder(topicId);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        final String topicId;

        public Builder(String topicId) {
            this.topicId = topicId;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.topicId, "TopicID can not be null");
        }

        public DeleteTopicCommand build() {
            this.validate();
            return new DeleteTopicCommand(this);
        }
    }
}

