/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import graphql.language.InputObjectTypeDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.BaseProfileEventProcessor;
import org.apache.unomi.graphql.types.input.CDPEventInput;
import org.apache.unomi.graphql.types.input.CDPEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEventsCommand
extends BaseCommand<Integer> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ProcessEventsCommand.class.getName());
    private static final List<String> STATIC_FIELDS = new ArrayList<String>();
    private final List<CDPEventInput> eventInputs;
    private final List<LinkedHashMap<String, Object>> eventsAsMap;
    private final List<GraphQLInputObjectField> fieldDefinitions;
    private final AtomicInteger processedEventsQty = new AtomicInteger();

    private ProcessEventsCommand(Builder builder) {
        super(builder);
        this.eventInputs = builder.eventInputs;
        this.eventsAsMap = (List)this.environment.getArgument("events");
        GraphQLInputObjectType objectType = (GraphQLInputObjectType)this.environment.getGraphQLSchema().getType("CDP_EventInput");
        this.fieldDefinitions = objectType.getFieldDefinitions();
    }

    @Override
    public Integer execute() {
        for (int i = 0; i < this.eventInputs.size(); ++i) {
            CDPEventInput eventInput = this.eventInputs.get(i);
            LinkedHashMap<String, Object> eventInputAsMap = this.eventsAsMap.get(i);
            this.processStaticFields(eventInput, eventInputAsMap);
            this.processDynamicFields(eventInputAsMap);
        }
        return this.processedEventsQty.get();
    }

    private void processStaticFields(CDPEventInput eventInput, LinkedHashMap<String, Object> eventInputAsMap) {
        ArrayList<BaseProfileEventProcessor> eventProcessors = new ArrayList<BaseProfileEventProcessor>();
        eventProcessors.add(eventInput.getCdp_consentUpdateEvent());
        eventProcessors.add(eventInput.getCdp_listUpdateEvent());
        eventProcessors.add(eventInput.getCdp_sessionEvent());
        eventProcessors.stream().filter(Objects::nonNull).forEach(eventProcessor -> {
            try {
                Event event = eventProcessor.buildEvent(eventInputAsMap, this.environment);
                if (event != null) {
                    this.processEvent(event);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Process field {} is failed. enable debug log to see the full stack trace", (Object)eventProcessor.getFieldName());
                LOGGER.debug("Process field failed", (Throwable)e);
            }
        });
    }

    private void processDynamicFields(LinkedHashMap<String, Object> eventInputAsMap) {
        this.fieldDefinitions.forEach(fieldDefinition -> {
            if (!STATIC_FIELDS.contains(fieldDefinition.getName())) {
                try {
                    this.processField((GraphQLInputObjectField)fieldDefinition, eventInputAsMap);
                }
                catch (Exception e) {
                    LOGGER.warn("Process field {} is failed. enable debug log to see the full stack trace", fieldDefinition);
                    LOGGER.debug("Process field failed", (Throwable)e);
                }
            }
        });
    }

    private boolean processField(GraphQLInputObjectField fieldDefinition, LinkedHashMap<String, Object> eventInputAsMap) throws Exception {
        GraphQLInputObjectType inputObjectType;
        InputObjectTypeDefinition typeDefinition;
        if (!eventInputAsMap.containsKey(fieldDefinition.getName())) {
            return false;
        }
        if (fieldDefinition.getType() instanceof GraphQLInputObjectType && (typeDefinition = (inputObjectType = (GraphQLInputObjectType)fieldDefinition.getType()).getDefinition()) != null && typeDefinition.getAdditionalData().containsKey("eventProcessorClass")) {
            String className = (String)typeDefinition.getAdditionalData().get("eventProcessorClass");
            this.buildAndProcessEvent(className, eventInputAsMap);
            return true;
        }
        return false;
    }

    private void buildAndProcessEvent(String className, LinkedHashMap<String, Object> eventInputAsMap) throws Exception {
        Event event;
        Constructor<?> constructor = Class.forName(className).getConstructor(new Class[0]);
        Object instance = constructor.newInstance(new Object[0]);
        if (instance instanceof CDPEventProcessor && (event = ((CDPEventProcessor)instance).buildEvent(eventInputAsMap, this.environment)) != null) {
            this.processEvent(event);
        }
    }

    private void processEvent(Event event) {
        int eventCode = this.serviceManager.getService(EventService.class).send(event);
        if (eventCode == 4) {
            this.serviceManager.getService(ProfileService.class).save(event.getProfile());
        }
        this.processedEventsQty.incrementAndGet();
    }

    public static Builder create(List<CDPEventInput> eventInputs) {
        return new Builder(eventInputs);
    }

    static {
        STATIC_FIELDS.add("cdp_consentUpdateEvent");
        STATIC_FIELDS.add("cdp_listsUpdateEvent");
        STATIC_FIELDS.add("cdp_sessionEvent");
    }

    public static final class Builder
    extends BaseCommand.Builder<Builder> {
        private final List<CDPEventInput> eventInputs;

        public Builder(List<CDPEventInput> eventInputs) {
            this.eventInputs = eventInputs;
        }

        @Override
        public void validate() {
            super.validate();
            List events = (List)this.environment.getArgument("events");
            if (events == null || events.isEmpty()) {
                throw new IllegalArgumentException("The \"events\" variable can not be null or empty");
            }
            events.forEach(eventInput -> {
                Objects.requireNonNull(eventInput.get("cdp_objectID"), "The \"cdp_objectID\" field can not be null");
                Objects.requireNonNull(eventInput.get("cdp_profileID"), "The \"cdp_profileID\" field can not be null");
            });
        }

        public ProcessEventsCommand build() {
            this.validate();
            return new ProcessEventsCommand(this);
        }
    }
}

